/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.core.impl;

import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.DownloadService;
import com.binfer.base.service.FileService;
import com.binfer.base.service.IBinfer;
import com.binfer.base.service.IFile;
import com.binfer.base.service.IOService;
import com.binfer.base.service.IPreferences;
import com.binfer.base.service.ISpace;
import com.binfer.base.service.IUser;
import com.binfer.base.service.LogService;
import com.binfer.base.service.SchedulerService;
import com.binfer.base.util.IPagedResult;
import com.binfer.base.util.NoNextPageException;
import com.binfer.base.util.TimeUtil;
import com.binfer.base.xml.XMLUtil;
import com.binfer.core.service.IReportService;
import com.binfer.core.service.IService;
import java.io.File;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public final class D
implements IReportService {
    IService a;
    private 1 b = new Runnable(this){
        private /* synthetic */ D a;
        {
            this.a = d2;
        }

        @Override
        public final void run() {
            if (this.a.a.allowTransfers()) {
                Thread.currentThread().setName("B.REPORTS");
                try {
                    if (Boolean.parseBoolean(this.a.a.getPreferencesService().getPref(IPreferences.REPORT_AUTO_ENABLED, "false"))) {
                        this.a.saveReportAsXML();
                    }
                    return;
                }
                catch (Exception exception) {
                    LogService.log("Failed to save report because " + exception.getMessage(), Level.SEVERE);
                    exception.printStackTrace();
                }
            }
        }
    };
    private AtomicBoolean c = new AtomicBoolean(false);

    public D(IService iService) {
        this.a = iService;
        try {
            D d2 = this;
            d2.schedule(d2.getPollTime());
            return;
        }
        catch (Exception exception) {
            LogService.log("failed to schedule automatic reports because " + exception.getMessage(), Level.SEVERE);
            return;
        }
    }

    @Override
    public final void schedule(int n2) throws Exception {
        if (BinferProperties.getBooleanProperty(IPreferences.STARTREPORTWORK, true)) {
            try {
                SchedulerService.getInstance().cancelWork("Report Task");
            }
            catch (Exception exception) {}
            if (!BinferProperties.getProperty(IPreferences.INSTALLTYPE).equalsIgnoreCase(IBinfer.INSTALL_TYPE.SERVER_MANAGED.name())) {
                SchedulerService.getInstance().scheduleWork("Report Task", this.b, null, n2, TimeUnit.MINUTES);
                LogService.log("auto report scheduled to run every " + n2 + " minutes", Level.WARNING);
                return;
            }
        } else {
            LogService.log("!report service not started", Level.WARNING);
        }
    }

    @Override
    public final void close() {
        try {
            SchedulerService.getInstance().cancelWork("Report Task");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public final void setEnabled(boolean bl) throws Exception {
        this.a.getPreferencesService().setPref(IPreferences.REPORT_AUTO_ENABLED, Boolean.toString(bl));
    }

    @Override
    public final boolean isEnabled() {
        return this.a.getPreferencesService().getBooleanPref(IPreferences.REPORT_AUTO_ENABLED, false);
    }

    @Override
    public final File getDefaultReportFolder() {
        File file = new File(DownloadService.getDataDir(), "Reports");
        file.mkdirs();
        return file;
    }

    @Override
    public final File getReportFolder() {
        String string = this.a.getPreferencesService().getPref(IPreferences.REPORT_AUTO_LOCATION, this.getDefaultReportFolder().getAbsolutePath());
        return new File(string);
    }

    @Override
    public final void setReportFolder(File file) throws Exception {
        this.a.getPreferencesService().setPref(IPreferences.REPORT_AUTO_LOCATION, file.getAbsolutePath());
    }

    @Override
    public final File getReportFileName() {
        Object object = Calendar.getInstance();
        object = "binfer-report-" + ((Calendar)object).get(5) + "-" + ((Calendar)object).getDisplayName(2, 2, Locale.ENGLISH) + "-" + ((Calendar)object).get(1) + "-" + ((Calendar)object).get(11) + "-" + ((Calendar)object).get(12) + ".xml";
        return new File(this.getReportFolder(), (String)object);
    }

    @Override
    public final File saveReportAsXML() throws Exception {
        File file;
        if (this.c.get()) {
            return null;
        }
        this.c.set(true);
        try {
            long l2 = System.currentTimeMillis();
            Iterator iterator = this;
            Object object = Calendar.getInstance();
            Object object2 = "binfer-report-" + ((Calendar)object).get(5) + "-" + ((Calendar)object).getDisplayName(2, 2, Locale.ENGLISH) + "-" + ((Calendar)object).get(1) + "-" + ((Calendar)object).get(11) + "-" + ((Calendar)object).get(12) + ".xml.part";
            Object object3 = ((D)((Object)iterator)).a.getPreferencesService().getPref(IPreferences.REPORT_AUTO_LOCATION, ((D)((Object)iterator)).getDefaultReportFolder().getAbsolutePath());
            new File((String)object3).mkdirs();
            File file2 = new File((String)object3, (String)object2);
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.set(10, 0);
            calendar2.set(12, 0);
            calendar2.set(13, 0);
            PrintWriter printWriter = new PrintWriter(file2);
            Throwable throwable = null;
            try {
                String string;
                printWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                printWriter.write("<REPORT>");
                object3 = calendar2;
                object2 = calendar;
                object = printWriter;
                iterator = this.a.getFilesService().getXferLogs(IFile.FILE_STATUS_SENT, "*", ((Calendar)object3).getTime(), ((Calendar)object2).getTime());
                int n2 = 1;
                ((PrintWriter)object).write("<SENT>");
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    object3 = (Map)iterator.next();
                    ((PrintWriter)object).write("<LOG>");
                    try {
                        ((PrintWriter)object).write(XMLUtil.xmlTag("INDEX", Integer.toString(n2++)));
                        for (String string2 : object3.keySet()) {
                            try {
                                if (string2.equalsIgnoreCase(IUser.FNAME) || string2.equalsIgnoreCase("STATUS") | string2.equalsIgnoreCase(IFile.FILEID) || string2.equalsIgnoreCase(ISpace.SPACEID) || string2.equalsIgnoreCase(IUser.DEVICEID) || string2.equalsIgnoreCase(IUser.USERID) || string2.equalsIgnoreCase(IUser.DEVICEIDCONTACT)) continue;
                                string = ((String)object3.get(string2)).toString();
                                ((PrintWriter)object).write(XMLUtil.xmlTag(string2, string));
                            }
                            catch (Exception exception) {}
                        }
                        D.a((PrintWriter)object, (Map<String, String>)object3);
                    }
                    catch (Exception exception) {}
                    ((PrintWriter)object).write("</LOG>");
                }
                ((PrintWriter)object).write("</SENT>");
                object3 = calendar2;
                Calendar calendar3 = calendar;
                object = printWriter;
                iterator = this.a.getFilesService().getXferLogs(IFile.FILE_STATUS_RECEIVED, "*", ((Calendar)object3).getTime(), calendar3.getTime());
                int n3 = 1;
                ((PrintWriter)object).write("<RECEIVED>");
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    object3 = (Map)iterator.next();
                    ((PrintWriter)object).write("<LOG>");
                    try {
                        ((PrintWriter)object).write(XMLUtil.xmlTag("INDEX", Integer.toString(n3++)));
                        for (String string2 : object3.keySet()) {
                            try {
                                if (string2.equalsIgnoreCase(IUser.FNAME) || string2.equalsIgnoreCase("STATUS") | string2.equalsIgnoreCase(IFile.FILEID) || string2.equalsIgnoreCase(ISpace.SPACEID) || string2.equalsIgnoreCase(IUser.DEVICEID) || string2.equalsIgnoreCase(IUser.USERID) || string2.equalsIgnoreCase(IUser.DEVICEIDCONTACT)) continue;
                                string = ((String)object3.get(string2)).toString();
                                ((PrintWriter)object).write(XMLUtil.xmlTag(string2, string));
                            }
                            catch (Exception exception) {}
                        }
                        D.a((PrintWriter)object, (Map<String, String>)object3);
                    }
                    catch (Exception exception) {}
                    ((PrintWriter)object).write("</LOG>");
                }
                ((PrintWriter)object).write("</RECEIVED>");
                printWriter.write("</REPORT>");
                printWriter.close();
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (throwable != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        printWriter.close();
                    }
                    throw throwable3;
                }
            }
            try {
                long l3 = System.currentTimeMillis();
                long l4 = TimeUnit.MILLISECONDS.toMinutes(l3 - l2);
                if (l4 > 0L && l4 > (long)this.getPollTime()) {
                    int n4 = new Long(l4 + 2L).intValue();
                    this.a.getPreferencesService().setPref(IPreferences.REPORT_AUTO_MINUTES, Integer.toString(n4));
                    this.schedule(n4);
                    LogService.log("adjusted reporting poll time to new value as previous run took long time:".concat(String.valueOf(n4)), Level.WARNING);
                }
            }
            catch (Exception exception) {}
            file = this.getReportFileName();
            if (file.exists()) {
                file.delete();
            }
            file2.renameTo(file);
        }
        catch (Exception exception) {
            LogService.log("Error creating because:" + exception.getMessage(), Level.SEVERE);
            File file3 = this.getReportFileName();
            LogService.log("!ERROR. Failed to create report at path " + file3.getAbsolutePath() + " because " + exception.getMessage(), Level.SEVERE);
            throw exception;
        }
        finally {
            this.c.set(false);
        }
        return file;
    }

    private static void a(PrintWriter printWriter, Map<String, String> map) {
        long l2;
        long l3 = 0L;
        try {
            l3 = Long.parseLong(map.get("SIZE_COMPRESSED"));
        }
        catch (Exception exception) {}
        if (l3 <= 0L) {
            l3 = Long.parseLong(map.get("SIZE"));
        }
        printWriter.write(XMLUtil.xmlTag("SIZE", Long.toString(l3)));
        try {
            long l4 = (Long.parseLong(map.get("BANDWIDTH")) << 10) / 8L;
            l2 = l3 / l4;
            if (l2 <= 0L) {
                l2 = 0L;
            }
        }
        catch (Exception exception) {
            l2 = 0L;
        }
        printWriter.write(XMLUtil.xmlTag("TIME_TAKEN_IN_SEC", Long.toString(l2)));
    }

    @Override
    public final void setPollTime(int n2) throws Exception {
        if (n2 < 5) {
            n2 = 1440;
        }
        this.a.getPreferencesService().setPref(IPreferences.REPORT_AUTO_MINUTES, Integer.toString(n2));
        this.schedule(n2);
    }

    @Override
    public final int getPollTime() {
        try {
            String string = IPreferences.REPORT_AUTO_MINUTES;
            return Integer.parseInt(this.a.getPreferencesService().getPref(string, string));
        }
        catch (Exception exception) {
            return 1440;
        }
    }

    @Override
    public final File saveReportAsHTML(File file, byte by, String object, String object2, Date object3, Date object4) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "Sent";
        String string2 = "Received";
        stringBuilder.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html><head> <title>Binfer Transfer Report</title><style type=\"text/css\"> body { margin:0; padding:0 10%; } #binfer-log-container table{margin-left:auto;margin-right:auto}#binfer-log-container td,#binfer-log-container th{padding:5px}</style><link rel=\"stylesheet\" type=\"text/css\" href=\"https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/css/bootstrap.min.css\" /></head>");
        stringBuilder.append("<body><div id=\"binfer-log-container\"><table class=\"table table-striped\" id=\"binfer-log-table\" border=\"1\"><thead><tr><th>Status</th><th>Message</th><th>From</th><th>To</th><th>File</th><th>Date</th><th>From IP</th><th>To IP</th><th>Size</th><th>Bandwidth</th></tr></thead><tbody>");
        try {
            IPagedResult iPagedResult = this.a.getFilesService().getXferLogs((String)object, (String)object2, "%", (Date)object3, (Date)object4, by, IUser.CREATED, false, 100);
            try {
                block6: while (true) {
                    object = iPagedResult.next().iterator();
                    while (true) {
                        if (!object.hasNext()) continue block6;
                        object2 = (Map)object.next();
                        try {
                            object3 = ((String)object2.get("STATUS")).equalsIgnoreCase(Byte.toString(IFile.FILE_STATUS_RECEIVED)) ? string2 : string;
                            object4 = (String)object2.get(ISpace.SUBJECT);
                            String string3 = (String)object2.get(IFile.FILENAME);
                            String string4 = TimeUtil.getDayMonthYearHourMinSec(new Date(Long.parseLong((String)object2.get(ISpace.CREATED))));
                            stringBuilder.append("<tr><td>").append((String)object3).append("</td><td>").append((String)object4).append("</td><td>").append((String)object2.get(IUser.FROMUSERID)).append("</td><td>").append((String)object2.get(IUser.TOUSERID)).append("</td><td>").append(string3).append("</td><td>").append(string4).append("</td><td>").append((String)object2.get(IUser.FROMIP)).append("</td><td>").append((String)object2.get(IUser.TOIP)).append("</td><td>").append((String)object2.get(IFile.SIZE)).append("</td><td>").append((String)object2.get(IUser.BW)).append("</td></tr>");
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
            }
            catch (NoNextPageException noNextPageException) {
            }
        }
        catch (Exception exception) {}
        stringBuilder.append("</tbody></table></div></body></html>");
        Calendar calendar = Calendar.getInstance();
        object = new File(file, "Binfer Report - " + (calendar.get(2) + 1) + "-" + calendar.get(5) + "-" + calendar.get(1) + "-" + calendar.get(11) + "-" + calendar.get(12) + ".html");
        IOService.writeStringToFile(stringBuilder.toString(), (File)object);
        return object;
    }

    @Override
    public final File saveReportAsHTMLWithChecksum(File file, byte by, String object, String object2, Date object3, Date object4) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "Sent";
        String string2 = "Received";
        stringBuilder.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html><head> <title>Binfer Transfer Report</title><style type=\"text/css\"> body { margin:0; padding:0 10%; } #binfer-log-container table{margin-left:auto;margin-right:auto}#binfer-log-container td,#binfer-log-container th{padding:5px}</style><link rel=\"stylesheet\" type=\"text/css\" href=\"https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/css/bootstrap.min.css\" /></head>");
        stringBuilder.append("<body><div id=\"binfer-log-container\"><table class=\"table table-striped\" id=\"binfer-log-table\" border=\"1\"><thead><tr><th>Status</th><th>Message</th><th>From</th><th>To</th><th>File</th><th>Date</th><th>From IP</th><th>To IP</th><th>Size</th><th>Bandwidth</th><th>Checksum</th></tr></thead><tbody>");
        try {
            IPagedResult iPagedResult = this.a.getFilesService().getXferLogs((String)object, (String)object2, "%", (Date)object3, (Date)object4, by, IUser.CREATED, false, 100);
            try {
                block6: while (true) {
                    object = iPagedResult.next().iterator();
                    while (true) {
                        if (!object.hasNext()) continue block6;
                        object2 = (Map)object.next();
                        try {
                            object3 = ((String)object2.get("STATUS")).equalsIgnoreCase(Byte.toString(IFile.FILE_STATUS_RECEIVED)) ? string2 : string;
                            object4 = (String)object2.get(ISpace.SUBJECT);
                            String string3 = (String)object2.get(IFile.FILENAME);
                            String string4 = TimeUtil.getDayMonthYearHourMinSec(new Date(Long.parseLong((String)object2.get(ISpace.CREATED))));
                            String string5 = FileService.getChecksum(new File((String)object2.get(IFile.URI)));
                            stringBuilder.append("<tr><td>").append((String)object3).append("</td><td>").append((String)object4).append("</td><td>").append((String)object2.get(IUser.FROMUSERID)).append("</td><td>").append((String)object2.get(IUser.TOUSERID)).append("</td><td>").append(string3).append("</td><td>").append(string4).append("</td><td>").append((String)object2.get(IUser.FROMIP)).append("</td><td>").append((String)object2.get(IUser.TOIP)).append("</td><td>").append((String)object2.get(IFile.SIZE)).append("</td><td>").append((String)object2.get(IUser.BW)).append("</td><td>").append(string5).append("</td></tr>");
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
            }
            catch (NoNextPageException noNextPageException) {
            }
        }
        catch (Exception exception) {}
        stringBuilder.append("</tbody></table></div></body></html>");
        Calendar calendar = Calendar.getInstance();
        object = new File(file, "Binfer Report - " + (calendar.get(2) + 1) + "-" + calendar.get(5) + "-" + calendar.get(1) + "-" + calendar.get(11) + "-" + calendar.get(12) + "-checksum.html");
        IOService.writeStringToFile(stringBuilder.toString(), (File)object);
        return object;
    }

    @Override
    public final File saveReportAsCSV(File file, byte by, String object, String object2, Date object3, Date object4) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "Sent";
        String string2 = "Received";
        stringBuilder.append("Status,Message,From,To,File,Date,Date1,From IP,To IP,Size,Bandwidth\n");
        try {
            IPagedResult iPagedResult = this.a.getFilesService().getXferLogs((String)object, (String)object2, "%", (Date)object3, (Date)object4, by, IUser.CREATED, false, 100);
            try {
                block6: while (true) {
                    object = iPagedResult.next().iterator();
                    while (true) {
                        if (!object.hasNext()) continue block6;
                        object2 = (Map)object.next();
                        try {
                            object3 = ((String)object2.get("STATUS")).equalsIgnoreCase(Byte.toString(IFile.FILE_STATUS_RECEIVED)) ? string2 : string;
                            object4 = (String)object2.get(ISpace.SUBJECT);
                            String string3 = (String)object2.get(IFile.FILENAME);
                            String string4 = TimeUtil.getDayMonthYearHourMinSec(new Date(Long.parseLong((String)object2.get(ISpace.CREATED))));
                            stringBuilder.append((String)object3).append(",").append((String)object4).append(",").append((String)object2.get(IUser.FROMUSERID)).append(",").append((String)object2.get(IUser.TOUSERID)).append(",").append(string3).append(",").append(string4).append(",").append((String)object2.get(ISpace.CREATED)).append(",").append((String)object2.get(IUser.FROMIP)).append(",").append((String)object2.get(IUser.TOIP)).append(",").append((String)object2.get(IFile.SIZE)).append(",").append((String)object2.get(IUser.BW)).append("\n");
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
            }
            catch (NoNextPageException noNextPageException) {
            }
        }
        catch (Exception exception) {}
        Calendar calendar = Calendar.getInstance();
        object = new File(file, "Binfer Report - " + (calendar.get(2) + 1) + "-" + calendar.get(5) + "-" + calendar.get(1) + "-" + calendar.get(11) + "-" + calendar.get(12) + ".csv");
        IOService.writeStringToFile(stringBuilder.toString(), (File)object);
        return object;
    }

    @Override
    public final File saveReportAsCSVWithChecksum(File file, byte by, String object, String object2, Date object3, Date object4) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "Sent";
        String string2 = "Received";
        stringBuilder.append("Status,Message,From,To,File,Date,Date1,From IP,To IP,Size,Bandwidth,Checksum\n");
        try {
            IPagedResult iPagedResult = this.a.getFilesService().getXferLogs((String)object, (String)object2, "%", (Date)object3, (Date)object4, by, IUser.CREATED, false, 100);
            try {
                block6: while (true) {
                    object = iPagedResult.next().iterator();
                    while (true) {
                        if (!object.hasNext()) continue block6;
                        object2 = (Map)object.next();
                        try {
                            object3 = ((String)object2.get("STATUS")).equalsIgnoreCase(Byte.toString(IFile.FILE_STATUS_RECEIVED)) ? string2 : string;
                            object4 = (String)object2.get(ISpace.SUBJECT);
                            String string3 = (String)object2.get(IFile.FILENAME);
                            String string4 = TimeUtil.getDayMonthYearHourMinSec(new Date(Long.parseLong((String)object2.get(ISpace.CREATED))));
                            String string5 = FileService.getChecksum(new File((String)object2.get(IFile.URI)));
                            stringBuilder.append((String)object3).append(",").append((String)object4).append(",").append((String)object2.get(IUser.FROMUSERID)).append(",").append((String)object2.get(IUser.TOUSERID)).append(",").append(string3).append(",").append(string4).append(",").append((String)object2.get(ISpace.CREATED)).append(",").append((String)object2.get(IUser.FROMIP)).append(",").append((String)object2.get(IUser.TOIP)).append(",").append((String)object2.get(IFile.SIZE)).append(",").append((String)object2.get(IUser.BW)).append(",").append(string5).append("\n");
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
            }
            catch (NoNextPageException noNextPageException) {
            }
        }
        catch (Exception exception) {}
        Calendar calendar = Calendar.getInstance();
        object = new File(file, "Binfer Report - " + (calendar.get(2) + 1) + "-" + calendar.get(5) + "-" + calendar.get(1) + "-" + calendar.get(11) + "-" + calendar.get(12) + "-checksum.csv");
        IOService.writeStringToFile(stringBuilder.toString(), (File)object);
        return object;
    }
}

