/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.core.impl;

import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.DownloadService;
import com.binfer.base.service.IBinfer;
import com.binfer.base.service.IErrors;
import com.binfer.base.service.INetwork;
import com.binfer.base.service.IPlatformService;
import com.binfer.base.service.IPreferences;
import com.binfer.base.service.IUser;
import com.binfer.base.service.LogService;
import com.binfer.base.service.NetworkService;
import com.binfer.base.service.SchedulerService;
import com.binfer.base.util.Collections;
import com.binfer.base.util.ErrorException;
import com.binfer.core.impl.MessageConsumerImpl;
import com.binfer.core.impl.b;
import com.binfer.core.persistence.IPersistenceService;
import com.binfer.core.service.IService;
import java.io.File;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class c {
    protected IPlatformService platformService;
    protected IPersistenceService persistenceService;
    protected IService service;
    public String errorMessage;
    public boolean ready = false;
    private String a;
    private MessageConsumerImpl b;

    protected c(IPersistenceService iPersistenceService, IPlatformService iPlatformService) throws Exception {
        this.platformService = iPlatformService;
        this.persistenceService = iPersistenceService;
        LogService.setLogger(DownloadService.getSystemDirectory(), "binfer", IBinfer.defaultLevel);
    }

    protected void login(Map<String, String> map) throws Exception {
        BinferProperties.loadFromArgs(map);
        this.login();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void login(String[] stringArray) throws Exception {
        if (stringArray.length <= 0) throw new Exception("Arguments size is less than 1");
        BinferProperties.setProperty(IPreferences.INSTALLTYPE, stringArray[1].toUpperCase());
        if (stringArray[1].equalsIgnoreCase(IBinfer.INSTALL_TYPE.SERVER.name()) || stringArray[1].equalsIgnoreCase(IBinfer.INSTALL_TYPE.CLIENT_LITE.name())) {
            BinferProperties.setProperty("IS_SERVER", "true");
            if (stringArray[2] != null) {
                BinferProperties.setProperty(IUser.USERID, stringArray[2]);
            }
            if (stringArray[3] != null) {
                BinferProperties.setProperty(IUser.PASSWORD, stringArray[3]);
            }
            if (stringArray[4] != null) {
                BinferProperties.setProperty(INetwork.HTTPPORT, stringArray[4]);
            }
            if (stringArray[5] != null) {
                BinferProperties.setProperty(IPreferences.DOWNLOADPATH, stringArray[5]);
            }
            if (stringArray[6] != null) {
                BinferProperties.setProperty(IPreferences.SYSTEMPATH, stringArray[6]);
            }
            try {
                if (stringArray[7] != null) {
                    BinferProperties.setProperty(IPreferences.INSTALLDIR, stringArray[7]);
                }
            }
            catch (Exception exception) {}
        } else if (stringArray[1].equalsIgnoreCase(IBinfer.INSTALL_TYPE.CLIENT.name())) {
            BinferProperties.setProperty("IS_SERVER", "false");
            if (stringArray[2] != null) {
                BinferProperties.setProperty("PCFILE", stringArray[2]);
            }
            if (stringArray[3] != null) {
                BinferProperties.setProperty(INetwork.HTTPPORT, stringArray[3]);
            }
            if (stringArray[4] != null) {
                BinferProperties.setProperty(IPreferences.DOWNLOADPATH, stringArray[4]);
            }
            if (stringArray[5] != null) {
                BinferProperties.setProperty(IPreferences.SYSTEMPATH, stringArray[5]);
            }
            try {
                if (stringArray[6] != null) {
                    BinferProperties.setProperty(IPreferences.INSTALLDIR, stringArray[6]);
                }
            }
            catch (Exception exception) {}
        } else if (stringArray[1].equalsIgnoreCase(IBinfer.INSTALL_TYPE.ENDPOINT.name())) {
            BinferProperties.setProperty("IS_SERVER", "false");
            Collections.paramsToMap(stringArray[2], ",", "=");
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string).append(", ");
            }
            LogService.log("Unsupported installation parameters: " + stringBuilder.toString(), Level.SEVERE);
            throw new Exception("Unsupported installation parameters: " + stringBuilder.toString());
        }
        this.login();
    }

    protected void login() throws Exception {
        boolean bl = false;
        try {
            bl = BinferProperties.hasProperty(IPreferences.SETUPTYPE) && BinferProperties.getProperty(IPreferences.SETUPTYPE).equalsIgnoreCase(IBinfer.SETUP_TYPE.PORTABLE.name());
        }
        catch (Exception exception) {}
        if (bl) {
            c c2 = this;
            this.a = BinferProperties.getProperty(IUser.USERID);
            if (c2.a == null || c2.a.isEmpty()) {
                throw new Exception("Userid is invalid");
            }
            BinferProperties.setProperty(IPreferences.STARTSERVERBG, Boolean.TRUE.toString());
            Object object = new b(c2.a, c2.a, c2.persistenceService, c2.platformService);
            ((b)object).initServices();
            String string = IPreferences.DOWNLOADPATH;
            ((b)object).b.setPref(string, BinferProperties.getProperty(string));
            String string2 = IPreferences.SYSTEMPATH;
            ((b)object).b.setPref(string2, BinferProperties.getProperty(string2));
            String string3 = IPreferences.INSTALLDIR;
            ((b)object).b.setPref(string3, BinferProperties.getProperty(string3));
            ((b)object).b.setPref(IPreferences.SELF_BUILD, ((b)object).a.getSelfBuildNumber());
            String string4 = INetwork.HTTPPORT;
            ((b)object).b.setPref(string4, Integer.toString(BinferProperties.getIntegerProperty(string4, 1212)));
            ((b)object).b.setPref(INetwork.INTERNALIP, ((b)object).c.getSelfInternalIP());
            ((b)object).b.setPref(INetwork.EXTERNALIP, ((b)object).c.getSelfExternalIP());
            c2.service = object;
            object = Calendar.getInstance();
            ((Calendar)object).add(12, 1);
            SchedulerService.getInstance().scheduleWork("PingPong", new Runnable(c2){
                private /* synthetic */ c a;
                {
                    this.a = c2;
                }

                @Override
                public final void run() {
                    Thread.currentThread().setName("B.PINGPONG");
                    try {
                        this.a.service.getContactsService().pingAllContacts();
                        return;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            }, (Calendar)object, 30L, TimeUnit.MINUTES);
        } else if (BinferProperties.getProperty(IPreferences.INSTALLTYPE).equalsIgnoreCase(IBinfer.INSTALL_TYPE.CLIENT.name())) {
            this.b();
        } else {
            this.a();
        }
        this.ready = true;
        this.b = new MessageConsumerImpl(this.service, this.service.getMessageService().getGetMessageUrl(), this.service.getNetworkService().getSelfQ());
        this.b.start();
    }

    private synchronized void a() throws Exception {
        if (!this.ready) {
            this.a = BinferProperties.getProperty(IUser.USERID);
            String string = BinferProperties.getProperty(IUser.PASSWORD);
            if (this.a != null && string != null) {
                this.service = new b(this.a, string, this.persistenceService, this.platformService);
                this.service.initServices();
                LogService.log("login done:" + this.a + "#" + this.service.getNetworkService().getSelfDeviceID() + ", release:6.1.0.0.042525.2100", Level.WARNING);
                return;
            }
            this.errorMessage = "EXPN: no user authentication or pc file does not exists. userid:" + this.a + ", password:" + string;
            LogService.log(this.errorMessage, Level.WARNING);
            return;
        }
        LogService.log("system is already in ready state", Level.WARNING);
        return;
    }

    private synchronized void b() throws Exception {
        if (!this.ready) {
            Object object = BinferProperties.getProperty("PCFILE");
            if (object == null || ((String)object).isEmpty()) {
                LogService.log("Invalid PC file. System may not have been setup.".concat(String.valueOf(object)), Level.SEVERE);
            }
            if (((String)object).startsWith("http")) {
                object = NetworkService.downloadPCFile((String)object, DownloadService.getConfDir());
                BinferProperties.setProperty("PCFILE", ((File)object).getAbsolutePath());
                BinferProperties.save();
            } else {
                object = new File((String)object);
            }
            if (object != null && ((File)object).exists() && !((File)object).isDirectory()) {
                this.service = new b((File)object, this.persistenceService, this.platformService);
                this.service.initServices();
                this.a = ((File)object).getName();
                LogService.log("login done:" + this.service.getUserService().getSelfID() + "#" + this.service.getNetworkService().getSelfDeviceID() + ", release:6.1.0.0.042525.2100", Level.WARNING);
                return;
            }
            this.errorMessage = "WARNING: pc file does not existor is invalid";
            BinferProperties.delete();
            LogService.log(this.errorMessage, Level.WARNING);
            throw new ErrorException(IErrors.CODE.PC_FILE_NOT_FOUND, "Check expected location: " + ((File)object).getAbsolutePath(), null);
        }
    }

    public void login(String string, Map<String, String> map) throws Exception {
        this.a = map.get(IUser.USERID);
        if (this.a == null || this.a.isEmpty()) {
            throw new Exception("Please define a valid userid");
        }
        this.a = this.a.toLowerCase();
        String string2 = NetworkService.getDeviceIdFromUserId(map.get(IUser.ACCOUNTID), this.a);
        map.put(IUser.DEVICEID, string2);
        map.put(INetwork.ISPRIVATECLOUD_ENDPOINT, Boolean.TRUE.toString());
        for (String string3 : map.keySet()) {
            BinferProperties.setProperty(string3, map.get(string3));
        }
        this.service = new b(string, map, this.persistenceService, this.platformService);
        this.service.initServices();
        LogService.log("login done:" + this.a + "#" + this.service.getNetworkService().getSelfDeviceID() + ", release:6.1.0.0.042525.2100", Level.WARNING);
    }

    protected synchronized void logout() {
        if (this.ready) {
            try {
                this.b.close();
            }
            catch (Exception exception) {}
            try {
                this.ready = false;
                this.service.logout();
                return;
            }
            catch (Exception exception) {
                LogService.log("logout failed. err:" + exception.getMessage(), Level.WARNING);
            }
        }
    }

    protected void setDownloadLocation(String string) throws Exception {
        if (!new File(string).exists()) {
            throw new Exception("Download location does not exist");
        }
        BinferProperties.setProperty(IPreferences.DOWNLOADPATH, string);
        BinferProperties.save();
    }

    protected IService getService() {
        return this.service;
    }

    protected void setProfileDesktop() {
        BinferProperties.setProperty(IPreferences.DEVICEPROFILE, Byte.toString((byte)1));
        BinferProperties.setProperty(IPreferences.STARTSERVERBG, Boolean.FALSE.toString());
        BinferProperties.setProperty(IPreferences.STARTPUSHPULLWORK, Boolean.TRUE.toString());
        BinferProperties.save();
    }

    protected void setProfilePhone() {
        BinferProperties.setProperty(IPreferences.STARTSERVER, Boolean.FALSE.toString());
        BinferProperties.save();
        BinferProperties.setProperty(IPreferences.DEVICEPROFILE, Byte.toString((byte)0));
        BinferProperties.setProperty(IPreferences.STARTSERVERBG, Boolean.FALSE.toString());
        BinferProperties.setProperty(IPreferences.STARTPUSHPULLWORK, Boolean.FALSE.toString());
        BinferProperties.setProperty(IPreferences.STARTREPORTWORK, Boolean.FALSE.toString());
        BinferProperties.setProperty(IPreferences.STARTSENDRULESWORK, Boolean.FALSE.toString());
        BinferProperties.setProperty(IPreferences.STARTCONVSYNCWORK, Boolean.FALSE.toString());
        BinferProperties.setProperty(IPreferences.SENDDEVICEOFFLINEEMAIL, Boolean.FALSE.toString());
        BinferProperties.setProperty(IPreferences.SENDDEVICEONLINEEMAIL, Boolean.FALSE.toString());
        BinferProperties.save();
    }

    public boolean isLoggedIn() {
        return this.ready;
    }
}

