/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.core.impl;

import com.binfer.base.service.EventService;
import com.binfer.base.service.FileService;
import com.binfer.base.service.IErrors;
import com.binfer.base.service.IEvent;
import com.binfer.base.service.IFile;
import com.binfer.base.service.IMessage;
import com.binfer.base.service.INetwork;
import com.binfer.base.service.IPreferences;
import com.binfer.base.service.ISpace;
import com.binfer.base.service.IUsage;
import com.binfer.base.service.IUser;
import com.binfer.base.service.LogService;
import com.binfer.base.util.Base64;
import com.binfer.base.util.ErrorDetector;
import com.binfer.base.util.IPagedResult;
import com.binfer.base.util.Xfer;
import com.binfer.base.xml.XMLUtil;
import com.binfer.core.impl.C;
import com.binfer.core.impl.J;
import com.binfer.core.impl.p;
import com.binfer.core.service.IFileService;
import com.binfer.core.service.IService;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;

public final class q
implements IFileService {
    private IService a;
    private p b;

    public q(IService iService) {
        this.a = iService;
    }

    @Override
    public final void init() {
        this.b = new p(this.a);
        J.a(this.a);
    }

    @Override
    public final void close() {
        this.b.a();
        J.a().b();
    }

    private void a(String string) {
        this.b.a(string);
    }

    @Override
    public final void addFiles(String string, List<Map<String, String>> object, byte by) throws Exception {
        by = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Map map = (Map)object.next();
            boolean bl = this.addFile(string, (String)map.get(IFile.FILEID), (String)map.get(IFile.FILENAME), Long.parseLong((String)map.get(IFile.SIZE)), (String)map.get(IFile.URI), Long.parseLong((String)map.get(IFile.CREATED)), Long.parseLong((String)map.get(IFile.MODIFIED)), this.a.getUserService().getSelfID(), this.a.getNetworkService().getSelfDeviceID(), IFile.FILE_STATUS_PENDING_SEND);
            if (by != 0 || !bl) continue;
            by = (byte)(bl ? 1 : 0);
        }
        if (by != 0) {
            this.b.a(string);
            EventService.publish(IEvent.EVENT.SPACECHANGED, string);
        }
    }

    @Override
    public final boolean addFile(String string, String string2, String string3, long l2, String string4, long l3, long l4, String string5, String string6, byte by) {
        string4 = FileService.separatorsToSystem(string4);
        if (l2 <= 0L || !FileService.isPatternAllowed(string3)) {
            return false;
        }
        try {
            if (!this.a.getPersistenceService().getFilesService().getDeletedFile(string, string2).isEmpty()) {
                return false;
            }
        }
        catch (Exception exception) {}
        Map<String, String> map = this.a.getPersistenceService().getFilesService().getFile(string, IFile.URIID, UUID.nameUUIDFromBytes(string4.getBytes()).toString());
        boolean bl = true;
        if (!map.isEmpty()) {
            bl = false;
            boolean bl2 = false;
            try {
                bl = Long.parseLong(map.get(IFile.SIZE)) == l2;
            }
            catch (Exception exception) {}
            try {
                bl2 = Long.parseLong(map.get(IFile.MODIFIED)) == l4;
            }
            catch (Exception exception) {}
            if (!(bl && bl2 && map.get(IFile.FILEID).equalsIgnoreCase(string2))) {
                this.deleteFile(string, map.get(IFile.FILEID));
                bl = true;
            } else {
                bl = false;
            }
        }
        if (bl) {
            bl = this.a.getPersistenceService().getFilesService().addFile(string, string2, string3, l2, string4, l3, l4, string5, string6, by);
        }
        return bl;
    }

    @Override
    public final void addFilesAndFolders(String string, List<File> linkedList, byte by) throws Exception {
        LinkedHashMap<String, File> linkedHashMap = new LinkedHashMap<String, File>();
        for (File object : linkedList) {
            FileService.getRelativeFilePathsRecursive("", object, linkedHashMap);
        }
        linkedList = new LinkedList<Map<String, String>>();
        for (String string2 : linkedHashMap.keySet()) {
            try {
                File file = (File)linkedHashMap.get(string2);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(IFile.FILENAME, string2);
                hashMap.put(IFile.URI, file.getAbsolutePath());
                hashMap.put(IFile.SIZE, Long.toString(file.length()));
                hashMap.put(IFile.MODIFIED, Long.toString(file.lastModified()));
                hashMap.put(IFile.CREATED, Long.toString(FileService.getFileCreationTime(file)));
                hashMap.put(IFile.FILEID, UUID.nameUUIDFromBytes(file.getAbsolutePath().getBytes()).toString());
                hashMap.put(IFile.OWNER, this.a.getUserService().getSelfID());
                linkedList.add(hashMap);
            }
            catch (Exception exception) {}
        }
        this.addFiles(string, linkedList, by);
    }

    @Override
    public final void validateCanSendFiles(List<Map<String, String>> object) throws Exception {
        long l2 = 0L;
        long l3 = 0L;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Map)object.next();
            try {
                if (((File)(object2 = new File((String)object2.get(IFile.URI)))).length() == 0L || !FileService.isPatternAllowed(((File)object2).getName())) continue;
                l2 += ((File)object2).length();
                ++l3;
            }
            catch (Exception exception) {}
        }
        if (l2 > 0L && !this.a.getLicenseService().checkCanSend(l2)) {
            this.a.getLicenseService().trackLicenseExceeded(l2, l3, 0);
            throw new Exception("Total files size exceeded license limit.");
        }
    }

    @Override
    public final void addFolder(String string, String string2, String string3, long l2, long l3, long l4, byte by) {
        this.a.getPersistenceService().getFilesService().addFolder(string, string2, string3, l2, l3, l4, by);
    }

    @Override
    public final void deleteFolders(String string) {
        this.a.getPersistenceService().getFilesService().deleteFolders(string);
    }

    @Override
    public final void deleteFolder(String string, String string2) {
        this.a.getPersistenceService().getFilesService().deleteFolder(string, string2);
    }

    @Override
    public final void updateFolder(String string, String string2, String string3, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(string3, object);
        this.updateFolder(string, string2, hashMap);
    }

    @Override
    public final void updateFolder(String string, String string2, Map<String, Object> map) {
        this.a.getPersistenceService().getFilesService().updateFolder(string, string2, map);
    }

    @Override
    public final Map<String, String> getFolder(String string, String string2) {
        return this.a.getPersistenceService().getFilesService().getFolder(string, string2);
    }

    @Override
    public final IPagedResult getFolders(String string, byte by) {
        return this.a.getPersistenceService().getFilesService().getFolders(string, by);
    }

    @Override
    public final IPagedResult getFolders(String string) {
        return this.a.getPersistenceService().getFilesService().getFolders(string);
    }

    @Override
    public final void addDeletedFile(String string, String string2) {
        boolean map2;
        Map<String, String> map = this.a.getSpaceService().getSpaceOptions(string);
        boolean bl = false;
        try {
            if (map.containsKey(ISpace.SPACE_OPTION_SYNC_SYNCDELETES)) {
                map2 = Boolean.parseBoolean(map.get(ISpace.SPACE_OPTION_SYNC_SYNCDELETES));
            }
        }
        catch (Exception exception) {}
        if (map2) {
            for (Map map3 : this.a.getSpaceService().getMembers(string)) {
                try {
                    this.a.getPersistenceService().getFilesService().addDeletedFile(string, string2, (String)map3.get(IUser.DEVICEID), System.currentTimeMillis());
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public final void removeDeletedFile(String string, String string2, String string3) {
        this.a.getPersistenceService().getFilesService().deleteDeletedFile(string, string2, string3);
    }

    @Override
    public final IPagedResult getDeletedFilesByDeviceId(String string, int n2) {
        return this.a.getPersistenceService().getFilesService().getDeletedFilesByDeviceId(string, n2);
    }

    @Override
    public final IPagedResult getDeletedFilesBySpaceId(String string, int n2) {
        return this.a.getPersistenceService().getFilesService().getDeletedFilesBySpaceId(string, n2);
    }

    @Override
    public final Map<String, String> getDeletedFile(String string, String string2) {
        return this.a.getPersistenceService().getFilesService().getDeletedFile(string, string2);
    }

    @Override
    public final void deleteFile(String string, String string2) {
        this.a.getPersistenceService().getFilesService().deleteFile(string, string2);
        C.b();
    }

    @Override
    public final void deleteFiles(String string) {
        this.a.getPersistenceService().getFilesService().deleteFiles(string);
        C.b();
    }

    @Override
    public final Map<String, String> getFile(String string, String string2) {
        return this.getFile(string, IFile.FILEID, string2);
    }

    @Override
    public final Map<String, String> getFile(String string, String string2, String string3) {
        return this.a.getPersistenceService().getFilesService().getFile(string, string2, string3);
    }

    @Override
    public final Map<String, String> getFileFromComments(String string, String string2) {
        return this.a.getPersistenceService().getFilesService().getFileFromComments(string, string2);
    }

    @Override
    public final IPagedResult getFilesFromComments(String string, long l2, boolean bl) {
        return this.a.getPersistenceService().getFilesService().getFilesFromComments(string, l2, bl);
    }

    @Override
    public final List<Map<String, String>> getFiles(String string, String string2, boolean bl) {
        return this.a.getPersistenceService().getFilesService().getFiles(string, string2, bl);
    }

    @Override
    public final IPagedResult getFiles(String string, long l2, String string2, boolean bl) {
        return this.a.getPersistenceService().getFilesService().getFiles(string, l2, string2, bl);
    }

    @Override
    public final List<Map<String, String>> getUnsentFiles(String string, String string2, String string3, int n2) {
        try {
            return this.a.getPersistenceService().getFilesService().getUnsentFiles(string, string2, string3, n2);
        }
        catch (Exception exception) {
            return new LinkedList<Map<String, String>>();
        }
    }

    @Override
    public final List<Map<String, String>> getUnsentFiles(String string, String string2, int n2) {
        try {
            return this.a.getPersistenceService().getFilesService().getUnsentFiles(string, string2, n2);
        }
        catch (Exception exception) {
            return new LinkedList<Map<String, String>>();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void handleFileSent(Xfer xfer, File object) {
        try {
            object = UUID.nameUUIDFromBytes(("sndfailed-" + xfer.fileid + xfer.spaceid + xfer.toDeviceID).getBytes()).toString();
            this.a.getPreferencesService().setPref((String)object, null);
        }
        catch (Exception exception) {}
        try {
            System.currentTimeMillis();
            this.a.getLicenseService().updateConsumed(xfer.getXferedSession());
            J.a().a(xfer);
            if (xfer.status == IFile.FILE_STATUS_SENT) {
                this.a.getPersistenceService().getFilesService().handleFileStatusChanged(xfer.spaceid, xfer.fileid, xfer.to, xfer.toDeviceID, IFile.FILE_STATUS_SENT);
                if (xfer.getIsWebPickup()) {
                    this.addXferLog(xfer.spaceid, xfer.fileid, xfer.status, xfer.from, xfer.fromDeviceID, this.a.getNetworkService().getSelfExternalIP(), xfer.to, xfer.toDeviceID, xfer.contactIP, new Date(), xfer.getXfered() - xfer.offset, xfer.getKbPerSecondNet(), xfer.filename, xfer.file.getAbsolutePath(), xfer.subject, xfer.getXferedCompressed());
                } else {
                    if (this.isAlreadyXfered(xfer.spaceid, xfer.fileid, xfer.to, xfer.toDeviceID, IFile.FILE_STATUS_SENT)) {
                        this.deleteXferLogs(xfer.spaceid, xfer.fileid);
                    }
                    this.addXferLog(xfer.spaceid, xfer.fileid, xfer.status, xfer.from, xfer.fromDeviceID, this.a.getNetworkService().getSelfExternalIP(), xfer.to, xfer.toDeviceID, xfer.contactIP, new Date(), xfer.getXfered() - xfer.offset, xfer.getKbPerSecondNet(), xfer.filename, xfer.file.getAbsolutePath(), xfer.subject, xfer.getXferedCompressed());
                }
                this.a.getSpaceService().updateSpaceTimeStamp(xfer.spaceid);
                if (xfer.getIsWebPickup()) {
                    this.a.getUsageService().addUsage("" + (Object)((Object)IUsage.USAGE.FILES_SENT_WEBPICKUP_COUNT), 1);
                }
                this.a.getUsageService().averageUsage("" + (Object)((Object)IUsage.USAGE.FILES_SENT_BANDWIDTH_AVG_SIZE), xfer.speedBytesPerSecondNet);
                this.a(xfer.spaceid);
                this.a.getUsageService().addUsage(IUsage.USAGE.FILES_SENT_COUNT.name(), 1);
                if (xfer.getIsWebPickup()) {
                    this.a(xfer.from, xfer.fromDeviceID, xfer.getXferedSession(), IFile.FILE_STATUS_SENT);
                } else {
                    this.a(xfer.to, xfer.toDeviceID, xfer.getXferedSession(), IFile.FILE_STATUS_SENT);
                }
                if (xfer.isCompressed()) {
                    this.a.getCompressionSavingsService().add(xfer.spaceid, xfer.file.getAbsolutePath(), xfer.getXferedSession(), xfer.getXferedCompressed(), xfer.getCompression(), xfer.from, xfer.fromDeviceID, xfer.to, xfer.toDeviceID, xfer.status);
                }
                this.a.getErrorsService().delete(xfer.spaceid, xfer.fileid, xfer.fromDeviceID, xfer.fromDeviceID);
            } else {
                LogService.log("!file sent but with incorrect status:" + xfer.status + ", to:" + xfer.to + "#" + xfer.toDeviceID + ", sub:" + xfer.subject + ", file:" + xfer.filename, Level.SEVERE);
            }
        }
        catch (Exception exception) {
            C.a(this.a, xfer);
            EventService.publish(IEvent.EVENT.XFERPROGRESSCHANGED, xfer);
            EventService.publish(IEvent.EVENT.XFERENDED, xfer);
            EventService.publish(IEvent.EVENT.FILESENT, xfer);
            EventService.publish(IEvent.EVENT.SPACECHANGED, ISpace.SPACE_TYPE_SENT);
            try {
                this.a.getSpaceService().deleteSentFile(xfer.spaceid, xfer.fileid);
                return;
            }
            catch (Exception exception2) {
                return;
            }
        }
        catch (Throwable throwable) {
            C.a(this.a, xfer);
            EventService.publish(IEvent.EVENT.XFERPROGRESSCHANGED, xfer);
            EventService.publish(IEvent.EVENT.XFERENDED, xfer);
            EventService.publish(IEvent.EVENT.FILESENT, xfer);
            EventService.publish(IEvent.EVENT.SPACECHANGED, ISpace.SPACE_TYPE_SENT);
            try {
                this.a.getSpaceService().deleteSentFile(xfer.spaceid, xfer.fileid);
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        C.a(this.a, xfer);
        EventService.publish(IEvent.EVENT.XFERPROGRESSCHANGED, xfer);
        EventService.publish(IEvent.EVENT.XFERENDED, xfer);
        EventService.publish(IEvent.EVENT.FILESENT, xfer);
        EventService.publish(IEvent.EVENT.SPACECHANGED, ISpace.SPACE_TYPE_SENT);
        try {
            this.a.getSpaceService().deleteSentFile(xfer.spaceid, xfer.fileid);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public final void handleFileSendFailed(Xfer xfer) {
        try {
            String string = UUID.nameUUIDFromBytes(("sndfailed-" + xfer.fileid + xfer.spaceid + xfer.toDeviceID).getBytes()).toString();
            int n2 = Integer.parseInt(this.a.getPreferencesService().getPref(string, "0"));
            this.a.getPreferencesService().setPref(string, Integer.toString(++n2));
            if (xfer.offset > 0L && xfer.getXferedSession() > 0L) {
                this.a.getLicenseService().updateConsumed(xfer.getXferedSession());
                J.a().a(xfer);
            }
            xfer.interruptedCount = n2;
            boolean bl = false;
            if (xfer.getXferedSession() == 0L) {
                if (n2 > 5) {
                    bl = true;
                }
            } else if (xfer.getXferedSession() > 0L) {
                this.a.getPreferencesService().setPref(string, null);
            }
            if (bl) {
                if (!FileService.isReadable(xfer.file)) {
                    LogService.log("file to be sent is not readable. job:" + xfer.subject + ", file:" + xfer.file.getAbsolutePath(), Level.SEVERE);
                    this.handleError(xfer.spaceid, xfer.fileid, xfer.from, xfer.fromDeviceID, xfer.to, xfer.toDeviceID, IErrors.CODE.FILE_NOT_READABLE.name(), xfer.file.getAbsolutePath());
                } else {
                    this.handleError(xfer.spaceid, xfer.fileid, xfer.from, xfer.fromDeviceID, xfer.to, xfer.toDeviceID, IErrors.CODE.TRANSFER_INTERRUPTED.name(), xfer.file.getAbsolutePath());
                }
                LogService.log(">> send.interrupted#" + n2 + ", from:" + xfer.from + "#" + xfer.fromDeviceID + ", sub:" + xfer.subject + ", file:" + xfer.file.getAbsolutePath() + ", xfered:" + xfer.getXfered() + " of " + xfer.size + ", sid:" + xfer.spaceid + ", fid:" + xfer.fileid + xfer.getError(), Level.WARNING);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            C.b();
            this.a.getUsageService().addUsage(IUsage.USAGE.FILES_SENT_FAILED_COUNT.name(), 1);
            EventService.publish(IEvent.EVENT.XFERPROGRESSCHANGED, xfer);
            EventService.publish(IEvent.EVENT.XFERENDED, xfer);
        }
    }

    @Override
    public final void handleFileReceivedDirect(Xfer xfer, String string, boolean bl) {
        try {
            if (bl) {
                J.a().a(xfer);
                this.a.getLicenseService().updateConsumed(xfer.getXfered());
            }
        }
        catch (Exception exception) {}
        this.handleFileReceived(xfer);
    }

    @Override
    public final void handleFileReceived(Xfer xfer) {
        block27: {
            try {
                try {
                    if (xfer.parentSpaceId == null) {
                        xfer.parentSpaceId = this.a.getSpaceService().getSpaceById(xfer.spaceid).get(ISpace.PARENTSPACEID);
                    }
                }
                catch (Exception exception) {}
                if (xfer.status == IFile.FILE_STATUS_RECEIVED) {
                    Xfer xfer2 = xfer;
                    Object object = this;
                    boolean bl = false;
                    try {
                        bl = Boolean.parseBoolean(((q)object).a.getSpaceService().getSpaceOption(xfer2.spaceid, ISpace.SPACE_OPTION_PRESERVE_TIMESTAMP));
                    }
                    catch (Exception exception) {}
                    if (!bl) {
                        bl = Boolean.parseBoolean(((q)object).a.getSpaceService().getSpaceOption(xfer2.spaceid, ISpace.SPACE_OPTION_SYNC_SYNCTWOWAY));
                    }
                    if (bl) {
                        try {
                            long l2;
                            object = ((q)object).getFile(xfer2.spaceid, xfer2.fileid);
                            try {
                                l2 = Long.parseLong((String)object.get(IFile.MODIFIED));
                                FileService.setFileLastModified(xfer2.file, l2);
                            }
                            catch (Exception exception) {}
                            try {
                                l2 = Long.parseLong((String)object.get(IFile.CREATED));
                                FileService.setFileCreationTime(xfer2.file, l2);
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception exception) {}
                    }
                    this.a.getPersistenceService().getFilesService().handleFileStatusChanged(xfer.spaceid, xfer.fileid, xfer.from, xfer.fromDeviceID, IFile.FILE_STATUS_RECEIVED);
                    this.a.getUsageService().addUsage(IUsage.USAGE.FILES_RCVD_COUNT.name(), 1);
                    try {
                        object = UUID.nameUUIDFromBytes(("rcvfailed-" + xfer.fileid + xfer.spaceid + xfer.fromDeviceID).getBytes()).toString();
                        this.a.getPreferencesService().setPref((String)object, null);
                    }
                    catch (Exception exception) {}
                }
                xfer.status = IFile.FILE_STATUS_RECEIVED;
                if (xfer.parentSpaceId != null && !xfer.parentSpaceId.equalsIgnoreCase(xfer.spaceid)) {
                    this.addXferLog(xfer.parentSpaceId, xfer.fileid, xfer.status, xfer.from, xfer.fromDeviceID, xfer.contactIP, xfer.to, xfer.toDeviceID, this.a.getNetworkService().getSelfExternalIP(), new Date(), xfer.getXfered() - xfer.offset, xfer.getKbPerSecondNet(), xfer.filename, xfer.file.getAbsolutePath(), xfer.subject, xfer.getXferedCompressed());
                }
                this.addXferLog(xfer.spaceid, xfer.fileid, xfer.status, xfer.from, xfer.fromDeviceID, xfer.contactIP, xfer.to, xfer.toDeviceID, this.a.getNetworkService().getSelfExternalIP(), new Date(), xfer.getXfered() - xfer.offset, xfer.getKbPerSecondNet(), xfer.filename, xfer.file.getAbsolutePath(), xfer.subject, xfer.getXferedCompressed());
                if (xfer.getIsWebDrop()) {
                    this.a(xfer.to, xfer.toDeviceID, xfer.getXferedSession(), IFile.FILE_STATUS_RECEIVED);
                } else {
                    this.a(xfer.from, xfer.fromDeviceID, xfer.getXferedSession(), IFile.FILE_STATUS_RECEIVED);
                }
                this.a.getSpaceService().updateSpaceTimeStamp(xfer.spaceid);
                if (xfer.getIsWebDrop()) {
                    this.a.getUsageService().addUsage("" + (Object)((Object)IUsage.USAGE.FILES_RCDV_WEBDROP_COUNT), 1);
                }
                this.a(xfer.spaceid);
                this.a.getUsageService().averageUsage("" + (Object)((Object)IUsage.USAGE.FILES_RCVD_BANDWIDTH_AVG_SIZE), xfer.speedBytesPerSecondNet);
                byte by = this.a.getSpaceService().getSpaceType(xfer.spaceid);
                if (by == ISpace.SPACE_TYPE_CONVERSATION || by == ISpace.SPACE_TYPE_COMMENT) {
                    this.a.getChatService().updateFileLocation(xfer.spaceid, xfer.fileid, xfer.file.getAbsolutePath());
                }
                this.a.getErrorsService().delete(xfer.spaceid, xfer.fileid, xfer.fromDeviceID, xfer.toDeviceID);
                if (!xfer.isCompressed()) break block27;
                this.a.getCompressionSavingsService().add(xfer.spaceid, xfer.file.getAbsolutePath(), xfer.getXferedSession(), xfer.getXferedCompressed(), xfer.getCompression(), xfer.from, xfer.fromDeviceID, xfer.to, xfer.toDeviceID, xfer.status);
            }
            catch (Exception exception) {
                EventService.publish(IEvent.EVENT.XFERPROGRESSCHANGED, xfer);
                EventService.publish(IEvent.EVENT.XFERENDED, xfer);
                EventService.publish(IEvent.EVENT.FILERECEIVED, xfer);
                this.a(xfer);
                if (xfer.subject.contains("Patch-Update")) {
                    LogService.log("update received:" + xfer.subject + ", file:" + xfer.file, Level.WARNING);
                    EventService.publish(IEvent.EVENT.PATCHAVAILABLE, xfer.file);
                    return;
                }
            }
            catch (Throwable throwable) {
                EventService.publish(IEvent.EVENT.XFERPROGRESSCHANGED, xfer);
                EventService.publish(IEvent.EVENT.XFERENDED, xfer);
                EventService.publish(IEvent.EVENT.FILERECEIVED, xfer);
                this.a(xfer);
                if (xfer.subject.contains("Patch-Update")) {
                    LogService.log("update received:" + xfer.subject + ", file:" + xfer.file, Level.WARNING);
                    EventService.publish(IEvent.EVENT.PATCHAVAILABLE, xfer.file);
                }
                throw throwable;
            }
        }
        EventService.publish(IEvent.EVENT.XFERPROGRESSCHANGED, xfer);
        EventService.publish(IEvent.EVENT.XFERENDED, xfer);
        EventService.publish(IEvent.EVENT.FILERECEIVED, xfer);
        this.a(xfer);
        if (xfer.subject.contains("Patch-Update")) {
            LogService.log("update received:" + xfer.subject + ", file:" + xfer.file, Level.WARNING);
            EventService.publish(IEvent.EVENT.PATCHAVAILABLE, xfer.file);
            return;
        }
    }

    private void a(Xfer xfer) {
        if (this.a.getPreferencesService().getBooleanPref(IPreferences.WILL_ACK_RECEIVES, true)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(XMLUtil.xmlTag(ISpace.SPACEID, xfer.spaceid));
            stringBuilder.append(XMLUtil.xmlTag(ISpace.SUBJECT, xfer.subject));
            stringBuilder.append(XMLUtil.xmlTag(IFile.FILEID, xfer.fileid));
            stringBuilder.append(XMLUtil.xmlTag(IFile.FILENAME, xfer.filename));
            stringBuilder.append(XMLUtil.xmlTag(IFile.SIZE, Long.toString(xfer.size)));
            stringBuilder.append(XMLUtil.xmlTag(IFile.SIZE_COMPRESSED, Long.toString(xfer.getXferedCompressed())));
            stringBuilder.append(XMLUtil.xmlTag(IUser.OFFSET, Long.toString(xfer.offset)));
            stringBuilder.append(XMLUtil.xmlTag(IUser.TXNID, xfer.xferid));
            stringBuilder.append(XMLUtil.xmlTag(IUser.CLIENT, this.a.getNetworkService().getClientOS()));
            stringBuilder.append(XMLUtil.xmlTag(IUser.BW, Double.toString(xfer.getKiloBytesPerSecondNet())));
            stringBuilder.append(XMLUtil.xmlTag(IUser.TIMETAKEN.toString(), Double.toString(xfer.getTimeTaken())));
            stringBuilder.append(XMLUtil.xmlTag(INetwork.IP, this.a.getNetworkService().getSelfExternalIP()));
            stringBuilder.append(XMLUtil.xmlTag(INetwork.ENCRYPTED, Boolean.toString(xfer.isEncrypted())));
            stringBuilder.append(XMLUtil.xmlTag(INetwork.COMPRESSION, Integer.toString(xfer.getCompression())));
            try {
                this.a.getMessageService().sendMessage(xfer.from, xfer.fromDeviceID, IMessage.MSG_FILERCVD_ACK, stringBuilder.toString());
                return;
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public final void handleFileReceiveFailed(Xfer xfer) {
        try {
            String string = UUID.nameUUIDFromBytes(("rcvfailed-" + xfer.fileid + xfer.spaceid + xfer.fromDeviceID).getBytes()).toString();
            int n2 = Integer.parseInt(this.a.getPreferencesService().getPref(string, "0"));
            this.a.getPreferencesService().setPref(string, Integer.toString(++n2));
            xfer.interruptedCount = n2;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            try {
                if (xfer.file.length() == 0L || xfer.getXfered() > xfer.size) {
                    bl2 = true;
                    boolean bl5 = FileService.deleteFile(xfer.file);
                    if (bl5 && xfer.getXfered() > xfer.size) {
                        LogService.log(">> FS.delete:" + bl5 + ", because of incorrect length, file:" + xfer.file.getAbsolutePath() + ", size:" + xfer.file.length() + ", user:" + xfer.from + "#" + xfer.fromDeviceID, Level.WARNING);
                    }
                }
            }
            catch (Exception exception) {}
            if (xfer.getXferedSession() == 0L) {
                ErrorDetector errorDetector = new ErrorDetector();
                errorDetector.determineDiskIssues(xfer.file, xfer.size - xfer.offset);
                if (errorDetector.errorCode != IErrors.CODE.NO_ERROR) {
                    LogService.log(">> Storage issues found for file:" + xfer.file + ". Error:" + (Object)((Object)errorDetector.errorCode) + ". " + errorDetector.errorMessage, Level.SEVERE);
                    this.handleError(xfer.spaceid, xfer.fileid, xfer.from, xfer.fromDeviceID, xfer.to, xfer.toDeviceID, errorDetector.errorCode.name(), errorDetector.errorMessage);
                    bl4 = true;
                }
                if (n2 >= 5) {
                    bl = true;
                    if (this.a.getPreferencesService().getBooleanPref(IPreferences.ABANDON_RECV_ON_FAILS, false)) {
                        this.deleteFile(xfer.spaceid, xfer.fileid);
                        bl3 = true;
                        boolean bl6 = FileService.deleteFile(xfer.file);
                        if (bl6) {
                            LogService.log(">> FS.delete:" + bl6 + ", because it was abandoned, file:" + xfer.file.getAbsolutePath() + ", size:" + xfer.file.length() + ", user:" + xfer.from + "#" + xfer.fromDeviceID, Level.WARNING);
                        }
                    }
                }
            } else if (xfer.getXfered() > xfer.size) {
                bl = true;
                this.deleteFile(xfer.spaceid, xfer.fileid);
            } else if (xfer.getXferedSession() > 0L) {
                this.a.getPreferencesService().setPref(string, null);
            }
            if (bl) {
                if (!bl4) {
                    this.handleError(xfer.spaceid, xfer.fileid, xfer.from, xfer.fromDeviceID, xfer.to, xfer.toDeviceID, IErrors.CODE.TRANSFER_INTERRUPTED.name(), xfer.file.getAbsolutePath());
                }
                LogService.log(">> receive." + (bl3 ? "abandoned" : "interrupted") + "#" + n2 + ", from:" + xfer.from + "#" + xfer.fromDeviceID + ", sub:" + xfer.subject + ", file:" + xfer.file.getAbsolutePath() + ", xfered:" + xfer.getXfered() + " of " + xfer.size + ", deleted?" + bl2 + ", sid:" + xfer.spaceid + ", fid:" + xfer.fileid + xfer.getError(), Level.WARNING);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            this.a.getUsageService().addUsage(IUsage.USAGE.FILES_RCVD_FAILED_COUNT.name(), 1);
            EventService.publish(IEvent.EVENT.XFERENDED, xfer);
        }
    }

    @Override
    public final void handleFileStatusChanged(String string, String string2, String string3, String string4, byte by) {
        this.a.getPersistenceService().getFilesService().handleFileStatusChanged(string, string2, string3, string4, by);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Map<String, String>> checkForMissingFiles(String object5, List<Map<String, String>> list) {
        void var2_4;
        block21: {
            try {
                Object object;
                Map<String, String> map2;
                HashSet<Map<String, String>> hashSet = new HashSet<Map<String, String>>();
                Object object2 = new StringBuilder();
                for (Map<String, String> map2 : var2_4) {
                    try {
                        if (Byte.parseByte((String)map2.get(IFile.STATUS)) == IFile.FILE_STATUS_PENDING_RECEIVE) continue;
                        if (!this.doesFileExist(map2)) {
                            hashSet.add(map2);
                            ((StringBuilder)object2).append(map2.get(IFile.URI)).append(", ");
                            continue;
                        }
                        object = new File(map2.get(IFile.URI));
                        if (Long.parseLong(map2.get(IFile.SIZE)) != ((File)object).length()) {
                            this.a.getPersistenceService().getFilesService().updateFile((String)object5, map2.get(IFile.FILEID), IFile.SIZE, Long.toString(((File)object).length()));
                        }
                        map2.put(IFile.SIZE, Long.toString(((File)object).length()));
                        long l2 = 0L;
                        try {
                            l2 = Long.parseLong(map2.get(IFile.MODIFIED));
                        }
                        catch (Exception exception) {
                            try {
                                l2 = Long.parseLong(map2.get(IFile.CREATED));
                            }
                            catch (Exception exception2) {}
                        }
                        if (l2 != ((File)object).lastModified()) {
                            this.a.getPersistenceService().getFilesService().updateFile((String)object5, map2.get(IFile.FILEID), IFile.MODIFIED, Long.toString(((File)object).lastModified()));
                        }
                        map2.put(IFile.MODIFIED, Long.toString(((File)object).lastModified()));
                        map2.put(IFile.CREATED, Long.toString(FileService.getFileCreationTime((File)object)));
                    }
                    catch (Exception exception) {}
                }
                if (hashSet.isEmpty()) break block21;
                boolean bl = false;
                map2 = this.a.getSpaceService().getSpaceById((String)object5);
                object = this.a.getSpaceService().getMembers((String)object5);
                UUID.nameUUIDFromBytes("Missing".concat(String.valueOf(object5)).getBytes());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html><b>Files in message \"").append(map2.get(ISpace.SUBJECT)).append("\" could not be found. Have they been moved or are unavailable?</b><br><br>If they were on an external device, such as shared drive, memory sticks, USB drive or NAS drive then you need to ensure that the device remains active and available. You will need to find the missing files and send them again in another message.<br><br>");
                stringBuilder.append("<b>").append(hashSet.size()).append(" file(s) missing:</b><ol>");
                int n2 = 100;
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append(XMLUtil.xmlStartTag("files"));
                for (Map map3 : hashSet) {
                    try {
                        stringBuilder.append("<li>").append((String)map3.get(IFile.URI));
                    }
                    catch (Exception exception) {}
                    if (--n2 <= 0) break;
                    LogService.log(">> cmf.file no longer exists. sub" + map2.get(ISpace.SUBJECT) + ", file:" + (String)map3.get(IFile.URI) + ", sid:" + (String)object5 + ", fid:" + (String)map3.get(IFile.FILEID), Level.WARNING);
                    this.deleteFile((String)object5, (String)map3.get(IFile.FILEID));
                    this.addDeletedFile((String)object5, (String)map3.get(IFile.FILEID));
                    bl = true;
                    stringBuilder2.append(XMLUtil.xmlStartTag("file"));
                    stringBuilder2.append(XMLUtil.xmlTag(IFile.FILEID, (String)map3.get(IFile.FILEID)));
                    stringBuilder2.append(XMLUtil.xmlTag(ISpace.SPACEID, (String)object5));
                    stringBuilder2.append(XMLUtil.xmlEndTag("file"));
                    this.handleError((String)object5, null, this.a.getUserService().getSelfID(), this.a.getNetworkService().getSelfDeviceID(), "", "", IErrors.CODE.FILE_NOT_FOUND.name(), (String)map3.get(IFile.URI));
                }
                stringBuilder.append("</ol></html>");
                stringBuilder2.append(XMLUtil.xmlEndTag("files"));
                LogService.log("!ERROR. Some files in the job " + map2.get(ISpace.SUBJECT) + " could not be found.", Level.SEVERE);
                object2 = object.iterator();
                while (object2.hasNext()) {
                    Map map4 = (Map)object2.next();
                    try {
                        this.a.getMessageService().sendMessage((String)map4.get(IUser.USERID), (String)map4.get(IUser.DEVICEID), IMessage.MSG_SENDERFILEREMOVED, stringBuilder2.toString());
                    }
                    catch (Exception exception) {}
                }
                object2 = UUID.nameUUIDFromBytes("missingfilenotfnsent-".concat(String.valueOf(object5)).getBytes()).toString();
                if (this.a.getPreferencesService().getPref((String)object2, "false").equalsIgnoreCase("false")) {
                    this.a.getPreferencesService().setPref((String)object2, "true");
                    new Thread(this, (String)object5){
                        private /* synthetic */ String a;
                        private /* synthetic */ q b;
                        {
                            this.b = q2;
                            this.a = string;
                        }

                        @Override
                        public final void run() {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(XMLUtil.xmlTag(IUser.USERID, this.b.a.getUserService().getSelfID()));
                            stringBuilder.append(XMLUtil.xmlTag(ISpace.SPACEID, this.a));
                            stringBuilder.append(XMLUtil.xmlTag(IFile.STATUS, ISpace.SPACE_STATE_MISSING_FILES));
                            try {
                                this.b.a.getMessageService().postXMLMessage("ms", stringBuilder.toString());
                                return;
                            }
                            catch (Exception exception) {
                                return;
                            }
                        }
                    }.start();
                }
                for (Map map5 : hashSet) {
                    var2_4.remove(map5);
                }
                if (bl) {
                    EventService.publishNow(IEvent.EVENT.SPACECHANGED, ISpace.SPACE_TYPE_SENT);
                }
            }
            catch (Exception exception) {}
        }
        return var2_4;
    }

    @Override
    public final boolean doesFileExist(Map<String, String> object) {
        try {
            object = new File(object.get(IFile.URI));
            return ((File)object).exists() && ((File)object).length() > 0L;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public final int getFilesCount(String object) {
        int n2 = 0;
        object = this.a.getSpaceService().getSpaceOptions((String)object);
        try {
            if (object != null) {
                n2 = Integer.parseInt((String)object.get(IFile.FILESCOUNT));
            }
        }
        catch (Exception exception) {}
        return n2;
    }

    @Override
    @Deprecated
    public final int getFilesCountTotal(String string) {
        return this.getFilesCount(string);
    }

    private static String a(Calendar calendar, String string, String string2, byte by) {
        return IPreferences.DATA_USAGE_ + calendar.get(2) + calendar.get(1) + "_" + string + string2 + "_" + by;
    }

    private static String b(Calendar calendar, String string, String string2, byte by) {
        return IPreferences.DATA_USAGE_COUNT_ + calendar.get(2) + calendar.get(1) + "_" + string + string2 + "_" + by;
    }

    private void a(String string, String string2, long l2, byte by) {
        try {
            Calendar calendar = Calendar.getInstance();
            String string3 = q.a(calendar, string, string2, by);
            this.a.getUsageService().addUsage(string3, l2);
            this.a.getUsageService().addUsage(q.b(calendar, string, string2, by), 1);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public final long getMonthlyDataUsage(String string, String string2, Calendar calendar, byte by) {
        long l2 = 0L;
        try {
            string = q.a(calendar, string, string2, by);
            l2 = (long)this.a.getUsageService().getUsage(string);
        }
        catch (Exception exception) {}
        return l2;
    }

    private long a(String string, String string2, Calendar calendar, byte by) {
        long l2 = 0L;
        try {
            string = q.b(calendar, string, string2, by);
            l2 = (long)this.a.getUsageService().getUsage(string);
        }
        catch (Exception exception) {}
        return l2;
    }

    @Override
    public final List<Map<String, String>> getMonthlyDataUsage(Calendar calendar) {
        LinkedList<Map<String, String>> linkedList = new LinkedList<Map<String, String>>();
        try {
            Object object = this.a.getContactsService().getDevices(true);
            object.add(this.a.getContactsService().getDevice(this.a.getUserService().getSelfID(), this.a.getNetworkService().getSelfDeviceID()));
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (Map)object.next();
                try {
                    String string = (String)object2.get(IUser.USERID);
                    object2 = (String)object2.get(IUser.DEVICEID);
                    long l2 = this.getMonthlyDataUsage(string, (String)object2, calendar, IFile.FILE_STATUS_SENT);
                    long l3 = this.getMonthlyDataUsage(string, (String)object2, calendar, IFile.FILE_STATUS_RECEIVED);
                    long l4 = this.a(string, (String)object2, calendar, IFile.FILE_STATUS_SENT);
                    long l5 = this.a(string, (String)object2, calendar, IFile.FILE_STATUS_RECEIVED);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put(IUser.USERID, string);
                    hashMap.put(IUser.DEVICEID, object2);
                    hashMap.put(IPreferences.DATA_USAGE_ + IFile.FILE_STATUS_SENT, Long.toString(l2));
                    hashMap.put(IPreferences.DATA_USAGE_ + IFile.FILE_STATUS_RECEIVED, Long.toString(l3));
                    hashMap.put(IPreferences.DATA_USAGE_COUNT_ + IFile.FILE_STATUS_SENT, Long.toString(l4));
                    hashMap.put(IPreferences.DATA_USAGE_COUNT_ + IFile.FILE_STATUS_RECEIVED, Long.toString(l5));
                    hashMap.put(IFile.SIZE, Long.toString(l3 + l2));
                    hashMap.put(IPreferences.DATA_IN_MAXUSAGE_PERMONTH, this.a.getContactsService().getDeviceProperty(string, (String)object2, IPreferences.DATA_IN_MAXUSAGE_PERMONTH));
                    hashMap.put(IPreferences.DATA_OUT_MAXUSAGE_PERMONTH, this.a.getContactsService().getDeviceProperty(string, (String)object2, IPreferences.DATA_OUT_MAXUSAGE_PERMONTH));
                    linkedList.add(hashMap);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        return linkedList;
    }

    @Override
    public final void addXferLog(String string, String string2, byte by, String string3, String string4, String string5, String string6, String string7, String string8, Date date, long l2, int n2, String string9, String string10, String string11, long l3) {
        this.a.getPersistenceService().getXferLogService().addXferLog(string, string2, by, string3, string4, string5, string6, string7, string8, date, l2, n2, string9, string10, string11, l3);
    }

    @Override
    public final int getXfersLogsCount(String string, byte by) {
        return this.a.getPersistenceService().getXferLogService().getXfersLogsCount(string, by);
    }

    @Override
    public final int getXfersLogsCount(String string, String string2, String string3, byte by) {
        return this.a.getPersistenceService().getXferLogService().getXfersLogsCount(string, string2, string3, by);
    }

    @Override
    public final int getFileXfersLogsCountByKey(String string, String string2, String string3, String string4, byte by) {
        return this.a.getPersistenceService().getXferLogService().getFileXfersLogsCountByKey(string, string2, string3, string4, by);
    }

    @Override
    public final IPagedResult getXferLogs(String string, String string2, String string3, Date date, Date date2, byte by, String string4, boolean bl, int n2) throws Exception {
        return this.a.getPersistenceService().getXferLogService().getXferLogs(string, string2, string3, date, date2, by, string4, bl, n2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Map<String, String>> getXferLogs(byte by, String object, Date object22, Date date) {
        void var4_7;
        List<Map<String, String>> list = this.a.getPersistenceService().getXferLogService().getXferLogs(by, (String)((Object)object), (Date)object22, (Date)var4_7);
        try {
            for (Map<String, String> map : list) {
                map.put(IUser.FNAME, this.a.getContactsService().getFirstName(map.get(IUser.USERID)));
            }
        }
        catch (Exception exception) {}
        return list;
    }

    @Override
    public final List<Map<String, String>> getXferLogs(String object, byte by, String object2, Date date, Date date2) {
        object = this.a.getPersistenceService().getXferLogService().getXferLogs((String)object, by, (String)object2, date, date2);
        try {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object2 = (Map)iterator.next();
                object2.put(IUser.FNAME, this.a.getContactsService().getFirstName((String)object2.get(IUser.USERID)));
            }
        }
        catch (Exception exception) {}
        return object;
    }

    @Override
    public final void deleteXferLogs(String string) {
        this.a.getPersistenceService().getXferLogService().deleteXferLogs(string);
    }

    @Override
    public final void deleteXferLogs(String string, String string2) {
        this.a.getPersistenceService().getXferLogService().deleteXferLogs(string, string2);
    }

    @Override
    public final void deleteXferLogs(String string, String string2, String string3) {
        this.a.getPersistenceService().getXferLogService().deleteXferLogs(string, string2, string3);
    }

    @Override
    public final boolean isAlreadyXfered(String string, String string2, String string3, String string4, byte by) {
        return this.a.getPersistenceService().getXferLogService().isAlreadyXfered(string, string2, string3, string4, by);
    }

    @Override
    public final boolean hasNextPendingReceive(String string, String string2) {
        return this.a.getPersistenceService().getFilesService().hasNextPendingReceive(string, string2);
    }

    @Override
    public final boolean hasNextPendingReceive(String string, String string2, String string3) {
        return this.a.getPersistenceService().getFilesService().hasNextPendingReceive(string, string2, string3);
    }

    @Override
    public final boolean hasNextPendingSend(String string, String string2, String string3) {
        return this.a.getPersistenceService().getFilesService().hasNextPendingSend(string, string2, string3);
    }

    @Override
    public final boolean hasNextPendingReceive(int n2, String string, String string2) {
        return this.a.getPersistenceService().getFilesService().hasNextPendingReceive(n2, string, string2);
    }

    @Override
    public final String getThumbnailsAsXML(List<File> object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(XMLUtil.xmlStartTag(IMessage.EMBEDDEDIMAGES));
        int n2 = 5;
        Iterator<File> iterator = object.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            try {
                object = this.a.getPlatformService().getThumbnailBytes(file, 100, 100);
                stringBuilder.append(XMLUtil.xmlStartTag(IMessage.IMAGE));
                stringBuilder.append(XMLUtil.xmlTag(IMessage.CONTENT, new String(new Base64().encode((byte[])object))));
                stringBuilder.append(XMLUtil.xmlTag("NAME", UUID.nameUUIDFromBytes(file.getAbsolutePath().getBytes()).toString() + file.getName()));
                stringBuilder.append(XMLUtil.xmlEndTag(IMessage.IMAGE));
            }
            catch (Throwable throwable) {}
            if (n2-- > 0) continue;
        }
        stringBuilder.append(XMLUtil.xmlEndTag(IMessage.EMBEDDEDIMAGES));
        return stringBuilder.toString();
    }

    @Override
    public final void sendMessageFileRemoved(String string, String string2) {
        try {
            for (Map<String, String> map : this.a.getSpaceService().getMembers(string)) {
                try {
                    String string3 = map.get(IUser.USERID);
                    String string4 = map.get(IUser.DEVICEID);
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(XMLUtil.xmlStartTag("files"));
                    stringBuilder.append(XMLUtil.xmlStartTag("file"));
                    stringBuilder.append(XMLUtil.xmlTag(IFile.FILEID, string2));
                    stringBuilder.append(XMLUtil.xmlTag(ISpace.SPACEID, string));
                    stringBuilder.append(XMLUtil.xmlEndTag("file"));
                    stringBuilder.append(XMLUtil.xmlEndTag("files"));
                    this.a.getMessageService().sendMessage(string3, string4, IMessage.MSG_SENDERFILEREMOVED, stringBuilder.toString());
                }
                catch (Exception exception) {}
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public final void sendMessageFileRemoved(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(XMLUtil.xmlStartTag("files"));
        stringBuilder.append(XMLUtil.xmlStartTag("file"));
        stringBuilder.append(XMLUtil.xmlTag(IFile.FILEID, string2));
        stringBuilder.append(XMLUtil.xmlTag(ISpace.SPACEID, string));
        stringBuilder.append(XMLUtil.xmlEndTag("file"));
        stringBuilder.append(XMLUtil.xmlEndTag("files"));
        try {
            this.a.getMessageService().sendMessage(string3, string4, IMessage.MSG_SENDERFILEREMOVED, stringBuilder.toString());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public final void deleteDeletedFiles(String string) {
        this.a.getPersistenceService().getFilesService().deleteDeletedFiles(string);
    }

    @Override
    public final List<Map<String, String>> getFoldersByParentURIID(String string, String string2) {
        return this.a.getPersistenceService().getFilesService().getFoldersByParentURIID(string, string2);
    }

    @Override
    public final IPagedResult getFilesByParentURIID(String string, String string2, int n2) {
        return this.a.getPersistenceService().getFilesService().getFilesByParentURIID(string, string2, n2);
    }

    @Override
    public final IPagedResult getFilesByStatus(String string, boolean bl, byte by, long l2) throws Exception {
        return this.a.getPersistenceService().getFilesService().getFilesByStatus(string, bl, by, l2);
    }

    @Override
    public final IPagedResult getFilesByStatus(String string, boolean bl, String string2, byte by, long l2) throws Exception {
        return this.a.getPersistenceService().getFilesService().getFilesByStatus(string, bl, string2, by, l2);
    }

    @Override
    public final IPagedResult getFilesByStatus(String string, String string2, byte by, long l2) throws Exception {
        return this.a.getPersistenceService().getFilesService().getFilesByStatus(string, string2, by, l2);
    }

    @Override
    public final boolean isPendingReceive(String string, String string2) {
        return this.a.getPersistenceService().getFilesService().isPendingReceive(string, string2);
    }

    @Override
    public final boolean isPendingSend(String string, String string2, String string3) {
        return this.a.getPersistenceService().getFilesService().isPendingSend(string, string2, string3);
    }

    @Override
    public final boolean isPendingSend(String string, String string2) {
        boolean bl = false;
        for (Map<String, String> map : this.a.getSpaceService().getMembers(string)) {
            if (this.isAlreadyXfered(string, string2, map.get(IUser.USERID), map.get(IUser.DEVICEID), IFile.FILE_STATUS_SENT)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public final IPagedResult getFilesByKeyword(String string, String string2, long l2) throws Exception {
        return this.a.getPersistenceService().getFilesService().getFilesByKeyword(string, string2, l2);
    }

    @Override
    public final void handleError(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        try {
            this.a.getErrorsService().add(string, string2, string3, string4, string5, string6, string7, string8, System.currentTimeMillis());
            this.b.a(string);
            return;
        }
        catch (Exception exception) {
            LogService.log(">> Error processing error.from:" + string3 + "#" + string4 + ", to:" + string5 + "#" + string6 + " error:" + string7 + ", details:" + string8 + ", expn:" + exception.getMessage(), Level.SEVERE);
            return;
        }
    }

    @Override
    public final void deletePending(String string) {
        this.a.getPersistenceService().getFilesService().deletePending(string);
        this.a(string);
        this.a(string);
    }

    @Override
    public final void deletePending(String string, String string2, String string3) {
        this.a.getPersistenceService().getFilesService().deletePending(string, string2, string3);
    }

    @Override
    public final int getPendingCount(String string, byte by) {
        return this.a.getPersistenceService().getFilesService().getPendingCount(string, by);
    }

    @Override
    public final void flushUsageBuffer() {
        J.a().b();
    }
}

