/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop;

import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.ICallback;
import com.binfer.base.service.IUser;
import com.binfer.base.service.LogService;
import com.binfer.desktop.BinferDesktopService;
import com.binfer.desktop.shared.BinferApplication;
import com.binfer.desktop.shared.SystemTrayHelper;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.concurrent.Task;

public class BinferDesktopApplication
extends BinferApplication {
    private static BinferDesktopApplication instance;
    private SystemTrayHelper systemTray;

    public static BinferDesktopApplication getInstance() {
        return instance;
    }

    public BinferDesktopApplication() throws Exception {
        instance = this;
    }

    public BinferDesktopApplication(String[] params, ICallback callback) throws Exception {
        BinferDesktopApplication.callback = callback;
        try {
            BinferDesktopApplication.launch((String[])params);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showPopup("Failed to start because", null, 400);
        }
    }

    @Override
    protected void onBeforeReady() {
        BinferDesktopService.getInstance().init(this.args);
    }

    @Override
    protected void onReady() {
        this.setTitle("Binfer Personal Sync/Transfer");
        if (BinferProperties.getBooleanProperty("ISINITED", false)) {
            this.login();
        } else {
            this.setView("/com/binfer/desktop/shared/ui/setup/login.fxml");
        }
    }

    @Override
    public void login() {
        this.setView("/com/binfer/desktop/shared/ui/loading.fxml");
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                try {
                    BinferDesktopService.getInstance().login();
                }
                catch (Exception e) {
                    LogService.log("EXPN.login failed", Level.SEVERE);
                    BinferDesktopApplication.this.showError("Failed to start after login because " + e.getMessage());
                    e.printStackTrace();
                    throw e;
                }
                return null;
            }
        };
        task.setOnSucceeded(e -> {
            this.postInit();
            if (callback != null) {
                callback.handleEvent("ready", "ready");
            }
            this.setView("/com/binfer/desktop/jobs/jobs.fxml");
        });
        task.setOnFailed(e -> LogService.log("Failed to start after login because " + e.toString() + ", " + e.getSource().getMessage(), Level.SEVERE));
        Thread thread = new Thread((Runnable)task);
        thread.setDaemon(true);
        thread.start();
    }

    private void postInit() {
        try {
            this.systemTray = new SystemTrayHelper(this.getStage(), BinferDesktopService.getInstance().getCoreService());
        }
        catch (Exception e) {
            LogService.log("Failed to set system tray." + e.getMessage(), Level.WARNING);
            e.printStackTrace();
            this.showError("Failed to set system tray." + e.getMessage());
        }
        this.applyPrefDimensions();
        this.setTitle();
    }

    public void setTitle() {
        try {
            super.setTitle("Binfer Personal Sync. Welcome! User ID: " + BinferProperties.getProperty(IUser.USERID, "") + ", Account ID: " + BinferProperties.getProperty(IUser.ACCOUNTID, ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getIconResource() {
        return "/resources/icons/binfer_logo_blue_256.png";
    }

    @Override
    public synchronized void logout(final boolean showConfirmation) {
        if (Platform.isFxApplicationThread()) {
            BinferDesktopApplication.getInstance()._logout(showConfirmation);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    BinferDesktopApplication.getInstance()._logout(showConfirmation);
                }
            });
        }
    }

    private void _logout(boolean showConfirmation) {
        block9: {
            try {
                boolean exit = true;
                if (showConfirmation) {
                    exit = this.showYesNoDialog("If you exit Binfer, you will not be able to transfer files. Do you want to exit Binfer?");
                }
                if (!exit) break block9;
                this.startWaitCursor();
                try {
                    this.savePrefDimensions();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    BinferDesktopService.getInstance().logout();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                instance = null;
                this.stage = null;
                try {
                    System.exit(0);
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                LogService.log("BCS.logout error:" + e.getMessage(), Level.WARNING);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            BinferDesktopApplication.launch((String[])args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

