/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop;

import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.IBinfer;
import com.binfer.base.service.ILicense;
import com.binfer.base.service.INetwork;
import com.binfer.base.service.IPreferences;
import com.binfer.base.service.IUser;
import com.binfer.base.util.Collections;
import com.binfer.core.service.IService;
import com.binfer.desktop.shared.HttpServer;
import java.io.File;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;

public class BinferDesktopService {
    private static BinferDesktopService instance = null;
    private HttpServer server;

    private BinferDesktopService() {
        BinferProperties.setProperty(IPreferences.INSTALLTYPE, IBinfer.INSTALL_TYPE.CLIENT.name());
        BinferProperties.setProperty(IPreferences.CLIENTTYPE, IBinfer.CLIENT_TYPE.CLIENT_SYNC_PERSONAL.name());
        BinferProperties.setProperty(IPreferences.SETUPTYPE, IBinfer.SETUP_TYPE.DESKTOP.name());
        BinferProperties.setProperty(ILicense.PROPS.PRODUCT.name(), ILicense.PRODUCT.SYNC_PERSONAL.name());
        this.server = new HttpServer();
    }

    public static BinferDesktopService getInstance() {
        if (instance == null) {
            instance = new BinferDesktopService();
        }
        return instance;
    }

    public void init(String[] args) {
        String userHomePath;
        Map<Object, Object> props = new HashMap();
        if (args != null && args.length > 0) {
            props = Collections.paramsToMap(args[0], ",", "=");
        }
        String currPath = new File("").getAbsolutePath();
        if (!props.containsKey(IPreferences.INSTALLDIR)) {
            BinferProperties.setProperty(IPreferences.INSTALLDIR, currPath);
        }
        try {
            userHomePath = new File(System.getProperty("user.home")).getAbsolutePath();
        }
        catch (Exception e) {
            userHomePath = currPath;
        }
        if (!BinferProperties.hasProperty(IPreferences.SYSTEMPATH)) {
            BinferProperties.setProperty(IPreferences.SYSTEMPATH, new File(userHomePath, "BinferSync").getAbsolutePath());
        }
        BinferProperties.load();
        File logsDir = new File(BinferProperties.getProperty(IPreferences.INSTALLDIR), "logs");
        logsDir.mkdirs();
        BinferProperties.setProperty(IPreferences.INSTALLTYPE, IBinfer.INSTALL_TYPE.CLIENT.name());
        BinferProperties.setProperty(IPreferences.CLIENTTYPE, IBinfer.CLIENT_TYPE.CLIENT_SYNC_PERSONAL.name());
        BinferProperties.setProperty(IPreferences.SETUPTYPE, IBinfer.SETUP_TYPE.DESKTOP.name());
        BinferProperties.setProperty(ILicense.PROPS.PRODUCT.name(), ILicense.PRODUCT.SYNC_PERSONAL.name());
        if (!BinferProperties.hasProperty(IPreferences.DOWNLOADPATH)) {
            BinferProperties.setProperty(IPreferences.DOWNLOADPATH, new File(userHomePath, "Desktop/BinferSync").getAbsolutePath());
        }
        int port = 1214;
        if (!BinferProperties.hasProperty(INetwork.HTTPPORT)) {
            BinferProperties.setProperty(INetwork.HTTPPORT, "" + port);
        }
        try {
            if (!BinferProperties.hasProperty(IUser.DEVICENAME)) {
                BinferProperties.setProperty(IUser.DEVICENAME, InetAddress.getLocalHost().getHostName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void login() throws Exception {
        this.server.start(BinferProperties.propertiesToMap());
    }

    public void logout() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IService getCoreService() {
        return this.server.getCoreService();
    }
}

