/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.currenttransfers;

import com.binfer.base.service.ICallback;
import com.binfer.base.service.IEvent;
import com.binfer.base.service.IFile;
import com.binfer.base.service.TransfersService;
import com.binfer.base.util.TransferBean;
import com.binfer.desktop.BinferDesktopApplication;
import com.binfer.desktop.BinferDesktopService;
import com.binfer.desktop.shared.ui.IView;
import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;

public class CurrentTransfersController
implements Initializable,
IView {
    private ObservableList<TransferBean> data = FXCollections.observableArrayList();
    @FXML
    private TableColumn<TransferBean, String> statusColumn;
    @FXML
    private TableColumn<TransferBean, String> msgColumn;
    @FXML
    private TableColumn<TransferBean, String> contactColumn;
    @FXML
    private TableColumn<TransferBean, String> fileColumn;
    @FXML
    private TableColumn<TransferBean, Double> progressColumn;
    @FXML
    private TableColumn<TransferBean, String> timeColumn;
    @FXML
    private TableView<TransferBean> tableView;
    private ICallback<IEvent.EVENT, TransferBean> callback = new ICallback<IEvent.EVENT, TransferBean>(){

        @Override
        public void handleEvent(final IEvent.EVENT event, final TransferBean tb) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        if (event == IEvent.EVENT.XFERSTARTED) {
                            CurrentTransfersController.this.data.remove((Object)tb);
                            CurrentTransfersController.this.data.add(0, (Object)tb);
                        } else if (event == IEvent.EVENT.XFERPROGRESSCHANGED || event == IEvent.EVENT.REMOVED || event == IEvent.EVENT.XFERFAILED) {
                            // empty if block
                        }
                        CurrentTransfersController.this.tableView.refresh();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    };

    public void initialize(URL url, ResourceBundle rb) {
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.statusColumn.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.msgColumn.setCellValueFactory((Callback)new PropertyValueFactory("subject"));
        this.contactColumn.setCellValueFactory((Callback)new PropertyValueFactory("owner"));
        this.fileColumn.setCellValueFactory((Callback)new PropertyValueFactory("file"));
        this.progressColumn.setCellValueFactory((Callback)new PropertyValueFactory("progress"));
        this.timeColumn.setCellValueFactory((Callback)new PropertyValueFactory("FinishTime"));
        this.tableView.setItems(this.data);
        this.tableView.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    TransferBean rowData = (TransferBean)row.getItem();
                    try {
                        Map file = BinferDesktopService.getInstance().getCoreService().getFilesService().getFile(rowData.getXfer().spaceid, rowData.getXfer().fileid);
                        BinferDesktopApplication.getInstance().openURI(new File((String)file.get(IFile.URI)).toURI());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return row;
        });
        this.data.addAll(TransfersService.getInstance().getReverse());
        TransfersService.getInstance().setHandler(this.callback);
    }

    @Override
    public void onCreate(Object data) {
    }

    @Override
    public void refresh(Object data) {
    }

    @Override
    public void onDestroy(Object data) {
        TransfersService.getInstance().setHandler(null);
    }

    @FXML
    private void handleClearClicked(ActionEvent event) {
        TransfersService.getInstance().clear();
        this.tableView.getItems().clear();
    }
}

