/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.devices;

import com.binfer.base.service.IUser;
import com.binfer.desktop.BinferDesktopService;
import com.binfer.desktop.devices.DeviceCheckBoxListCell;
import com.binfer.desktop.devices.DeviceItem;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;

public class DevicesController
implements Initializable {
    private ObservableList<DeviceItem> itemList = FXCollections.observableArrayList();
    @FXML
    private ListView<DeviceItem> listView;

    public void initialize(URL url, ResourceBundle rb) {
        this.listView.setItems(this.itemList);
        this.listView.setCellFactory((Callback)new Callback<ListView<DeviceItem>, ListCell<DeviceItem>>(){

            public ListCell<DeviceItem> call(ListView<DeviceItem> param) {
                return new DeviceCheckBoxListCell();
            }
        });
        this.refresh();
    }

    public void refresh() {
        try {
            this.itemList.clear();
            List devices = BinferDesktopService.getInstance().getCoreService().getContactsService().getDevices(true);
            LinkedList<Map> activeDevices = new LinkedList<Map>();
            for (Map device : devices) {
                try {
                    if (!device.containsKey(IUser.DEVICEID)) continue;
                    activeDevices.add(device);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (Map member : activeDevices) {
                this.itemList.add((Object)new DeviceItem(member));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<DeviceItem> getSelected() {
        return this.itemList.stream().filter(DeviceItem::isSelected).collect(Collectors.toList());
    }

    public Collection<Map<String, String>> getSelectedAsMap() {
        LinkedList<Map<String, String>> selectedDevices = new LinkedList<Map<String, String>>();
        for (DeviceItem member : this.getSelected()) {
            selectedDevices.add(member.member);
        }
        return selectedDevices;
    }
}

