/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.files;

import com.binfer.base.service.IFile;
import com.binfer.desktop.BinferDesktopApplication;
import com.binfer.desktop.files.FileTableModel;
import com.binfer.desktop.shared.BinferApplication;
import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Callback;

public class FilesController
implements Initializable {
    ObservableList<FileTableModel> filesList;
    final FileChooser fileChooser = new FileChooser();
    @FXML
    private TableView<FileTableModel> filesTableView;
    @FXML
    private TableColumn<FileTableModel, String> folderNameColumn;
    @FXML
    private TableColumn<FileTableModel, String> fileNameColumn;
    @FXML
    private TableColumn<FileTableModel, String> sizeColumn;
    @FXML
    private TableColumn<FileTableModel, String> dateColumn;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.folderNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("folderName"));
            this.fileNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("fileName"));
            this.sizeColumn.setCellValueFactory((Callback)new PropertyValueFactory("size"));
            this.dateColumn.setCellValueFactory((Callback)new PropertyValueFactory("date"));
            this.filesList = FXCollections.observableArrayList();
            this.filesTableView.setItems(this.filesList);
            this.filesTableView.setUserData((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.filesTableView.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                if (event.getGestureSource() != FilesController.this.filesTableView && event.getDragboard().hasFiles()) {
                    event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                }
                event.consume();
            }
        });
        this.filesTableView.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Dragboard db = event.getDragboard();
                boolean success = false;
                if (db.hasFiles()) {
                    FilesController.this.add(db.getFiles());
                    success = true;
                }
                event.setDropCompleted(success);
                event.consume();
            }
        });
        this.filesTableView.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    try {
                        FileTableModel rowData = (FileTableModel)row.getItem();
                        BinferDesktopApplication.getInstance().openURI(new File(rowData.fileMap.get(IFile.URI)).toURI());
                    }
                    catch (Exception e) {
                        BinferDesktopApplication.getInstance().showWarning("Failed to open file because " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
            return row;
        });
    }

    public void remove() {
        if (this.filesTableView.getSelectionModel() == null) {
            return;
        }
        ObservableList selected = this.filesTableView.getSelectionModel().getSelectedItems();
        for (FileTableModel data : selected) {
            if (!this.filesList.contains((Object)data)) continue;
            this.filesList.remove((Object)data);
        }
    }

    public void add() {
        List files = this.fileChooser.showOpenMultipleDialog((Window)BinferApplication.getInstance().getStage());
        this.add(files);
    }

    public void add(List<File> files) {
        for (File file : files) {
            FileTableModel model = new FileTableModel(file);
            this.filesList.add((Object)model);
        }
    }

    public void addFiles(List<Map<String, String>> files) {
        for (Map<String, String> file : files) {
            try {
                FileTableModel model = new FileTableModel(new File(file.get(IFile.URI)));
                this.filesList.add((Object)model);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<File> getFiles() {
        LinkedList<File> files = new LinkedList<File>();
        for (FileTableModel tm : this.filesList) {
            files.add(tm.file);
        }
        return files;
    }
}

