/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.jobmembers;

import com.binfer.base.util.Space;
import com.binfer.desktop.BinferDesktopApplication;
import com.binfer.desktop.devices.DeviceCheckBoxListCell;
import com.binfer.desktop.devices.DeviceItem;
import com.binfer.desktop.devices.DevicesController;
import com.binfer.desktop.shared.ViewHolder;
import com.binfer.desktop.shared.ui.IView;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ToolBar;
import javafx.util.Callback;

public class JobMembersController
implements Initializable,
IView {
    private Space job;
    private ObservableList<DeviceItem> itemList = FXCollections.observableArrayList();
    @FXML
    private ListView<DeviceItem> listView;
    @FXML
    private ToolBar membersToolbar;

    public void initialize(URL url, ResourceBundle rb) {
        this.listView.setItems(this.itemList);
        this.listView.setCellFactory((Callback)new Callback<ListView<DeviceItem>, ListCell<DeviceItem>>(){

            public ListCell<DeviceItem> call(ListView<DeviceItem> param) {
                return new DeviceCheckBoxListCell();
            }
        });
    }

    @Override
    public void onCreate(Object data) {
        try {
            this.refresh(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDestroy(Object data) {
    }

    @Override
    public void refresh(Object data) {
        try {
            this.job = (Space)Space.class.cast(data);
            this.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refresh() {
        this.itemList.clear();
        Collection<Map<String, String>> members = this.job.getMembers();
        for (Map<String, String> member : members) {
            this.itemList.add((Object)new DeviceItem(member));
        }
    }

    @FXML
    private void handeRemoveClicked(ActionEvent event) {
        boolean response = BinferDesktopApplication.getInstance().showYesNoDialog("Do you want to remove selected members?");
        if (response) {
            this.removeMembers();
        }
    }

    private void removeMembers() {
        List selectedItems = this.itemList.stream().filter(DeviceItem::isSelected).collect(Collectors.toList());
        for (DeviceItem member : selectedItems) {
            this.itemList.remove((Object)member);
        }
        if (this.itemList.isEmpty()) {
            BinferDesktopApplication.getInstance().showWarning("Must contain at least one device");
            this.refresh();
        }
    }

    @FXML
    private void handeAddClicked(ActionEvent event) {
        ViewHolder vh = BinferDesktopApplication.getInstance().showViewInDialog("/com/binfer/desktop/devices/devices.fxml", this.job, "Select devices and close", "", false, (e, o) -> {});
        try {
            DevicesController devicesController = (DevicesController)DevicesController.class.cast(vh.controller);
            List<DeviceItem> selected = devicesController.getSelected();
            for (DeviceItem item : selected) {
                this.itemList.remove((Object)item);
                this.itemList.add((Object)item);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public Collection<Map<String, String>> getSelected() {
        LinkedList<Map<String, String>> selectedDevices = new LinkedList<Map<String, String>>();
        List selectedItems = this.itemList.stream().filter(DeviceItem::isSelected).collect(Collectors.toList());
        for (DeviceItem member : selectedItems) {
            selectedDevices.add(member.member);
        }
        return selectedDevices;
    }

    public Collection<Map<String, String>> getMembers() {
        LinkedList<Map<String, String>> selectedDevices = new LinkedList<Map<String, String>>();
        List selectedItems = this.itemList.stream().collect(Collectors.toList());
        for (DeviceItem member : selectedItems) {
            selectedDevices.add(member.member);
        }
        return selectedDevices;
    }

    public void setReadOnly() {
        this.membersToolbar.setVisible(false);
    }
}

