/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.jobs;

import com.binfer.base.service.IFile;
import com.binfer.base.service.ISpace;
import com.binfer.base.util.Space;
import com.binfer.desktop.BinferDesktopApplication;
import com.binfer.desktop.shared.ui.IView;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;

public class JobSummaryController
implements Initializable,
IView {
    private Space job;
    @FXML
    private Label subjectLabel;
    @FXML
    private Label descLabel;
    @FXML
    private Label countLabel;
    @FXML
    private Label xferedLabel;
    @FXML
    private Label pendingLabel;
    @FXML
    private Label jobType;
    @FXML
    private Label ownerLabel;

    public void initialize(URL url, ResourceBundle rb) {
    }

    @Override
    public void onCreate(Object data) {
        this.job = (Space)Space.class.cast(data);
        this.subjectLabel.setText(this.job.getSubject());
        this.ownerLabel.setText(this.job.getOwner());
        try {
            this.descLabel.setText(this.job.getDescription().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.job.getType() == ISpace.SPACE_TYPE_SYNC) {
            this.jobType.setText("SYNC");
        } else if (this.job.getType() == ISpace.SPACE_TYPE_TRANSFER) {
            this.jobType.setText("TRANSFER");
        }
        int filesCount = 0;
        try {
            filesCount = Integer.parseInt(this.job.getOptions().get(IFile.FILESCOUNT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.countLabel.setText(Integer.toString(filesCount));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int pendingSend = 0;
        try {
            pendingSend = Integer.parseInt(this.job.getOptions().get(IFile.COUNTPENDINGSEND));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int pendingRecv = 0;
        try {
            pendingRecv = Integer.parseInt(this.job.getOptions().get(IFile.COUNTPENDINGRECEIVE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pendingSend < 0) {
            pendingSend = 0;
        }
        if (pendingRecv < 0) {
            pendingRecv = 0;
        }
        try {
            this.pendingLabel.setText(Integer.toString(pendingSend + pendingRecv));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int totalSent = 0;
        try {
            totalSent = Integer.parseInt(this.job.getOptions().get(IFile.COUNTSENT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int totalRcvd = 0;
        try {
            totalRcvd = Integer.parseInt(this.job.getOptions().get(IFile.COUNTRECEIVED));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (totalSent < 0) {
            totalSent = 0;
        }
        if (totalRcvd < 0) {
            totalRcvd = 0;
        }
        try {
            this.xferedLabel.setText(Integer.toString(totalSent + totalRcvd));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onDestroy(Object data) {
    }

    @Override
    public void refresh(Object data) {
    }

    @FXML
    private void handleMouseClicked(MouseEvent event) {
        if (this.job.getType() == ISpace.SPACE_TYPE_SYNC) {
            BinferDesktopApplication.getInstance().showViewInDialog("/com/binfer/desktop/sync/syncjobedit.fxml", this.job, "Edit " + this.job.getSubject(), "", false, (e, o) -> {});
        } else if (this.job.getType() == ISpace.SPACE_TYPE_TRANSFER) {
            BinferDesktopApplication.getInstance().showViewInDialog("/com/binfer/desktop/transfer/transferjobedit.fxml", this.job, "Edit " + this.job.getSubject(), "", false, (e, o) -> {});
        }
    }
}

