/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.jobs;

import com.binfer.base.service.EventService;
import com.binfer.base.service.IEvent;
import com.binfer.base.service.ISpace;
import com.binfer.base.util.Space;
import com.binfer.desktop.BinferDesktopApplication;
import com.binfer.desktop.BinferDesktopService;
import com.binfer.desktop.jobs.SelectJobTypeController;
import com.binfer.desktop.shared.BinferApplication;
import com.binfer.desktop.shared.ViewHolder;
import com.binfer.desktop.util.ObservableLimitedList;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ListView;
import javafx.scene.layout.BorderPane;

public class JobsController
implements Initializable {
    private Collection<Byte> spaceTypes = new HashSet<Byte>();
    private ObservableList<Node> jobsList;
    @FXML
    private BorderPane syncJobsContainer;
    @FXML
    private ListView<Node> listView;

    public void initialize(URL url, ResourceBundle rb) {
        this.spaceTypes.add(ISpace.SPACE_TYPE_SYNC);
        this.spaceTypes.add(ISpace.SPACE_TYPE_TRANSFER);
        this.jobsList = new ObservableLimitedList(Integer.MAX_VALUE);
        this.listView.setItems(this.jobsList);
        this.refresh();
        EventService.subscribe(IEvent.EVENT.SPACECHANGED, (e, o) -> Platform.runLater(() -> this.refresh()));
    }

    @FXML
    private void handleAddClicked(ActionEvent event) {
        ViewHolder vh = BinferDesktopApplication.getInstance().showViewInDialog("/com/binfer/desktop/jobs/selectjobtype.fxml", "", "Select the job type", "", true, (e, o) -> {});
        try {
            byte jobType = ((SelectJobTypeController)SelectJobTypeController.class.cast(vh.controller)).getJobType();
            vh.dialog.close();
            if (jobType == ISpace.SPACE_TYPE_SYNC) {
                BinferDesktopApplication.getInstance().showViewInDialog("/com/binfer/desktop/sync/syncjobnew.fxml", null, "Add New Sync Job", "", false, (e1, o1) -> {});
            } else if (jobType == ISpace.SPACE_TYPE_TRANSFER) {
                BinferDesktopApplication.getInstance().showViewInDialog("/com/binfer/desktop/transfer/transferjobnew.fxml", null, "Add New Transfer Job", "", false, (e2, o2) -> {});
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @FXML
    private void handleRefreshClicked(ActionEvent event) {
        this.refresh();
    }

    private void refresh() {
        this.jobsList.clear();
        List spaces = BinferDesktopService.getInstance().getCoreService().getSpaceService().getSpaces(this.spaceTypes);
        for (Space space : spaces) {
            try {
                Parent jobNode = BinferDesktopApplication.createView((String)"/com/binfer/desktop/jobs/jobsummary.fxml", (Object)space).node;
                this.jobsList.add((Object)jobNode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void handleExitClicked(ActionEvent event) {
        BinferApplication.getInstance().logout(true);
    }

    @FXML
    private void handleLicenseClicked(ActionEvent event) {
        BinferDesktopApplication.getInstance().showViewInDialog("/com/binfer/desktop/license/license.fxml", "", "License", "", false, (e, o) -> {});
    }

    @FXML
    private void handleHelpClicked(ActionEvent event) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BinferDesktopApplication.getInstance().startWaitCursor();
                try {
                    BinferDesktopApplication.getInstance().openURI(new URI("https://sync.binfer.com/help/"));
                }
                catch (Exception exception) {
                }
                finally {
                    BinferDesktopApplication.getInstance().stopWaitCursor();
                }
            }
        });
    }

    @FXML
    private void handleLogsClicked(ActionEvent event) {
        BinferDesktopApplication.getInstance().showViewInDialog("/com/binfer/desktop/currenttransfers/currenttransfers.fxml", "", "Recent Transfers", "", false, (e, o) -> {});
    }

    @FXML
    private void handleSettingsClicked(ActionEvent event) {
        BinferDesktopApplication.getInstance().showViewInDialog("/com/binfer/desktop/settings/settings.fxml", "", "Settings", "", false, (e, o) -> {});
    }
}

