/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.license;

import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.IUser;
import com.binfer.desktop.BinferDesktopApplication;
import com.binfer.desktop.BinferDesktopService;
import java.net.URI;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.web.WebView;

public class LicenseController
implements Initializable {
    @FXML
    private Button refreshButton;
    @FXML
    private Button purchaseButton;
    @FXML
    private TextField promoCodeTextField;
    @FXML
    private WebView webView;

    public void initialize(URL url, ResourceBundle rb) {
        this.refresh();
    }

    void refresh() {
        try {
            BinferDesktopApplication.getInstance().startWaitCursor();
            this.webView.getEngine().loadContent(BinferDesktopService.getInstance().getCoreService().getLicenseService().getLicenseDisplayHTML());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            BinferDesktopApplication.getInstance().stopWaitCursor();
        }
    }

    @FXML
    private void handleRefreshButtonClicked(ActionEvent event) {
        this.refresh();
    }

    @FXML
    private void handlePurchaseButtonClicked(ActionEvent event) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BinferDesktopApplication.getInstance().startWaitCursor();
                try {
                    BinferDesktopApplication.getInstance().openURI(new URI("https://sync.binfer.com/pricing/?accountId=" + BinferProperties.getProperty(IUser.ACCOUNTID) + "&userId=" + BinferDesktopService.getInstance().getCoreService().getUserService().getSelfID()));
                }
                catch (Exception exception) {
                }
                finally {
                    BinferDesktopApplication.getInstance().stopWaitCursor();
                }
            }
        });
    }

    @FXML
    private void handlePromoApplyClicked(ActionEvent event) {
        try {
            boolean applied = BinferDesktopService.getInstance().getCoreService().getUserService().applyPromoCode(this.promoCodeTextField.getText());
            if (!applied) {
                throw new Exception("Failed to apply promo code");
            }
            BinferDesktopApplication.getInstance().showPopup("Promo code applied");
        }
        catch (Exception e) {
            BinferDesktopApplication.getInstance().showError(e.getMessage());
        }
    }
}

