/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.report;

import com.binfer.base.service.IFile;
import com.binfer.base.service.ISpace;
import com.binfer.base.service.IUser;
import com.binfer.base.util.IPagedResult;
import com.binfer.base.util.Space;
import com.binfer.base.util.TimeUtil;
import com.binfer.desktop.BinferDesktopApplication;
import com.binfer.desktop.BinferDesktopService;
import com.binfer.desktop.report.ReportModel;
import com.binfer.desktop.shared.ui.IView;
import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class ReportController
implements Initializable,
IView {
    private IPagedResult pr;
    private Space job;
    private ObservableList<ReportModel> data = FXCollections.observableArrayList();
    private AtomicBoolean isRefreshing = new AtomicBoolean(false);
    @FXML
    private TableColumn<ReportModel, String> contactColumn;
    @FXML
    private TableColumn<ReportModel, String> fileColumn;
    @FXML
    private TableColumn<ReportModel, String> dateColumn;
    @FXML
    private ComboBox<String> typeCombo;
    @FXML
    private TableView<ReportModel> tableView;

    public void initialize(URL url, ResourceBundle rb) {
        this.contactColumn.prefWidthProperty().bind((ObservableValue)this.tableView.widthProperty().multiply(0.2));
        this.fileColumn.prefWidthProperty().bind((ObservableValue)this.tableView.widthProperty().multiply(0.6));
        this.dateColumn.prefWidthProperty().bind((ObservableValue)this.tableView.widthProperty().multiply(0.2));
        this.contactColumn.setCellValueFactory((Callback)new PropertyValueFactory("device"));
        this.fileColumn.setCellValueFactory((Callback)new PropertyValueFactory("file"));
        this.dateColumn.setCellValueFactory((Callback)new PropertyValueFactory("date"));
        this.typeCombo.setItems(FXCollections.observableArrayList((Object[])new String[]{"Sent", "Received", "Pending send", "Pending receive"}));
        this.typeCombo.setValue((Object)"Sent");
        this.tableView.setItems(this.data);
    }

    @Override
    public void onCreate(Object data) {
        this.job = (Space)Space.class.cast(data);
        this.tableView.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    try {
                        ReportModel rowData = (ReportModel)row.getItem();
                        Map file = BinferDesktopService.getInstance().getCoreService().getFilesService().getFile(this.job.getSpaceID(), rowData.getItem().get(IFile.FILEID));
                        BinferDesktopApplication.getInstance().openURI(new File((String)file.get(IFile.URI)).toURI());
                    }
                    catch (Exception e) {
                        BinferDesktopApplication.getInstance().showWarning("Failed to open file because " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
            return row;
        });
    }

    @Override
    public void refresh(Object data) {
        this.job = (Space)Space.class.cast(data);
        this.refresh();
    }

    public void refresh() {
        if (this.isRefreshing.get()) {
            return;
        }
        this.isRefreshing.set(true);
        BinferDesktopApplication.getInstance().startWaitCursor();
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                try {
                    ReportController.this.setPagedResult();
                    List items = ReportController.this.pr.next();
                    ReportController.this.updateFiles(items);
                    Platform.runLater(() -> {
                        try {
                            ReportController.this.updateTable(items);
                        }
                        catch (Exception e) {
                            BinferDesktopApplication.getInstance().showPopup(e.getMessage());
                        }
                    });
                }
                catch (Throwable throwable) {
                }
                finally {
                    ReportController.this.isRefreshing.set(false);
                    BinferDesktopApplication.getInstance().stopWaitCursor();
                }
                return null;
            }
        };
        Thread th = new Thread((Runnable)task);
        th.start();
    }

    private void updateTable(List<Map<String, String>> items) {
        this.data.clear();
        for (Map<String, String> item : items) {
            this.data.add((Object)new ReportModel(item));
        }
        Platform.runLater(() -> this.tableView.requestLayout());
    }

    private void setPagedResult() throws Exception {
        switch ((String)this.typeCombo.getValue()) {
            case "Received": {
                this.pr = BinferDesktopService.getInstance().getCoreService().getFilesService().getXferLogs(this.job.getSpaceID(), "%", "%", null, null, IFile.FILE_STATUS_RECEIVED, IUser.CREATED, false, 100);
                break;
            }
            case "Sent": {
                this.pr = BinferDesktopService.getInstance().getCoreService().getFilesService().getXferLogs(this.job.getSpaceID(), "%", "%", null, null, IFile.FILE_STATUS_SENT, IUser.CREATED, false, 100);
                break;
            }
            case "Pending send": {
                this.pr = BinferDesktopService.getInstance().getCoreService().getFilesService().getFilesByStatus(null, true, this.job.getSpaceID(), IFile.FILE_STATUS_PENDING_SEND, 100L);
                break;
            }
            default: {
                this.pr = BinferDesktopService.getInstance().getCoreService().getFilesService().getFilesByStatus(null, true, this.job.getSpaceID(), IFile.FILE_STATUS_PENDING_RECEIVE, 100L);
            }
        }
    }

    private void updateFiles(List<Map<String, String>> items) {
        for (Map<String, String> item : items) {
            if (((String)this.typeCombo.getValue()).contains("Pending")) {
                item.putAll(BinferDesktopService.getInstance().getCoreService().getFilesService().getFile(item.get(ISpace.SPACEID), item.get(IFile.FILEID)));
            }
            if (item.containsKey(IFile.STATUS)) {
                if (item.get(IFile.STATUS).equalsIgnoreCase("" + IFile.FILE_STATUS_PENDING_SEND) || item.get(IFile.STATUS).equalsIgnoreCase("" + IFile.FILE_STATUS_SENT)) {
                    item.put(ISpace.OWNER, item.get(IUser.TOUSERID));
                } else {
                    item.put(ISpace.OWNER, item.get(IUser.FROMUSERID));
                }
            } else {
                item.put(ISpace.OWNER, this.job.getOwner());
            }
            item.put(IFile.CREATED, TimeUtil.getDayMonthYearTime(new Date(Long.parseLong(item.get(IUser.CREATED)))));
            item.put(ISpace.SUBJECT, this.job.getSubject());
        }
    }

    @Override
    public void onDestroy(Object data) {
    }

    @FXML
    private void handleRefreshClicked(ActionEvent event) {
        this.refresh();
    }

    private void handlePrevButtonClicked(MouseEvent event) {
        try {
            this.updateTable(this.pr.previous());
        }
        catch (Exception e) {
            BinferDesktopApplication.getInstance().showPopup(e.getMessage());
        }
    }

    private void handleNextButtonClicked(MouseEvent event) {
        try {
            this.updateTable(this.pr.next());
        }
        catch (Exception e) {
            BinferDesktopApplication.getInstance().showPopup(e.getMessage());
        }
    }

    @FXML
    private void handleValueChanged(ActionEvent event) {
        this.refresh();
    }
}

