/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.settings;

import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.DownloadService;
import com.binfer.base.service.IMessage;
import com.binfer.base.service.IUser;
import com.binfer.base.xml.XMLUtil;
import com.binfer.desktop.BinferDesktopApplication;
import com.binfer.desktop.BinferDesktopService;
import com.binfer.desktop.devices.DeviceCheckBoxListCell;
import com.binfer.desktop.devices.DeviceItem;
import com.binfer.desktop.shared.BinferApplication;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import javafx.util.Callback;

public class SettingsController
implements Initializable {
    private final DirectoryChooser directoryChooser = new DirectoryChooser();
    private File folderselected;
    private ObservableList<DeviceItem> itemList = FXCollections.observableArrayList();
    private List<DeviceItem> selectedItems;
    @FXML
    private TextField downloadPathTextField;
    @FXML
    private TextField syncFreqTextField;
    @FXML
    private ListView<DeviceItem> listView;
    private TextField emailTextField;
    private PasswordField passwordTextField;
    @FXML
    private TextField accountIdResultTextField;
    @FXML
    private TextField deviceIdTextField;

    public void initialize(URL url, ResourceBundle rb) {
        this.listView.setItems(this.itemList);
        this.listView.setCellFactory((Callback)new Callback<ListView<DeviceItem>, ListCell<DeviceItem>>(){

            public ListCell<DeviceItem> call(ListView<DeviceItem> param) {
                return new DeviceCheckBoxListCell();
            }
        });
        this.refreshDevices();
        try {
            this.downloadPathTextField.setText(DownloadService.getDataDir().getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.syncFreqTextField.setText(Integer.toString(BinferDesktopService.getInstance().getCoreService().getSyncService().getPollTime()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.accountIdResultTextField.setText(BinferDesktopService.getInstance().getCoreService().getNetworkService().getSelfDeviceID());
        this.setAccountTab();
    }

    private void setAccountTab() {
        try {
            this.accountIdResultTextField.setEditable(false);
            this.deviceIdTextField.setEditable(false);
            this.accountIdResultTextField.setText(BinferProperties.getProperty(IUser.ACCOUNTID));
            this.deviceIdTextField.setText(BinferProperties.getProperty(IUser.DEVICEID));
        }
        catch (Exception e) {
            BinferDesktopApplication.getInstance().showWarning("Failed to copy because " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void refreshDevices() {
        this.itemList.clear();
        try {
            List members = BinferDesktopService.getInstance().getCoreService().getContactsService().getDevices(true);
            for (Map member : members) {
                this.itemList.add((Object)new DeviceItem(member));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @FXML
    private void handleFolderClicked(ActionEvent event) {
        this.folderselected = this.directoryChooser.showDialog((Window)BinferApplication.getInstance().getStage());
        this.downloadPathTextField.setText(this.folderselected.getAbsolutePath());
    }

    @FXML
    private void handleAddDeviceClicked(ActionEvent event) {
        String deviceId = BinferDesktopApplication.getInstance().showInputDialog("Add device", "Enter the device id to be added");
        BinferDesktopService.getInstance().getCoreService().getContactsService().linkContact(deviceId, deviceId, true);
        this.refreshDevices();
    }

    @FXML
    private void handleRemoveDeviceClicked(ActionEvent event) {
        boolean response = BinferDesktopApplication.getInstance().showYesNoDialog("Do you want to remove the selected devices?");
        if (response) {
            this.selectedItems = this.itemList.stream().filter(DeviceItem::isSelected).collect(Collectors.toList());
            for (DeviceItem deviceItem : this.selectedItems) {
                Map<String, String> contact = deviceItem.member;
                try {
                    try {
                        StringBuilder sb = new StringBuilder();
                        sb.append(XMLUtil.xmlTag(IUser.USERID, BinferDesktopService.getInstance().getCoreService().getUserService().getSelfID()));
                        sb.append(XMLUtil.xmlTag(IUser.DEVICEID, BinferDesktopService.getInstance().getCoreService().getNetworkService().getSelfDeviceID()));
                        BinferDesktopService.getInstance().getCoreService().getMessageService().sendMessage(contact.get(IUser.USERID), contact.get(IUser.DEVICEID), IMessage.MSG_REMOVECONTACT, sb.toString());
                    }
                    catch (Exception sb) {
                        // empty catch block
                    }
                    BinferDesktopService.getInstance().getCoreService().getContactsService().deleteContact(contact.get(IUser.USERID), contact.get(IUser.DEVICEID));
                    BinferDesktopService.getInstance().getCoreService().getContactsService().linkContact(contact.get(IUser.USERID), contact.get(IUser.DEVICEID), false);
                }
                catch (Exception e1) {
                    e1.toString();
                }
            }
            for (DeviceItem member : this.selectedItems) {
                this.itemList.remove((Object)member);
            }
        }
    }

    @FXML
    private void handleSaveClicked(ActionEvent event) {
        try {
            DownloadService.setDataDirectory(this.downloadPathTextField.getText());
        }
        catch (Exception e) {
            BinferDesktopApplication.getInstance().showError("Failed to save location because " + e.getMessage());
        }
        try {
            BinferDesktopService.getInstance().getCoreService().getSyncService().setPollTime(Integer.parseInt(this.syncFreqTextField.getText()));
        }
        catch (Exception e) {
            BinferDesktopApplication.getInstance().showError("Failed to save sync frequency because " + e.getMessage());
        }
    }

    @FXML
    private void handleDefaultsClicked(ActionEvent event) {
        try {
            String userHomePath;
            try {
                userHomePath = new File(System.getProperty("user.home")).getAbsolutePath();
            }
            catch (Exception e) {
                userHomePath = new File("").getAbsolutePath();
            }
            File dataDir = new File(userHomePath, "Desktop/BinferSync");
            this.downloadPathTextField.setText(dataDir.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.syncFreqTextField.setText(Integer.toString(10));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.handleSaveClicked(event);
    }

    @FXML
    private void handleCopyDeviceIdClicked(ActionEvent event) {
        BinferDesktopApplication.getInstance().copyToClipboard(BinferDesktopService.getInstance().getCoreService().getNetworkService().getSelfDeviceID());
    }
}

