/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.sync;

import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.ISpace;
import com.binfer.base.service.IUser;
import com.binfer.base.service.LogService;
import com.binfer.base.service.SpaceService;
import com.binfer.base.util.Space;
import com.binfer.desktop.BinferDesktopApplication;
import com.binfer.desktop.BinferDesktopService;
import com.binfer.desktop.devices.DevicesController;
import com.binfer.desktop.sync.SyncJobNewDetailsController;
import com.binfer.desktop.sync.SyncJobOptionsController;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;

public class SyncJobNewController
implements Initializable {
    private Space job;
    @FXML
    SyncJobNewDetailsController detailsTabController;
    @FXML
    SyncJobOptionsController optionsTabController;
    @FXML
    DevicesController membersTabController;

    public void initialize(URL url, ResourceBundle rb) {
        this.job = new Space(new HashMap());
        this.job.setOptions(new HashMap<String, String>());
        this.job.getOptions().put(ISpace.SPACE_OPTION_ENABLED, Boolean.TRUE.toString());
        this.detailsTabController.onCreate(this.job);
        this.optionsTabController.onCreate(this.job);
    }

    @FXML
    private void handleSaveClicked(ActionEvent event) {
        try {
            this.detailsTabController.update();
            this.optionsTabController.update();
            this.job.setMembers(this.membersTabController.getSelectedAsMap());
            this.validate();
            this.save(event);
        }
        catch (Exception e) {
            BinferDesktopApplication.getInstance().showError(e.getMessage());
        }
    }

    private void validate() throws Exception {
        String subject = this.job.getSubject().trim();
        if (subject.isEmpty()) {
            throw new Exception("Invalid subject.");
        }
        if (!SpaceService.isValidSubjectName(subject)) {
            throw new Exception("Invalid subject.");
        }
        String folder = this.job.getOptions().get(ISpace.SPACE_OPTION_SYNC_SOURCEFOLDER);
        if (folder == null || folder.isEmpty() || !new File(folder).exists() || !new File(folder).canWrite()) {
            throw new Exception("A valid folder must be selected.");
        }
        if (this.job.getMembers().isEmpty()) {
            throw new Exception("At least one device must be selected.");
        }
    }

    private void save(ActionEvent event) throws Exception {
        this.job.getOptions().put(ISpace.SPACE_OPTION_SYNC_FILEAGE, Integer.toString(1));
        try {
            BinferDesktopService.getInstance().getCoreService().getSyncService().addRule(BinferProperties.getProperty(IUser.USERID), this.job.getSubject(), this.job.getMembers(), this.job.getOptions());
            Button button = (Button)Button.class.cast(event.getSource());
            LogService.log("save button parent: " + button.getParent().getParent().getParent(), Level.SEVERE);
            BorderPane borderpane = (BorderPane)BorderPane.class.cast(button.getParent().getParent().getParent());
            borderpane.setTop(null);
            borderpane.setCenter(null);
            borderpane.setCenter((Node)new Label("Job added. Close this view to continue."));
        }
        catch (Exception e) {
            BinferDesktopApplication.getInstance().showError("Failed to add job because " + e.getMessage());
            e.printStackTrace();
        }
    }
}

