/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.sync;

import com.binfer.base.service.ISpace;
import com.binfer.base.util.Space;
import com.binfer.desktop.shared.ui.IView;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;

public class SyncJobOptionsController
implements Initializable,
IView {
    private Space job;
    @FXML
    public CheckBox optionTwoWaySyncCheckBox;
    @FXML
    private CheckBox optionManualCheckbox;
    @FXML
    private CheckBox optionSyncDeletionsCheckBox;
    @FXML
    private CheckBox optionEnabledCheckbox;
    @FXML
    private TextField timeTextField;
    @FXML
    private CheckBox optionDeleteAfterSendCheckBox;
    @FXML
    private CheckBox optionPreserveTimestampCheckBox;

    public void initialize(URL url, ResourceBundle rb) {
    }

    @Override
    public void onCreate(Object data) {
        this.refresh(data);
    }

    @Override
    public void refresh(Object data) {
        this.job = (Space)Space.class.cast(data);
        try {
            this.optionEnabledCheckbox.setSelected(Boolean.parseBoolean(this.job.getOptions().get(ISpace.SPACE_OPTION_ENABLED)));
        }
        catch (Exception e) {
            this.optionEnabledCheckbox.setSelected(true);
        }
        try {
            this.optionTwoWaySyncCheckBox.setSelected(Boolean.parseBoolean(this.job.getOptions().get(ISpace.SPACE_OPTION_SYNC_SYNCTWOWAY)));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.optionManualCheckbox.setSelected(Boolean.parseBoolean(this.job.getOptions().get(ISpace.SPACE_OPTION_SYNC_MANUAL)));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.optionSyncDeletionsCheckBox.setSelected(Boolean.parseBoolean(this.job.getOptions().get(ISpace.SPACE_OPTION_SYNC_SYNCDELETES)));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.optionPreserveTimestampCheckBox.setSelected(Boolean.parseBoolean(this.job.getOptions().get(ISpace.SPACE_OPTION_PRESERVE_TIMESTAMP)));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int value = Integer.parseInt(this.job.getOptions().get(ISpace.SPACE_OPTION_SYNC_DELETE_AFTER_SENT_TIME));
            this.timeTextField.setText(Integer.toString(value));
        }
        catch (Exception value) {
            // empty catch block
        }
        try {
            this.optionDeleteAfterSendCheckBox.setSelected(Boolean.parseBoolean(this.job.getOptions().get(ISpace.SPACE_OPTION_SYNC_DELETE_AFTER_SENT)));
            this.timeTextField.setEditable(Boolean.parseBoolean(this.job.getOptions().get(ISpace.SPACE_OPTION_SYNC_DELETE_AFTER_SENT)));
        }
        catch (Exception e) {
            this.timeTextField.setEditable(false);
        }
    }

    public void update() {
        try {
            this.job.getOptions().put(ISpace.SPACE_OPTION_ENABLED, Boolean.toString(this.optionEnabledCheckbox.isSelected()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.job.getOptions().put(ISpace.SPACE_OPTION_SYNC_MANUAL, Boolean.toString(this.optionManualCheckbox.isSelected()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.job.getOptions().put(ISpace.SPACE_OPTION_SYNC_DELETE_AFTER_SENT, Boolean.toString(this.optionDeleteAfterSendCheckBox.isSelected()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String timeTextVal = this.timeTextField.getText();
        if (timeTextVal != null && !timeTextVal.isEmpty()) {
            int selValue = Integer.parseInt(timeTextVal);
            if (selValue > 0) {
                this.job.getOptions().put(ISpace.SPACE_OPTION_SYNC_DELETE_AFTER_SENT_TIME, Integer.toString(selValue));
                this.job.getOptions().put(ISpace.SPACE_OPTION_SYNC_DELETE_AFTER_SENT_TIME_UNIT, ISpace.SPACE_OPTION_SYNC_DELETE_AFTER_SENT_TIME_UNIT_DEFAULT.name());
            }
        } else {
            this.job.getOptions().remove(ISpace.SPACE_OPTION_SYNC_DELETE_AFTER_SENT_TIME);
            this.job.getOptions().remove(ISpace.SPACE_OPTION_SYNC_DELETE_AFTER_SENT_TIME_UNIT);
        }
        try {
            this.job.getOptions().put(ISpace.SPACE_OPTION_PRESERVE_TIMESTAMP, Boolean.toString(this.optionPreserveTimestampCheckBox.isSelected()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.job.getOptions().put(ISpace.SPACE_OPTION_SYNC_SYNCDELETES, Boolean.toString(this.optionSyncDeletionsCheckBox.isSelected()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.job.getOptions().put(ISpace.SPACE_OPTION_SYNC_SYNCTWOWAY, Boolean.toString(this.optionTwoWaySyncCheckBox.isSelected()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setReadOnly() {
        this.optionTwoWaySyncCheckBox.setDisable(true);
        this.optionSyncDeletionsCheckBox.setDisable(true);
        this.optionPreserveTimestampCheckBox.setDisable(true);
        this.optionDeleteAfterSendCheckBox.setDisable(true);
        this.timeTextField.setEditable(false);
    }

    @Override
    public void onDestroy(Object data) {
    }

    @FXML
    private void handleDeleteAfterSendClicked(ActionEvent event) {
        if (this.optionDeleteAfterSendCheckBox.isSelected()) {
            this.timeTextField.setEditable(true);
        } else {
            this.timeTextField.clear();
            this.timeTextField.setEditable(false);
        }
    }
}

