/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.transfer;

import com.binfer.base.service.IFile;
import com.binfer.base.util.Space;
import com.binfer.base.util.TimeUtil;
import com.binfer.desktop.shared.ui.IView;
import java.net.URL;
import java.util.Date;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextField;

public class TransferJobDetailsController
implements Initializable,
IView {
    private Space job;
    @FXML
    private TextField nameTextField;
    @FXML
    private TextField ownerTextField;
    @FXML
    private TextField createdTextField;
    @FXML
    private TextField updatedTextField;
    @FXML
    private TextField fileCountTextField;
    @FXML
    private TextField fileSentTextField;
    @FXML
    private TextField fileRecvTextField;
    @FXML
    private TextField pendingSendTextField;
    @FXML
    private TextField pendingRecvTextField;
    @FXML
    private TextField descriptionTextField;

    public void initialize(URL url, ResourceBundle rb) {
    }

    @Override
    public void onCreate(Object data) {
        this.refresh(data);
    }

    @Override
    public void refresh(Object data) {
        try {
            this.job = (Space)Space.class.cast(data);
            this.nameTextField.setText(this.job.getSubject());
            try {
                if (!this.job.getDescription().isEmpty()) {
                    this.descriptionTextField.setText(this.job.getDescription());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ownerTextField.setText(this.job.getOwner());
            this.createdTextField.setText(TimeUtil.getDayMonthYearHourMinSec(new Date(this.job.getCreated())));
            this.updatedTextField.setText(TimeUtil.getDayMonthYearHourMinSec(new Date(this.job.getModified())));
            int filesCount = 0;
            try {
                filesCount = Integer.parseInt(this.job.getOptions().get(IFile.FILESCOUNT));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.fileCountTextField.setText(Integer.toString(filesCount));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int totalSent = 0;
            try {
                totalSent = Integer.parseInt(this.job.getOptions().get(IFile.COUNTSENT));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int totalRcvd = 0;
            try {
                totalRcvd = Integer.parseInt(this.job.getOptions().get(IFile.COUNTRECEIVED));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (totalSent < 0) {
                totalSent = 0;
            }
            if (totalRcvd < 0) {
                totalRcvd = 0;
            }
            try {
                this.fileSentTextField.setText(Integer.toString(totalSent));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.fileRecvTextField.setText(Integer.toString(totalRcvd));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int pendingSend = 0;
            try {
                pendingSend = Integer.parseInt(this.job.getOptions().get(IFile.COUNTPENDINGSEND));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int pendingRecv = 0;
            try {
                pendingRecv = Integer.parseInt(this.job.getOptions().get(IFile.COUNTPENDINGRECEIVE));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pendingSend < 0) {
                pendingSend = 0;
            }
            if (pendingRecv < 0) {
                pendingRecv = 0;
            }
            try {
                this.pendingSendTextField.setText(Integer.toString(pendingSend));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.pendingRecvTextField.setText(Integer.toString(pendingRecv));
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update() {
    }

    public void setReadOnly() {
        this.nameTextField.setEditable(false);
        this.descriptionTextField.setEditable(false);
        this.ownerTextField.setEditable(false);
        this.createdTextField.setEditable(false);
        this.updatedTextField.setEditable(false);
        this.fileCountTextField.setEditable(false);
        this.fileRecvTextField.setEditable(false);
        this.fileSentTextField.setEditable(false);
        this.pendingRecvTextField.setEditable(false);
        this.pendingSendTextField.setEditable(false);
    }

    @Override
    public void onDestroy(Object data) {
    }
}

