/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.transfer;

import com.binfer.base.service.ISpace;
import com.binfer.base.util.Space;
import com.binfer.desktop.BinferDesktopApplication;
import com.binfer.desktop.BinferDesktopService;
import com.binfer.desktop.files.FilesController;
import com.binfer.desktop.jobmembers.JobMembersController;
import com.binfer.desktop.report.ReportController;
import com.binfer.desktop.shared.ui.IView;
import com.binfer.desktop.transfer.TransferJobDetailsController;
import com.binfer.desktop.transfer.TransferJobOptionsController;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;

public class TransferJobEditController
implements Initializable,
IView {
    private Space job;
    @FXML
    TransferJobDetailsController detailsTabController;
    @FXML
    FilesController filesTabController;
    @FXML
    TransferJobOptionsController optionsTabController;
    @FXML
    JobMembersController membersTabController;
    @FXML
    ReportController reportTabController;

    public void initialize(URL url, ResourceBundle rb) {
    }

    @Override
    public void onCreate(Object data) {
        this.refresh(data);
    }

    @Override
    public void refresh(Object data) {
        try {
            this.job = (Space)Space.class.cast(data);
            this.job.setFiles(BinferDesktopService.getInstance().getCoreService().getFilesService().getFiles(this.job.getSpaceID(), null, true));
            this.detailsTabController.onCreate(this.job);
            this.detailsTabController.setReadOnly();
            this.optionsTabController.onCreate(this.job);
            this.optionsTabController.setReadOnly();
            this.membersTabController.onCreate(this.job);
            this.membersTabController.setReadOnly();
            this.reportTabController.onCreate(this.job);
            this.filesTabController.addFiles(this.job.getFiles1());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDestroy(Object data) {
    }

    @FXML
    private void handleExecuteClicked(ActionEvent event) {
        try {
            BinferDesktopService.getInstance().getCoreService().getUserService().pushUpdates();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            BinferDesktopApplication.getInstance().showPopup("Scheduled for synchronization");
        }
    }

    @FXML
    private void handleRefreshedClicked(ActionEvent event) {
        try {
            this.job = BinferDesktopService.getInstance().getCoreService().getSpaceService().getSpace(this.job.getSpaceID(), false);
            this.refresh(this.job);
        }
        catch (Exception e) {
            BinferDesktopApplication.getInstance().showWarning("Failed to refresh because " + e.getMessage());
        }
    }

    @FXML
    private void handleDeleteClicked(ActionEvent event) {
        boolean result = BinferDesktopApplication.getInstance().showYesNoDialog("Are you sure that you want to delete this job?");
        if (result) {
            try {
                BinferDesktopService.getInstance().getCoreService().getSpaceService().deleteSpace(this.job.getSpaceID(), true);
                Button button = (Button)Button.class.cast(event.getSource());
                BorderPane borderpane = (BorderPane)BorderPane.class.cast(button.getParent().getParent().getParent());
                borderpane.setTop(null);
                borderpane.setCenter(null);
                borderpane.setCenter((Node)new Label("Job deleted. Close this view to continue."));
            }
            catch (Exception e) {
                BinferDesktopApplication.getInstance().showError("Failed to delete job because " + e.getMessage());
            }
        }
    }

    @FXML
    private void handleSaveClicked(ActionEvent event) {
        if (!BinferDesktopService.getInstance().getCoreService().getUserService().getSelfID().equalsIgnoreCase(this.job.getOwner())) {
            BinferDesktopApplication.getInstance().showError("Not owner");
            return;
        }
        try {
            this.optionsTabController.update();
            for (String option : this.job.getOptions().keySet()) {
                try {
                    BinferDesktopService.getInstance().getCoreService().getSpaceService().updateSpaceOption(this.job.getSpaceID(), option, this.job.getOptions().get(option));
                }
                catch (Exception exception) {}
            }
            BinferDesktopApplication.getInstance().showPopup("Updated");
        }
        catch (Exception e) {
            BinferDesktopApplication.getInstance().showError("Failed to save because " + e.getMessage());
        }
    }

    @FXML
    private void handleClearClicked(ActionEvent event) {
        boolean result = BinferDesktopApplication.getInstance().showYesNoDialog("Are you sure that you want to clear this job?");
        if (result) {
            try {
                BinferDesktopService.getInstance().getCoreService().getSpaceService().clearSpace(this.job.getSpaceID());
                BinferDesktopApplication.getInstance().showPopup("Cleared");
            }
            catch (Exception e) {
                BinferDesktopApplication.getInstance().showError("Failed to clear because " + e.getMessage());
            }
        }
    }

    @FXML
    private void handleFolderClicked(ActionEvent event) {
        BinferDesktopApplication.getInstance().openURI(new File(this.job.getOptions().get(ISpace.SPACE_OPTION_SYNC_SOURCEFOLDER)).toURI());
    }
}

