/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.transfer;

import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.FileService;
import com.binfer.base.service.ISpace;
import com.binfer.base.service.IUser;
import com.binfer.base.service.SpaceService;
import com.binfer.base.util.Space;
import com.binfer.desktop.BinferDesktopApplication;
import com.binfer.desktop.BinferDesktopService;
import com.binfer.desktop.devices.DevicesController;
import com.binfer.desktop.files.EditFilesController;
import com.binfer.desktop.transfer.TransferJobNewDetailsController;
import com.binfer.desktop.transfer.TransferJobOptionsController;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;

public class TransferJobNewController
implements Initializable {
    private Space job;
    @FXML
    TransferJobNewDetailsController detailsTabController;
    @FXML
    TransferJobOptionsController optionsTabController;
    @FXML
    EditFilesController filesTabController;
    @FXML
    DevicesController membersTabController;

    public void initialize(URL url, ResourceBundle rb) {
        this.job = new Space(new HashMap());
        this.job.setOptions(new HashMap<String, String>());
        this.job.getOptions().put(ISpace.SPACE_OPTION_ENABLED, Boolean.TRUE.toString());
        this.detailsTabController.onCreate(this.job);
        this.optionsTabController.onCreate(this.job);
    }

    @FXML
    private void handleSaveClicked(ActionEvent event) {
        try {
            this.detailsTabController.update();
            this.optionsTabController.update();
            this.job.setMembers(this.membersTabController.getSelectedAsMap());
            this.job.setFiles(FileService.getFilesInfo(BinferDesktopService.getInstance().getCoreService().getUserService().getSelfID(), this.filesTabController.getFiles()));
            this.validate();
            this.save(event);
        }
        catch (Exception e) {
            BinferDesktopApplication.getInstance().showError(e.getMessage());
        }
    }

    private void validate() throws Exception {
        String subject = this.job.getSubject().trim();
        if (subject.isEmpty()) {
            throw new Exception("Invalid subject.");
        }
        if (!SpaceService.isValidSubjectName(subject)) {
            throw new Exception("Invalid subject.");
        }
        if (this.job.getMembers().isEmpty()) {
            throw new Exception("At least one device must be selected.");
        }
        if (this.job.getFileCount() == 0) {
            throw new Exception("At least one file must be added.");
        }
    }

    private void save(ActionEvent event) throws Exception {
        try {
            String parentspaceid = null;
            String spaceid = UUID.randomUUID().toString();
            String owner = BinferProperties.getProperty(IUser.USERID);
            String subject = this.job.getSubject();
            String description = this.job.getDescription();
            Collection<Map<String, String>> members = this.job.getMembers();
            List<Map<String, String>> files = this.job.getFiles1();
            Map<String, String> options = this.job.getOptions();
            byte type = ISpace.SPACE_TYPE_TRANSFER;
            long timestamp = System.currentTimeMillis();
            boolean sendEmailNotification = false;
            boolean sendMesgInEmail = false;
            BinferDesktopService.getInstance().getCoreService().getSpaceService().addSpace(parentspaceid, spaceid, owner, subject, description, members, files, options, type, timestamp, sendEmailNotification, sendMesgInEmail);
            BinferDesktopService.getInstance().getCoreService().getUserService().pushUpdates();
            Button button = (Button)Button.class.cast(event.getSource());
            BorderPane borderpane = (BorderPane)BorderPane.class.cast(button.getParent().getParent().getParent());
            borderpane.setTop(null);
            borderpane.setCenter(null);
            borderpane.setCenter((Node)new Label("Job added. Close this view to continue."));
        }
        catch (Exception e) {
            BinferDesktopApplication.getInstance().showError("Failed to add job because " + e.getMessage());
            e.printStackTrace();
        }
    }
}

