/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.transfer;

import com.binfer.base.service.ISpace;
import com.binfer.base.util.Space;
import com.binfer.desktop.shared.ui.IView;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;

public class TransferJobOptionsController
implements Initializable,
IView {
    private Space job;
    @FXML
    private CheckBox optionEnabledCheckbox;
    @FXML
    private CheckBox optionPreserveTimestampCheckBox;

    public void initialize(URL url, ResourceBundle rb) {
    }

    @Override
    public void onCreate(Object data) {
        this.job = (Space)Space.class.cast(data);
        try {
            this.optionEnabledCheckbox.setSelected(Boolean.parseBoolean(this.job.getOptions().get(ISpace.SPACE_OPTION_ENABLED)));
        }
        catch (Exception e) {
            this.optionEnabledCheckbox.setSelected(true);
        }
        try {
            this.optionPreserveTimestampCheckBox.setSelected(Boolean.parseBoolean(this.job.getOptions().get(ISpace.SPACE_OPTION_PRESERVE_TIMESTAMP)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onDestroy(Object data) {
    }

    @Override
    public void refresh(Object data) {
    }

    public void update() {
        try {
            this.job.getOptions().put(ISpace.SPACE_OPTION_ENABLED, Boolean.toString(this.optionEnabledCheckbox.isSelected()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.job.getOptions().put(ISpace.SPACE_OPTION_PRESERVE_TIMESTAMP, Boolean.toString(this.optionPreserveTimestampCheckBox.isSelected()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.job.getOptions().put(ISpace.SPACE_OPTION_SYNC_FILEAGE, Integer.toString(1));
        this.job.getOptions().put(ISpace.SPACE_OPTION_CHANNEL, Integer.toString(1));
    }

    public void setReadOnly() {
        this.optionPreserveTimestampCheckBox.setDisable(true);
    }
}

