/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.base.service;

import com.binfer.base.impl.g;
import com.binfer.base.service.ICallback;
import com.binfer.base.service.IFile;
import com.binfer.base.service.LogService;
import com.binfer.base.util.FileNotReadableException;
import com.binfer.base.util.FolderInfo;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class FileService {
    public static Map<String, File> getFiles(Collection<File> collection) {
        return g.a(collection);
    }

    public static List<Map<String, String>> getFilesInfo(String string, Collection<File> collection) {
        return g.a(string, collection);
    }

    public static Map<String, String> getFileInfo(String string, File file) throws FileNotReadableException {
        return g.b(string, "", file);
    }

    public static String getFILEID(File file, String string) {
        return g.a(file, string);
    }

    public static void walkFolderTree(File file, ICallback<File, FolderInfo> iCallback, Comparator comparator) {
        g.a(file, iCallback, comparator);
    }

    public static void walkFileTree(String string, File file, boolean bl, ICallback<String, File> iCallback, Comparator comparator) {
        g.a(string, file, bl, iCallback, comparator);
    }

    public static void walkFileTree(File file, ICallback<String, File> iCallback) throws Exception {
        g.a(file, iCallback);
    }

    public static String relativePath(File file, File file2) {
        return g.a(file, file2);
    }

    public static long calculateTotalFileSize(List<Map<String, String>> list) {
        return g.a(list);
    }

    public static void getRelativeFilePathsRecursive(String string, File file, Map<String, File> map) {
        g.a(string, file, map);
    }

    public static void deleteRecursive(String string) {
        g.a(string);
    }

    public static Comparator<File> getComparatorFilesThenFolderNameAsc() {
        return g.a;
    }

    public static Map<String, String> getFileInfoDigest(String string, String string2, File file) throws Exception {
        return g.a(string, string2, file);
    }

    public static boolean deleteFile(File file) {
        return g.d(file);
    }

    public static String getFileAsBase64String(File file) throws Exception {
        return g.e(file);
    }

    public static void copyFile(File file, File file2) throws Exception {
        g.b(file, file2);
    }

    public static void copyFiles(File file, File file2) {
        g.c(file, file2);
    }

    public static void joinFile(File file, File file2) throws Exception {
        g.d(file, file2);
    }

    public static void copyFilesAsZip(List<Map<String, String>> list, File file, int n2) throws Exception {
        g.a(list, file);
    }

    public static long getFileCreationTime(File file) {
        return g.c(file);
    }

    public static void setFileLastModified(File file, long l2) {
        g.a(file, l2);
    }

    public static void setFileCreationTime(File file, long l2) {
        g.b(file, l2);
    }

    public static String getChecksum(File file) throws Exception {
        return g.a(file);
    }

    public static boolean isPatternAllowed(String string) {
        boolean bl = true;
        try {
            bl = !IFile.fileIgnorePattern.matcher(string).find();
        }
        catch (Exception exception) {}
        return bl;
    }

    public static String readLastNLines(String string, File file, int n2) {
        return g.a(string, file, n2);
    }

    public static List<String> readLines(File file) throws Exception {
        return g.b(file);
    }

    public static Collection<File> normalizePaths(Collection<File> collection) throws Exception {
        return g.b(collection);
    }

    public static String separatorsToSystem(String string) {
        if (string == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            return string.replace('/', File.separatorChar);
        }
        return string.replace('\\', File.separatorChar);
    }

    public static boolean isReadable(File file) {
        boolean bl = file != null && file.isFile() && file.exists();
        if (bl) {
            try {
                new RandomAccessFile(file, "r").close();
            }
            catch (Exception exception) {
                bl = false;
                LogService.log("File is not readable: " + file.getAbsolutePath(), Level.SEVERE);
            }
        }
        return bl;
    }

    public static boolean deleteEmptyFolders(File file) {
        try {
            return g.f(file);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isEmpty(File stringArray) {
        boolean bl = true;
        if (stringArray.exists() && stringArray.isDirectory() && (stringArray = stringArray.list()) != null && stringArray.length > 0) {
            bl = false;
        }
        return bl;
    }
}

