/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.base.service;

import com.binfer.base.impl.h;
import com.binfer.base.impl.n;
import com.binfer.base.nw.socketimpl.f;
import com.binfer.base.service.AuthenticationInfo;
import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.IBinfer;
import com.binfer.base.service.IEnc;
import com.binfer.base.service.IFile;
import com.binfer.base.service.ILicense;
import com.binfer.base.service.INetwork;
import com.binfer.base.service.IOService;
import com.binfer.base.service.IPreferences;
import com.binfer.base.service.ISpace;
import com.binfer.base.service.IUser;
import com.binfer.base.service.LogService;
import com.binfer.base.util.NetworkInfo;
import com.binfer.base.util.Xfer;
import com.binfer.base.xml.XMLObject;
import com.binfer.base.xml.XMLUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;

public class NetworkService {
    private static Set<String> a = new HashSet<String>();
    private static Pattern b;

    public static void registerB6Action(String string) {
        a.add(string);
    }

    public static String get(String string, Map<String, String> map, Map<String, String> map2, int n2, INetwork.TRANSPORT tRANSPORT) throws Exception {
        if (tRANSPORT == INetwork.TRANSPORT.HUC) {
            return new h().get(string, map, map2, n2);
        }
        if (tRANSPORT == INetwork.TRANSPORT.SOCKET) {
            return new f().get(string, map, map2, n2);
        }
        throw new Exception("Transport '" + tRANSPORT.name() + "' not implemented");
    }

    @Deprecated
    public static String get(String string, Map<String, String> map, Map<String, String> map2, int n2) throws Exception {
        return NetworkService.get(string, map, map2, n2, INetwork.TRANSPORT.HUC);
    }

    public static String post(String string, Map<String, String> map, String string2, String string3, INetwork.TRANSPORT tRANSPORT) throws Exception {
        if (tRANSPORT == INetwork.TRANSPORT.HUC) {
            return new h().post(string, map, string2, string3);
        }
        if (tRANSPORT == INetwork.TRANSPORT.SOCKET) {
            return new f().post(string, map, string2, string3);
        }
        throw new Exception("Transport '" + tRANSPORT.name() + "' not implemented");
    }

    public static String post(String string, Map<String, String> map, String string2, String string3) throws Exception {
        return NetworkService.post(string, map, string2, string3, INetwork.TRANSPORT.HUC);
    }

    public static String receive(Xfer xfer, String string, Map<String, String> map) throws Exception {
        INetwork.TRANSPORT tRANSPORT = INetwork.TRANSPORT.HUC;
        if (tRANSPORT == INetwork.TRANSPORT.HUC) {
            return new h().receive(xfer, string, map);
        }
        if (tRANSPORT == INetwork.TRANSPORT.SOCKET) {
            return new f().receive(xfer, string, map);
        }
        throw new Exception("Transport '" + tRANSPORT.name() + "' not implemented");
    }

    public static String send(Xfer xfer, String string, Map<String, String> map) throws Exception {
        INetwork.TRANSPORT tRANSPORT = INetwork.TRANSPORT.HUC;
        if (tRANSPORT == INetwork.TRANSPORT.HUC) {
            return new h().send(xfer, string, map);
        }
        if (tRANSPORT == INetwork.TRANSPORT.SOCKET) {
            return new f().send(xfer, string, map);
        }
        throw new Exception("Transport '" + tRANSPORT.name() + "' not implemented");
    }

    public static boolean isHttpOpen(String string, int n2, int n3, String string2) {
        return new h().a(string, n2, n3, string2);
    }

    public static Map<String, String> decryptHeader(String string) throws Exception {
        new h();
        return h.a(string);
    }

    public static String encryptHeaders(Map<String, String> map) throws Exception {
        new h();
        return h.a(map);
    }

    public static HttpURLConnection createHttpConnection(String string, String string2, Map<String, String> map) throws Exception {
        new h();
        return h.a(string, string2, map);
    }

    public static NetworkInfo getSelfNetworkInfo() {
        new n();
        return n.a();
    }

    public static void addIS(String string, InputStream inputStream) {
        new h();
        h.a(string, inputStream);
    }

    public static void addOS(String string, OutputStream outputStream) {
        new h();
        h.a(string, outputStream);
    }

    public static void removeStream(String string) {
        new h();
        h.c(string);
    }

    public static boolean isInternetAvailable() {
        return h.a.get() <= 4;
    }

    public static boolean isInternetAvailable1() {
        new h();
        return h.a();
    }

    public static boolean isValidIPv4(String string) {
        boolean bl;
        try {
            bl = b.matcher(string).matches();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static void setIsHTTPKeepAlive(boolean bl) {
        BinferProperties.setProperty(IPreferences.HTTPKEEPALIVE, Boolean.toString(bl));
        BinferProperties.save();
    }

    public static boolean getIsHTTPKeepAlive() {
        boolean bl;
        try {
            bl = BinferProperties.getBooleanProperty(IPreferences.HTTPKEEPALIVE, false);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static void setTransport(INetwork.TRANSPORT tRANSPORT) {
        BinferProperties.setProperty(INetwork.TRANSPORT_TYPE, tRANSPORT.name());
        BinferProperties.save();
    }

    public static INetwork.TRANSPORT getTransport() {
        return INetwork.TRANSPORT.valueOf(BinferProperties.getProperty(INetwork.TRANSPORT_TYPE, INetwork.TRANSPORT_DEFAULT.name()));
    }

    public static void close() {
        new h().close();
    }

    public static void close(String string) {
        new h();
        h.b(string);
    }

    public static String getRequestHeaders(HttpURLConnection object) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : ((URLConnection)((Object)object)).getHeaderFields().entrySet()) {
            try {
                stringBuilder.append(entry.getKey()).append(":").append(entry.getValue()).append(", ");
            }
            catch (Exception exception) {}
        }
        return stringBuilder.toString();
    }

    public static String getDeviceIdFromUserId(String string, String string2) {
        return UUID.nameUUIDFromBytes((string + string2).toLowerCase().getBytes()).toString();
    }

    public static String serverAction(String object, String string, String string2, String string3) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuilder.append("<request>");
        stringBuilder.append(XMLUtil.xmlTag(IUser.FROM, (String)object));
        stringBuilder.append(XMLUtil.xmlTag(IUser.DEVICEIDFROM, string));
        stringBuilder.append(string3);
        stringBuilder.append("</request>");
        object = new HashMap<String, String>();
        object.put("a", string2);
        return NetworkService.post("https://www.binfer.com/" + NetworkService.getContext(IBinfer.INSTALL_TYPE.CLIENT, string2) + "/x/a?a=" + string2, (Map<String, String>)object, stringBuilder.toString(), UUID.nameUUIDFromBytes(IEnc.SK2.getBytes()).toString());
    }

    public static String serverAction(String string, String string2, Map<String, String> map) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuilder.append("<request>");
        stringBuilder.append(XMLUtil.mapToXML(map));
        stringBuilder.append("</request>");
        map = new HashMap<String, String>();
        map.put("a", string2);
        return NetworkService.post(string, map, stringBuilder.toString(), UUID.nameUUIDFromBytes(IEnc.SK2.getBytes()).toString());
    }

    public static String serverAction(String string, String string2, String string3) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("a", string2);
        return NetworkService.post(string, hashMap, string3, UUID.nameUUIDFromBytes(IEnc.SK2.getBytes()).toString());
    }

    public static void setDeviceId(String string) {
        BinferProperties.setProperty(IUser.DEVICEID, string);
        BinferProperties.save();
        try {
            Preferences.userRoot().node("Binfer").put(IUser.DEVICEID, string);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static String getContext(IBinfer.INSTALL_TYPE iNSTALL_TYPE, String string) {
        if (a.contains(string)) {
            return "b6";
        }
        return "b4";
    }

    public static IBinfer.INSTALL_TYPE getInstallType() {
        try {
            return IBinfer.INSTALL_TYPE.valueOf(BinferProperties.getProperty(IPreferences.INSTALLTYPE));
        }
        catch (Exception exception) {
            LogService.log("EXPN. install type is not set in properties. returning client as default", Level.SEVERE);
            return IBinfer.INSTALL_TYPE.CLIENT;
        }
    }

    public static IBinfer.CLIENT_TYPE getClientType() {
        try {
            return IBinfer.CLIENT_TYPE.valueOf(BinferProperties.getProperty(IPreferences.CLIENTTYPE));
        }
        catch (Exception exception) {
            return IBinfer.CLIENT_TYPE.CLIENT_MANAGED;
        }
    }

    public static AuthenticationInfo authenticateDevice(long l2, String string, Map<String, String> map) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(map);
        hashMap.put(IUser.USERID, string);
        hashMap.put(IUser.ACCOUNTID, Long.toString(l2));
        Object object = NetworkService.serverAction(NetworkService.getServerURL(), "l", hashMap);
        object = new XMLObject((String)object);
        if (((XMLObject)object).getNodeText("/status").equalsIgnoreCase("failed")) {
            throw new Exception("Failed to login because " + ((XMLObject)object).getNodeText("/details"));
        }
        return new AuthenticationInfo((XMLObject)object);
    }

    public static AuthenticationInfo authenticateUser(String object, String string, ILicense.PRODUCT pRODUCT) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(IUser.USERID, (String)object);
        hashMap.put(IUser.PASSWORD, string);
        hashMap.put(ILicense.PROPS.PRODUCT.name(), pRODUCT.name());
        object = NetworkService.serverAction(NetworkService.getServerURL(), "au", hashMap);
        object = new XMLObject((String)object);
        if (((XMLObject)object).getNodeText("/status").equalsIgnoreCase("failed")) {
            throw new Exception("Failed to login because " + ((XMLObject)object).getNodeText("/details"));
        }
        return new AuthenticationInfo((XMLObject)object);
    }

    @Deprecated
    public static AuthenticationInfo authenticateToBinfer(String string, String string2, String object) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("https://www.binfer.com/".concat(String.valueOf(object))).append("/x/a?a=l");
            object = new HashMap<String, String>();
            String string3 = IUser.ACCOUNTID;
            object.put(string3, BinferProperties.getProperty(string3));
            String string4 = IPreferences.INSTALLTYPE;
            object.put(string4, BinferProperties.getProperty(string4));
            object.put(IUser.USERID, string);
            String string5 = IUser.DEVICEID;
            object.put(string5, BinferProperties.getProperty(string5));
            object.put(IUser.PASSWORD, string2);
            return new AuthenticationInfo(new XMLObject(NetworkService.serverAction(stringBuilder.toString(), "l", (Map<String, String>)object)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new AuthenticationInfo(null);
        }
    }

    public static AuthenticationInfo authenticateAccessCode(long l2, String string) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(IUser.ACCOUNTID, Long.toString(l2));
        hashMap.put(IUser.ACCESSCODE, string);
        Object object = NetworkService.serverAction(NetworkService.getServerURL(), "aac", hashMap);
        object = new XMLObject((String)object);
        if (((XMLObject)object).getNodeText("/status").equalsIgnoreCase("failed")) {
            throw new Exception("Failed to login because " + ((XMLObject)object).getNodeText("/details"));
        }
        return new AuthenticationInfo((XMLObject)object);
    }

    public static String getServerURL() {
        StringBuilder stringBuilder = new StringBuilder();
        if (System.getProperty("binfer.testMode") != null || NetworkService.getInstallType() == IBinfer.INSTALL_TYPE.SERVER) {
            stringBuilder.append("http://");
            if (BinferProperties.hasProperty(INetwork.RELAYDN)) {
                stringBuilder.append(BinferProperties.getProperty(INetwork.RELAYDN));
            } else {
                stringBuilder.append("127.0.0.1");
            }
            stringBuilder.append(":");
            if (BinferProperties.hasProperty(INetwork.RELAYPORT)) {
                stringBuilder.append(BinferProperties.getProperty(INetwork.RELAYPORT));
            } else {
                stringBuilder.append(BinferProperties.getIntegerProperty(INetwork.HTTPPORT, 1212));
            }
        } else if (BinferProperties.hasProperty(INetwork.RELAYDN)) {
            if (BinferProperties.hasProperty(INetwork.RELAYPROTOCOL)) {
                stringBuilder.append(BinferProperties.getProperty(INetwork.RELAYPROTOCOL));
            } else {
                stringBuilder.append("http://");
            }
            stringBuilder.append(BinferProperties.getProperty(INetwork.RELAYDN));
            stringBuilder.append(":");
            stringBuilder.append(BinferProperties.getProperty(INetwork.RELAYPORT));
        } else {
            stringBuilder.append("https://www.binfer.com");
        }
        stringBuilder.append("/b6/x/a");
        return stringBuilder.toString();
    }

    public static String addDeviceOnServer(long l2, String string, String string2) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(IUser.ACCOUNTID, Long.toString(l2));
        hashMap.put(ISpace.OWNER, string);
        hashMap.put(IUser.DEVICENAME, string2);
        return NetworkService.serverAction(NetworkService.getServerURL(), "ad", hashMap);
    }

    public static String createVerificationCode(String string) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(IUser.USERID, string);
        return new XMLObject(NetworkService.serverAction(NetworkService.getServerURL(), "mfc", hashMap)).getNodeText("/" + IUser.MFACODE);
    }

    public static String createAccessCode(long l2, String string, String string2) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(IUser.ACCOUNTID, Long.toString(l2));
        hashMap.put(IUser.USERID, string);
        hashMap.put(IUser.PASSWORD, string2);
        return new XMLObject(NetworkService.serverAction(NetworkService.getServerURL(), "cac", hashMap)).getNodeText("/" + IUser.ACCESSCODE);
    }

    public static AuthenticationInfo createAccount(String object, String string, String object2, String charSequence, String string2, IBinfer.INSTALL_TYPE iNSTALL_TYPE, IBinfer.CLIENT_TYPE cLIENT_TYPE, ILicense.PRODUCT pRODUCT) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(IUser.EMAIL, (String)object);
        hashMap.put(IUser.USERID, (String)object);
        hashMap.put(IUser.PASSWORD, string);
        hashMap.put(IUser.FNAME, (String)object2);
        hashMap.put(IUser.LNAME, (String)charSequence);
        object2 = new HashMap<String, String>();
        object2.put(IUser.ACCOUNTNAME, string2);
        object2.put(IPreferences.INSTALLTYPE, iNSTALL_TYPE.name());
        object2.put(IPreferences.CLIENTTYPE, cLIENT_TYPE.name());
        object2.put(ILicense.PROPS.PRODUCT.name(), pRODUCT.name());
        if (BinferProperties.hasProperty(IPreferences.SETUPTYPE)) {
            String string3 = IPreferences.SETUPTYPE;
            object2.put(string3, BinferProperties.getProperty(string3));
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ((StringBuilder)charSequence).append("<request>");
        ((StringBuilder)charSequence).append(XMLUtil.xmlTag(IUser.USERID, (String)object));
        ((StringBuilder)charSequence).append(XMLUtil.xmlTag(IUser.PASSWORD, string));
        ((StringBuilder)charSequence).append("<userinfo>");
        ((StringBuilder)charSequence).append(XMLUtil.mapToXML(hashMap));
        ((StringBuilder)charSequence).append("</userinfo>");
        ((StringBuilder)charSequence).append("<accountinfo>");
        ((StringBuilder)charSequence).append(XMLUtil.mapToXML((Map<String, ? extends Object>)object2));
        ((StringBuilder)charSequence).append("</accountinfo>");
        ((StringBuilder)charSequence).append("</request>");
        object = NetworkService.serverAction(NetworkService.getServerURL(), "ca", ((StringBuilder)charSequence).toString());
        object = new XMLObject((String)object);
        if (((XMLObject)object).getNodeText("/status").equalsIgnoreCase("failed")) {
            throw new Exception(((XMLObject)object).getNodeText("/details"));
        }
        return new AuthenticationInfo((XMLObject)object);
    }

    public static File downloadPCFile(String object, File file) throws Exception {
        if (object != null) {
            object = (HttpURLConnection)new URL((String)object).openConnection();
            ((URLConnection)object).connect();
            Object object2 = ((URLConnection)object).getHeaderField(IFile.FILENAME);
            file.mkdirs();
            file = new File(file, (String)object2);
            LogService.log("downloading pc file to " + file.getAbsolutePath(), Level.SEVERE);
            object2 = new FileOutputStream(file);
            IOService.writeStreamToStream(((URLConnection)object).getInputStream(), (OutputStream)object2);
            ((FileOutputStream)object2).close();
            ((HttpURLConnection)object).disconnect();
            return file;
        }
        LogService.log("failed to download PC file from ".concat(String.valueOf(object)), Level.SEVERE);
        return null;
    }

    public static Map<String, String> getDefaultNetworkInfo() {
        return new HashMap<String, String>();
    }

    static {
        NetworkService.registerB6Action("sc");
        NetworkService.registerB6Action("ciu");
        NetworkService.registerB6Action("ci");
        NetworkService.registerB6Action("u");
        NetworkService.registerB6Action("l");
        NetworkService.registerB6Action("lo");
        NetworkService.registerB6Action("en");
        NetworkService.registerB6Action("ct");
        NetworkService.registerB6Action("gf");
        NetworkService.registerB6Action("ad");
        NetworkService.registerB6Action("rdvc");
        NetworkService.registerB6Action("cac");
        NetworkService.registerB6Action("aac");
        b = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$", 35);
    }
}

