/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.base.service;

import com.binfer.base.service.EncryptionService;
import com.binfer.base.service.IEnc;
import com.binfer.base.service.ISpace;
import com.binfer.base.util.Base64;
import com.binfer.base.util.Collections;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;

public class SpaceService {
    public static String createSpaceID(String string, byte by, String string2) {
        return UUID.nameUUIDFromBytes((string2 + string + Byte.toString(by)).getBytes()).toString();
    }

    public static Collection<Byte> getAllSpaceTypes() {
        HashSet<Byte> hashSet = new HashSet<Byte>();
        hashSet.add(ISpace.SPACE_TYPE_SENT);
        hashSet.add(ISpace.SPACE_TYPE_STREAM);
        hashSet.add(ISpace.SPACE_TYPE_SYNC);
        hashSet.add(ISpace.SPACE_TYPE_CONVERSATION);
        hashSet.add(ISpace.SPACE_TYPE_RECEIVED);
        hashSet.add(ISpace.SPACE_TYPE_SYNC);
        hashSet.add(ISpace.SPACE_TYPE_TRANSFER);
        return hashSet;
    }

    public static Collection<Byte> getOUTBinSpaceTypes() {
        HashSet<Byte> hashSet = new HashSet<Byte>();
        hashSet.add(ISpace.SPACE_TYPE_SENT);
        hashSet.add(ISpace.SPACE_TYPE_STREAM);
        hashSet.add(ISpace.SPACE_TYPE_SYNC);
        hashSet.add(ISpace.SPACE_TYPE_CONVERSATION);
        return hashSet;
    }

    public static Collection<Byte> getINBinSpaceTypes() {
        HashSet<Byte> hashSet = new HashSet<Byte>();
        hashSet.add(ISpace.SPACE_TYPE_RECEIVED);
        hashSet.add(ISpace.SPACE_TYPE_SYNC);
        hashSet.add(ISpace.SPACE_TYPE_CONVERSATION);
        hashSet.add(ISpace.SPACE_TYPE_COMMENT);
        return hashSet;
    }

    public static Collection<Byte> getPushUpdatesSpaceTypes() {
        HashSet<Byte> hashSet = new HashSet<Byte>();
        hashSet.add(ISpace.SPACE_TYPE_TRANSFER);
        hashSet.add(ISpace.SPACE_TYPE_SYNC);
        hashSet.add(ISpace.SPACE_TYPE_COMMENT);
        hashSet.add(ISpace.SPACE_TYPE_CONVERSATION);
        return hashSet;
    }

    public static Map<String, String> convertMessageUIDToMap(String string) {
        try {
            try {
                string = URLDecoder.decode(string, "UTF-8");
            }
            catch (Exception exception) {}
            return Collections.paramsToMap(EncryptionService.deCrypt(new Base64().decode(string.toCharArray()), IEnc.SK1 + IEnc.SK4 + IEnc.SK3), ",", "=");
        }
        catch (Exception exception) {
            return new HashMap<String, String>();
        }
    }

    public static String getWebAppURL(String string, Map<String, String> map) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (!string.contains("?")) {
            stringBuilder.append("?");
        }
        stringBuilder.append("&binferuid=").append(URLEncoder.encode(new String(new Base64().encode(EncryptionService.enCrypt(Collections.mapToString(map), IEnc.SK1 + IEnc.SK4 + IEnc.SK3))), "UTF-8"));
        return stringBuilder.toString();
    }

    public static boolean isValidSubjectName(String string) {
        try {
            return Pattern.compile("^[a-zA-z0-9 \\-']+$").matcher(string).matches();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }
}

