/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.base.util;

import com.binfer.base.service.IErrors;
import com.binfer.base.service.IOService;
import com.binfer.base.service.LogService;
import java.io.File;
import java.util.logging.Level;

public class ErrorDetector {
    public IErrors.CODE errorCode = IErrors.CODE.NO_ERROR;
    public Throwable errorException;
    public String errorMessage = "";

    public ErrorDetector(Throwable object) {
        this.errorException = object;
        object = this;
        try {
            Object object2 = object;
            StringBuilder stringBuilder = new StringBuilder();
            if (((ErrorDetector)object2).errorException != null) {
                if (((ErrorDetector)object2).errorException.getMessage() != null) {
                    stringBuilder.append(((ErrorDetector)object2).errorException.getMessage().toLowerCase());
                }
                if ((object2 = ((ErrorDetector)object2).errorException.getCause()) != null && ((Throwable)object2).getMessage() != null) {
                    stringBuilder.append(", ").append(((Throwable)object2).getMessage().toLowerCase());
                }
            }
            ((ErrorDetector)object).errorMessage = object2 = stringBuilder.toString();
            if (((String)object2).contains(IErrors.CODE.FAILED_TO_AUTHENTICATE.name().toLowerCase()) && (((String)object2).contains("FileNotFoundException".toLowerCase()) || ((String)object2).contains("connection refused".toLowerCase()) || ((String)object2).contains("SocketException".toLowerCase()))) {
                ((ErrorDetector)object).errorCode = IErrors.CODE.BINFER_SERVER_NOT_ACCESSIBLE;
                return;
            }
            if (((String)object2).contains(IErrors.CODE.FAILED_TO_AUTHENTICATE.name().toLowerCase()) && (((String)object2).contains("invalid") || ((String)object2).contains("failed to login"))) {
                ((ErrorDetector)object).errorCode = IErrors.CODE.FAILED_TO_AUTHENTICATE;
                return;
            }
            if (((String)object2).contains(IErrors.CODE.FAILED_TO_AUTHENTICATE.name().toLowerCase())) {
                ((ErrorDetector)object).errorCode = IErrors.CODE.UNKNOWN_AUTHENTICATION_ERROR;
                return;
            }
            if (((String)object2).contains(IErrors.CODE.FILE_CANNOT_BE_WRITTEN.name().toLowerCase())) {
                ((ErrorDetector)object).errorCode = IErrors.CODE.FILE_CANNOT_BE_WRITTEN;
                return;
            }
            ((ErrorDetector)object).errorCode = IErrors.CODE.UNKNOWN_ERROR;
            return;
        }
        catch (Exception exception) {
            ((ErrorDetector)object).errorMessage = exception.getMessage();
            return;
        }
    }

    public ErrorDetector() {
    }

    public void determineDiskIssues(File file, long l2) {
        try {
            if (!(file = file.getParentFile() == null ? file : file.getParentFile()).exists()) {
                try {
                    file.mkdirs();
                }
                catch (Exception exception) {}
                if (!file.exists()) {
                    this.errorCode = IErrors.CODE.DIRECTORY_NOT_FOUND;
                    this.errorMessage = file.getAbsolutePath();
                    return;
                }
            }
            if (!file.canWrite()) {
                this.errorCode = IErrors.CODE.NO_WRITE_PERMISSION;
                this.errorMessage = file.getAbsolutePath();
                return;
            }
            if (l2 > 0L && file.getFreeSpace() < l2) {
                this.errorCode = IErrors.CODE.NOT_ENOUGH_DISK_SPACE;
                this.errorMessage = file.getAbsolutePath() + ". Needed " + IOService.bytesToFriendlyString(l2) + ", available: " + IOService.bytesToFriendlyString(file.getFreeSpace());
            }
            return;
        }
        catch (Exception exception) {
            LogService.log(">> Check failed because " + exception.getMessage(), Level.SEVERE);
            return;
        }
    }

    public String toString() {
        return this.errorCode.name() + ", " + this.errorMessage;
    }
}

