/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.base.util;

import com.binfer.base.service.FileService;
import com.binfer.base.service.IFile;
import java.io.File;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class FolderInfo {
    public long totalcount = 0L;
    public long totalsize = 0L;
    public long lastmodified = 0L;
    public long foldercount = 0L;
    public long filecount = 0L;
    public List<File> folders = new LinkedList<File>();
    public File folder;
    public String folderuid;
    public byte status = (byte)-1;

    public FolderInfo(File fileArray, Comparator<File> comparator) {
        this.folder = fileArray;
        this.folderuid = UUID.nameUUIDFromBytes(fileArray.getAbsolutePath().getBytes()).toString();
        this.lastmodified = Math.max(this.lastmodified, fileArray.lastModified());
        fileArray = fileArray.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (File file : fileArray) {
                try {
                    if (file.isDirectory()) {
                        this.folders.add(file);
                        ++this.foldercount;
                        this.lastmodified = Math.max(this.lastmodified, file.lastModified());
                    } else {
                        if (!FileService.isPatternAllowed(file.getName())) continue;
                        this.totalsize += file.length();
                        this.lastmodified = Math.max(this.lastmodified, file.lastModified());
                        ++this.filecount;
                    }
                    ++this.totalcount;
                }
                catch (Exception exception) {}
            }
        }
    }

    public FolderInfo(Map<String, String> map) {
        try {
            this.totalcount = Long.parseLong(map.get(IFile.COUNT));
        }
        catch (Exception exception) {}
        try {
            this.totalsize = Long.parseLong(map.get(IFile.SIZE));
        }
        catch (Exception exception) {}
        try {
            this.lastmodified = Long.parseLong(map.get(IFile.MODIFIED));
        }
        catch (Exception exception) {}
        try {
            this.folder = new File(map.get(IFile.URI));
            this.folderuid = UUID.nameUUIDFromBytes(this.folder.getAbsolutePath().getBytes()).toString();
        }
        catch (Exception exception) {}
        try {
            this.status = Byte.parseByte(map.get(IFile.STATUS));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public int hashCode() {
        return this.folder.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof FolderInfo) {
            object = (FolderInfo)FolderInfo.class.cast(object);
            return this.lastmodified == ((FolderInfo)object).lastmodified && this.totalcount == ((FolderInfo)object).totalcount && this.totalsize == ((FolderInfo)object).totalsize;
        }
        return super.equals(object);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(this.folder.getAbsolutePath());
        }
        catch (Exception exception) {
            stringBuilder.append("err1:").append(exception.getMessage());
        }
        try {
            stringBuilder.append(", tc:").append(this.totalcount);
        }
        catch (Exception exception) {
            stringBuilder.append("err2:").append(exception.getMessage());
        }
        try {
            stringBuilder.append(", ts:").append(this.totalsize);
        }
        catch (Exception exception) {
            stringBuilder.append("err2:").append(exception.getMessage());
        }
        try {
            stringBuilder.append(", fic:").append(this.filecount);
        }
        catch (Exception exception) {
            stringBuilder.append("err2:").append(exception.getMessage());
        }
        try {
            stringBuilder.append(", foc:").append(this.foldercount);
        }
        catch (Exception exception) {
            stringBuilder.append("err2:").append(exception.getMessage());
        }
        try {
            stringBuilder.append(", st:").append(this.status);
        }
        catch (Exception exception) {
            stringBuilder.append("err3:").append(exception.getMessage());
        }
        try {
            stringBuilder.append(", lm:").append(this.lastmodified);
        }
        catch (Exception exception) {
            stringBuilder.append("err4:").append(exception.getMessage());
        }
        return stringBuilder.toString();
    }
}

