/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.base.util;

import com.binfer.base.service.LogService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;

public class SerializationUtil {
    public static <T> T deepCopy(T t2) {
        if (t2 instanceof Serializable) {
            try {
                Closeable closeable = new ByteArrayOutputStream();
                new ObjectOutputStream((OutputStream)closeable).writeObject(t2);
                closeable = new ByteArrayInputStream(closeable.toByteArray());
                return (T)new ObjectInputStream((InputStream)closeable).readObject();
            }
            catch (Throwable throwable) {
                LogService.log("Deep copy failed. Original returned:" + t2.getClass() + ", e:" + throwable.getMessage(), Level.WARNING);
                return t2;
            }
        }
        return t2;
    }
}

