/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.base.util;

import com.binfer.base.service.IBinfer;
import com.binfer.base.service.IFile;
import com.binfer.base.service.IPreferences;
import com.binfer.base.service.ISpace;
import com.binfer.base.service.IUser;
import com.binfer.base.xml.Node;
import com.binfer.base.xml.XMLObject;
import com.binfer.base.xml.XMLUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Space
implements Serializable {
    protected String parentid;
    protected String spaceid;
    protected String owner;
    protected String subject;
    protected String description;
    protected byte type;
    protected long created;
    protected long modified;
    protected Map<String, String> options;
    protected List<Map<String, String>> files;
    protected Collection<Map<String, String>> members;
    protected long accountId = -1L;
    protected String userId;
    protected String deviceId;
    protected int fileCount = 0;
    protected IBinfer.INSTALL_TYPE installType = IBinfer.INSTALL_TYPE.SERVER;
    protected boolean isFullySent = false;
    protected boolean checkedfullysent = false;

    public Space(Map<String, ? extends Object> map) {
        try {
            this.spaceid = map.get(ISpace.SPACEID).toString();
        }
        catch (Exception exception) {}
        try {
            this.parentid = map.get(ISpace.PARENTSPACEID).toString();
        }
        catch (Exception exception) {}
        try {
            this.owner = map.get(ISpace.OWNER).toString();
        }
        catch (Exception exception) {}
        try {
            this.subject = map.get(ISpace.SUBJECT).toString();
        }
        catch (Exception exception) {}
        try {
            this.description = map.get(ISpace.DESCRIPTION).toString();
        }
        catch (Exception exception) {}
        try {
            this.type = Byte.parseByte(map.get(ISpace.TYPE).toString());
        }
        catch (Exception exception) {}
        try {
            this.created = Long.parseLong(map.get(ISpace.CREATED).toString());
        }
        catch (Exception exception) {}
        try {
            this.modified = Long.parseLong(map.get(ISpace.MODIFIED).toString());
        }
        catch (Exception exception) {
            this.modified = this.created;
        }
        try {
            this.fileCount = Integer.parseInt(map.get(ISpace.TOTALFILESCOUNT).toString());
        }
        catch (Exception exception) {}
        try {
            this.accountId = Long.parseLong(map.get(IUser.ACCOUNTID).toString());
        }
        catch (Exception exception) {}
        try {
            this.userId = map.get(IUser.FROM).toString();
        }
        catch (Exception exception) {}
        try {
            this.deviceId = map.get(IUser.FROMDEVICEID).toString();
        }
        catch (Exception exception) {}
        try {
            if (map.containsKey("options")) {
                this.options = (Map)Map.class.cast(map.get("options"));
            }
        }
        catch (Exception exception) {}
        try {
            if (map.containsKey("device")) {
                this.members = (Collection)Collection.class.cast(map.get("device"));
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Space(String string, String string2, String string3, String string4, byte by, long l2, long l3) {
        this.spaceid = string;
        this.owner = string2;
        this.subject = string3;
        this.description = string4;
        this.type = by;
        this.created = l2;
        this.modified = l3;
    }

    public Space(XMLObject xMLObject) {
        this(xMLObject.getProperties("/space/spaceprops"));
        this.options = xMLObject.getProperties("/space/options");
        try {
            this.members = new ArrayList<Map<String, String>>();
            for (Node node : xMLObject.getNodes("/space/members/member")) {
                try {
                    this.members.add(node.getProperties());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.files = new ArrayList<Map<String, String>>();
            for (Node node : xMLObject.getNodes("/space/files/file")) {
                try {
                    this.files.add(node.getProperties());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.fileCount = this.files.size();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.accountId = Long.parseLong(xMLObject.getNodeText("/space/preferences/" + IUser.ACCOUNTID));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Map<String, String> getSpace() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ISpace.SPACEID, this.spaceid);
        hashMap.put(ISpace.PARENTSPACEID, this.parentid);
        hashMap.put(ISpace.OWNER, this.owner);
        hashMap.put(ISpace.SUBJECT, this.subject);
        hashMap.put(ISpace.DESCRIPTION, this.description);
        hashMap.put(ISpace.TYPE, Byte.toString(this.type));
        hashMap.put(ISpace.CREATED, Long.toString(this.created));
        hashMap.put(ISpace.MODIFIED, Long.toString(this.modified));
        hashMap.put(IUser.USERID, this.userId);
        hashMap.put(IUser.DEVICEID, this.deviceId);
        hashMap.put(IUser.ACCOUNTID, Long.toString(this.accountId));
        hashMap.put(IPreferences.INSTALLTYPE, this.installType.name());
        hashMap.put(ISpace.TOTALFILESCOUNT, Integer.toString(this.fileCount));
        return hashMap;
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<space>");
        stringBuilder.append("<spaceprops>");
        stringBuilder.append(XMLUtil.xmlTag(ISpace.SPACEID, this.spaceid));
        if (this.parentid != null) {
            stringBuilder.append(XMLUtil.xmlTag(ISpace.PARENTSPACEID, this.parentid));
        }
        stringBuilder.append(XMLUtil.xmlTag(ISpace.OWNER, this.owner));
        stringBuilder.append(XMLUtil.xmlTag(ISpace.SUBJECT, this.subject));
        stringBuilder.append(XMLUtil.xmlTag(ISpace.DESCRIPTION, this.description));
        stringBuilder.append(XMLUtil.xmlTag(ISpace.TYPE, Byte.toString(this.type)));
        stringBuilder.append(XMLUtil.xmlTag(IUser.ACCOUNTID, Long.toString(this.accountId)));
        stringBuilder.append(XMLUtil.xmlTag(IUser.FROM, this.userId));
        stringBuilder.append(XMLUtil.xmlTag(IUser.FROMDEVICEID, this.deviceId));
        try {
            stringBuilder.append(XMLUtil.xmlTag(ISpace.MODIFIED, Long.toString(this.modified)));
        }
        catch (Exception exception) {}
        try {
            stringBuilder.append(XMLUtil.xmlTag(ISpace.CREATED, Long.toString(this.created)));
        }
        catch (Exception exception) {}
        try {
            stringBuilder.append(XMLUtil.xmlTag(ISpace.TOTALFILESCOUNT, Integer.toString(this.fileCount)));
        }
        catch (Exception exception) {}
        stringBuilder.append("</spaceprops>");
        stringBuilder.append("<options>");
        try {
            for (String object : this.options.keySet()) {
                try {
                    stringBuilder.append(XMLUtil.xmlTag(object, this.options.get(object)));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        stringBuilder.append("</options>");
        stringBuilder.append("<members>");
        try {
            for (Map map : this.members) {
                stringBuilder.append("<member>");
                for (String string : map.keySet()) {
                    try {
                        stringBuilder.append(XMLUtil.xmlTag(string, (String)map.get(string)));
                    }
                    catch (Exception exception) {}
                }
                stringBuilder.append("</member>");
            }
        }
        catch (Exception exception) {}
        stringBuilder.append("</members>");
        if (this.files != null && !this.files.isEmpty()) {
            stringBuilder.append("<files>");
            for (Map map : this.files) {
                stringBuilder.append("<file>");
                try {
                    for (String string : map.keySet()) {
                        stringBuilder.append(XMLUtil.xmlTag(string, (String)map.get(string)));
                    }
                }
                catch (Exception exception) {}
                stringBuilder.append("</file>");
            }
            stringBuilder.append("</files>");
            stringBuilder.append(XMLUtil.xmlTag(IFile.COUNT, Integer.toString(this.files.size())));
            stringBuilder.append(XMLUtil.xmlTag(IFile.FILESCOUNT, Integer.toString(this.files.size())));
        }
        stringBuilder.append("</space>");
        return stringBuilder.toString();
    }

    public void setSpaceID(String string) {
        this.spaceid = string;
    }

    public String getSpaceID() {
        return this.spaceid;
    }

    public String getParentID() {
        return this.parentid;
    }

    public void setParentID(String string) {
        this.parentid = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public Collection<Map<String, String>> getMembers() {
        if (this.members == null) {
            return new LinkedList<Map<String, String>>();
        }
        return this.members;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public long getCreated() {
        return this.created;
    }

    public long getModified() {
        return this.modified;
    }

    public void setCreated(long l2) {
        this.created = l2;
    }

    public void setModified(long l2) {
        this.modified = l2;
    }

    public byte getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object instanceof Space) {
            return ((Space)object).getSpaceID().equalsIgnoreCase(this.getSpaceID());
        }
        return false;
    }

    public int hashCode() {
        return this.getSpaceID().hashCode();
    }

    public void setMembers(Collection<Map<String, String>> collection) {
        this.members = collection;
    }

    public void setFiles(List<Map<String, String>> list) {
        this.files = list;
        this.fileCount = list.size();
    }

    public List<Map<String, String>> getFiles1() {
        return this.files;
    }

    public int getFileCount() {
        if (this.files == null) {
            return 0;
        }
        return this.files.size();
    }

    public void setOptions(Map<String, String> map) {
        this.options = map;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public Space clone() {
        Space space = new Space(this.spaceid, this.owner, this.subject, this.description, this.type, this.created, this.modified);
        new Space(this.spaceid, this.owner, this.subject, this.description, this.type, this.created, this.modified).fileCount = this.fileCount;
        space.checkedfullysent = this.checkedfullysent;
        if (this.fileCount > 0 && this.files != null) {
            space.files = new LinkedList<Map<String, String>>();
            space.files.addAll(this.files);
        }
        space.isFullySent = this.isFullySent;
        space.parentid = this.parentid;
        return space;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(long l2) {
        this.accountId = l2;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String string) {
        this.deviceId = string;
    }

    public IBinfer.INSTALL_TYPE getInstallType() {
        return this.installType;
    }

    public void setInstallType(IBinfer.INSTALL_TYPE iNSTALL_TYPE) {
        this.installType = iNSTALL_TYPE;
    }

    public boolean isEnabled() {
        boolean bl = true;
        try {
            if (this.options.containsKey(ISpace.SPACE_OPTION_ENABLED)) {
                bl = Boolean.parseBoolean(this.options.get(ISpace.SPACE_OPTION_ENABLED));
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    public boolean matchesKeyword(String string) {
        boolean bl = true;
        if (string != null && !string.isEmpty()) {
            if (this.description == null) {
                this.description = "";
            }
            String string2 = "";
            try {
                string2 = this.options.get(ISpace.SPACE_OPTION_SYNC_SOURCEFOLDER).toString();
            }
            catch (Exception exception) {}
            if (!(bl = this.subject.contains(string) || this.description.contains(string) || string2.contains(string) || this.owner.contains(string) || this.spaceid.contains(string)) && this.members != null && !this.members.isEmpty()) {
                try {
                    Iterator<Map<String, String>> iterator = this.members.iterator();
                    while (iterator.hasNext()) {
                        if (!iterator.next().get(IUser.USERID).contains(string)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    public String toString() {
        return "Sub:" + this.subject + ", type:" + this.type + ", owner:" + this.owner + ", spaceid:" + this.getSpaceID() + ", pspaceid:" + this.getParentID() + "\n>options:" + this.options + "\n>members:" + this.members + "\n>files:" + this.files + "\n>accountId:" + this.accountId + ", from:" + this.userId + ", device:" + this.deviceId + ", created:" + this.created + ", lastmod:" + this.modified;
    }
}

