/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.base.util;

import com.binfer.base.http.FederatedTransfer;
import com.binfer.base.service.IOService;
import com.binfer.base.util.TimeUtil;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Date;

public class SystemInfo {
    public double load = -1.0;
    public long freeram = -1L;
    public long totram = -1L;
    public Date uptime;
    public long nheapmax;
    public long nheapused;
    public long tcount;
    public long tmax;
    public int pendingFinalzn;
    private long a = 0x100000L;
    private Runtime b;

    public SystemInfo() {
        SystemInfo systemInfo = this;
        try {
            java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            if (operatingSystemMXBean instanceof OperatingSystemMXBean) {
                operatingSystemMXBean = (OperatingSystemMXBean)operatingSystemMXBean;
                systemInfo.load = operatingSystemMXBean.getSystemLoadAverage();
                systemInfo.freeram = operatingSystemMXBean.getFreePhysicalMemorySize() / systemInfo.a;
                systemInfo.totram = operatingSystemMXBean.getTotalPhysicalMemorySize() / systemInfo.a;
            } else {
                systemInfo.load = operatingSystemMXBean.getSystemLoadAverage();
            }
            systemInfo.uptime = new Date(ManagementFactory.getRuntimeMXBean().getStartTime());
            systemInfo.nheapmax = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getMax() / systemInfo.a;
            systemInfo.nheapused = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed() / systemInfo.a;
            systemInfo.tcount = ManagementFactory.getThreadMXBean().getThreadCount();
            systemInfo.tmax = ManagementFactory.getThreadMXBean().getPeakThreadCount();
            systemInfo.pendingFinalzn = ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount();
            systemInfo.b = Runtime.getRuntime();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public String getSystemInfo() {
        long[] lArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Uptime: ").append(TimeUtil.getElapsedTime(this.uptime)).append(", since ").append(this.uptime.toString()).append(")");
        try {
            stringBuilder.append("<br>CPUs: ").append(this.b.availableProcessors());
            stringBuilder.append(", Load: ").append(this.load);
            stringBuilder.append("<br>Heap: Free: ").append(this.b.freeMemory() / this.a).append("+Used: ").append((this.b.totalMemory() - this.b.freeMemory()) / this.a).append("=Allocated: ").append(this.b.totalMemory() / this.a).append(", Max: ").append(this.b.maxMemory() / this.a);
        }
        catch (Exception exception) {}
        stringBuilder.append("<br>NonHeap: Used:").append(this.nheapused).append(", Max: ").append(this.nheapmax);
        stringBuilder.append("<br>RAM: Free: ").append(this.freeram).append(" of ").append(this.totram).append(" total");
        stringBuilder.append("<br>Pending finalzn: ").append(this.pendingFinalzn);
        stringBuilder.append("<br>Threads: ").append(this.tcount).append(" of ").append(this.tmax).append(" peak");
        try {
            lArray = ManagementFactory.getThreadMXBean().findDeadlockedThreads();
            stringBuilder.append(", deadlocked:" + (lArray == null ? 0 : lArray.length));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            lArray = ManagementFactory.getThreadMXBean().findMonitorDeadlockedThreads();
            stringBuilder.append(", mdeadlocked:" + (lArray == null ? 0 : lArray.length));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            stringBuilder.append("<br>Disk free: ");
            long l2 = new File("/").getFreeSpace();
            stringBuilder.append(IOService.bytesToFriendlyString(l2));
        }
        catch (Exception exception) {
            stringBuilder.append("err getting free disk space:").append(exception.getMessage());
        }
        stringBuilder.append("<br>In-progress transfers:").append(FederatedTransfer.getInProgressTransferCount());
        return stringBuilder.toString();
    }
}

