/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.base.util;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class TimeUtil {
    private static String a = "days";
    private static String b = "day";
    private static String c = "hrs";
    private static String d = "hr";
    private static String e = "min";
    private static String f = "sec";
    private static String g = "d";
    private static String h = "h";
    private static String i = "m";
    private static String j = "s";
    private static String k = "ago";
    private static String l = " ";
    private static SimpleDateFormat m = new SimpleDateFormat("dd MMM yy, h:mm a");
    private static SimpleDateFormat n = new SimpleDateFormat("ddMMMyy");
    private static SimpleDateFormat o = new SimpleDateFormat("dd-HH-mm-ss");
    private static SimpleDateFormat p = new SimpleDateFormat("dd MMM");
    private static SimpleDateFormat q = new SimpleDateFormat("dd-MMM-yy-HH-mm-ss");
    private static SimpleDateFormat r = new SimpleDateFormat("h:mma");
    private static SimpleDateFormat s = new SimpleDateFormat("dd MMM yy");
    private static SimpleDateFormat t = new SimpleDateFormat("yyyymmddHHmmss");
    private static SimpleDateFormat u = new SimpleDateFormat("yyyyMMdd'T'HHmm00z");
    public static long IN_MS_ONE_SEC = 1000L;
    public static long IN_MS_ONE_MIN = 60L * IN_MS_ONE_SEC;
    public static long IN_MS_ONE_HOUR = 60L * IN_MS_ONE_MIN;
    public static long IN_MS_ONE_DAY = 24L * IN_MS_ONE_HOUR;
    public static long IN_MS_ONE_WEEK = 168L * IN_MS_ONE_HOUR;

    public static String getElapsedTime(Date date) {
        long l2 = System.currentTimeMillis() - date.getTime();
        if (TimeUnit.MILLISECONDS.toDays(l2) > 7L) {
            return m.format(date);
        }
        return TimeUtil.getElapsedTime(l2) + l + k;
    }

    public static String getElapsedTime(long l2) {
        long l3 = TimeUnit.MILLISECONDS.toSeconds(l2);
        long l4 = TimeUnit.MILLISECONDS.toDays(l2);
        long l5 = TimeUnit.MILLISECONDS.toHours(l2);
        long l6 = TimeUnit.MILLISECONDS.toMinutes(l2);
        if (l4 > 1L) {
            return l4 + l + a;
        }
        if (l4 == 1L) {
            return l4 + l + b;
        }
        if (l5 > 1L) {
            return l5 + l + c;
        }
        if (l5 == 1L) {
            return l5 + l + d;
        }
        if (l6 > 0L) {
            return l6 + l + e;
        }
        return l3 + l + f;
    }

    public static String getElapsedTimeFriendly(long l2) {
        if (l2 < 1000L) {
            return l2 + " ms";
        }
        long l3 = TimeUnit.MILLISECONDS.toSeconds(l2);
        if (l3 < 60L) {
            return l3 + " second" + (l3 == 1L ? "" : "s");
        }
        long l4 = TimeUnit.MILLISECONDS.toMinutes(l2);
        if (l4 < 60L) {
            long l5 = l3 % 60L;
            return l4 + " minute" + (l4 == 1L ? "" : "s") + (l5 > 0L ? " " + l5 + " second" + (l5 == 1L ? "" : "s") : "");
        }
        long l6 = TimeUnit.MILLISECONDS.toHours(l2);
        if (l6 < 24L) {
            long l7 = l4 % 60L;
            long l8 = l3 % 60L;
            return l6 + " hour" + (l6 == 1L ? "" : "s") + (l7 > 0L ? " " + l7 + " minute" + (l7 == 1L ? "" : "s") : "") + (l8 > 0L ? " " + l8 + " second" + (l8 == 1L ? "" : "s") : "");
        }
        long l9 = TimeUnit.MILLISECONDS.toDays(l2);
        long l10 = l6 % 24L;
        long l11 = l4 % 60L;
        long l12 = l3 % 60L;
        return l9 + " day" + (l9 == 1L ? "" : "s") + (l10 > 0L ? " " + l10 + " hour" + (l10 == 1L ? "" : "s") : "") + (l11 > 0L ? " " + l11 + " minute" + (l11 == 1L ? "" : "s") : "") + (l12 > 0L ? " " + l12 + " second" + (l12 == 1L ? "" : "s") : "");
    }

    public static String getElapsedTimeExact(long l2) {
        StringBuilder stringBuilder = new StringBuilder();
        long l3 = TimeUnit.MILLISECONDS.toDays(l2);
        if (l3 > 0L) {
            stringBuilder.append(l3).append(g);
            l2 -= TimeUnit.DAYS.toMillis(l3);
        }
        if ((l3 = TimeUnit.MILLISECONDS.toHours(l2)) > 0L) {
            stringBuilder.append(l3).append(h);
            l2 -= TimeUnit.HOURS.toMillis(l3);
        }
        if ((l3 = TimeUnit.MILLISECONDS.toMinutes(l2)) > 0L) {
            stringBuilder.append(l3).append(i);
            l2 -= TimeUnit.MINUTES.toMillis(l3);
        }
        if ((l3 = TimeUnit.MILLISECONDS.toSeconds(l2)) > 0L) {
            stringBuilder.append(l3).append(j);
        }
        return stringBuilder.toString();
    }

    public static long getDaysDiff(Date date, Date date2) {
        long l2 = date.getTime() - date2.getTime();
        return TimeUnit.MILLISECONDS.toDays(l2);
    }

    public static String getSimpleTime(Date date) {
        return m.format(date);
    }

    public static String getShortDate(Date date) {
        return n.format(date);
    }

    public static String getDateHourMinSec() {
        return o.format(new Date());
    }

    public static String getDayMonthTime(Date date) {
        return p.format(date);
    }

    public static String getDayMonthYearHourMinSec(Date date) {
        return q.format(date);
    }

    public static String getHour(Date date) {
        return r.format(date);
    }

    public static String getDayMonthYearTime(Date date) {
        return s.format(date);
    }

    public static String getNumbersTime(Date date) {
        return t.format(date);
    }

    public static String getISO8601Time(Date date) {
        return u.format(date);
    }

    public static List<Date> getWeeks(int n2) {
        LinkedList<Date> linkedList = new LinkedList<Date>();
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(5, 1);
        calendar.set(2, 0);
        calendar.set(1, n2);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        linkedList.add(calendar.getTime());
        for (n2 = 1; n2 < calendar.getActualMaximum(3); ++n2) {
            calendar.add(5, 7);
            linkedList.add(calendar.getTime());
        }
        return linkedList;
    }

    public static boolean hasTimeElapsed(long l2, long l3, TimeUnit timeUnit) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        calendar.add(14, new Long(TimeUnit.MILLISECONDS.convert(l3, timeUnit)).intValue());
        return calendar.getTime().before(new Date());
    }

    public static int dayOfWeekToInt(String object) {
        try {
            object = new SimpleDateFormat("E", Locale.ENGLISH).parse((String)object);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            return calendar.get(7);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static boolean isSameDay(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(date);
        calendar2.setTime(date2);
        return calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    public static Date atStartOfDay(LocalDate localDate) {
        return Date.from(localDate.atTime(LocalTime.MIN).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date atEndOfDay(LocalDate localDate) {
        return Date.from(localDate.atTime(LocalTime.MAX).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static long daysBetween(Date date, Date date2) {
        return ChronoUnit.DAYS.between(Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate(), Instant.ofEpochMilli(date2.getTime()).atZone(ZoneId.systemDefault()).toLocalDate());
    }
}

