/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.base.util;

import com.binfer.base.service.IFile;
import com.binfer.base.service.IOService;
import com.binfer.base.util.TimeUtil;
import com.binfer.base.util.Xfer;
import java.util.UUID;

public class TransferBean {
    private Xfer a;
    private String b = "Receiving";
    private String c = "Received";
    private String d = "Sending";
    private String e = "Sent";
    private String f = "Paused";
    private String g;
    public long lastModified = System.currentTimeMillis();

    public TransferBean(Xfer xfer) {
        this.a = xfer;
        this.g = this.a();
    }

    public void update(Xfer xfer) {
        this.a = null;
        this.a = xfer;
        this.lastModified = System.currentTimeMillis();
    }

    private String a() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.a.fromDeviceID);
        stringBuilder.append(this.a.toDeviceID);
        try {
            stringBuilder.append(this.a.file.getParentFile().getAbsolutePath());
        }
        catch (Exception exception) {}
        stringBuilder.append(this.a.filename);
        return UUID.nameUUIDFromBytes(stringBuilder.toString().getBytes()).toString();
    }

    public String transferKey() {
        return this.g;
    }

    public String getStatus() {
        try {
            if (this.a.status == IFile.FILE_STATUS_RECEIVING) {
                return this.b;
            }
            if (this.a.status == IFile.FILE_STATUS_RECEIVED) {
                return this.c;
            }
            if (this.a.status == IFile.FILE_STATUS_SENDING) {
                return this.d;
            }
            if (this.a.status == IFile.FILE_STATUS_SENT) {
                return this.e;
            }
            return this.f;
        }
        catch (Exception exception) {
            return this.f;
        }
    }

    public String getSubject() {
        return this.a.subject;
    }

    public String getOwner() {
        if (this.a.status == IFile.FILE_STATUS_RECEIVING || this.a.status == IFile.FILE_STATUS_RECEIVED || this.a.status == IFile.FILE_STATUS_RECEIVE_FAILED) {
            return this.a.fromName;
        }
        return this.a.toName;
    }

    public String getFile() {
        return this.a.filename;
    }

    public Double getProgress() {
        try {
            return (double)Math.round(this.a.getPercentComplete() * 100.0) / 100.0;
        }
        catch (Exception exception) {
            return this.a.getPercentComplete();
        }
    }

    public int getSpeedNet() {
        return this.a.getKbPerSecondNet();
    }

    public String getSpeedCurrent() {
        try {
            return IOService.bytesToFriendlyString(Double.valueOf(this.a.speedKiloBytesPerSecondNet * (double)Xfer.KILOBYTES).longValue()) + "/s";
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.a.speedKiloBytesPerSecondNet + " KB/s";
        }
    }

    public String getSpeed() {
        return this.a.getKbPerSecondCurrent() + "/" + this.a.getKbPerSecondNet();
    }

    public String getTimeLeft() {
        return this.a.getETA();
    }

    public String getFinishTime() {
        try {
            return TimeUtil.getSimpleTime(this.a.finishTime);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getTransferred() {
        try {
            return this.a.getXferedSize();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean equals(Object object) {
        if (object instanceof TransferBean) {
            return this.transferKey().equals(((TransferBean)TransferBean.class.cast(object)).transferKey());
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.transferKey().hashCode();
    }

    public Xfer getXfer() {
        return this.a;
    }

    public String toString() {
        return "filename:" + this.a.filename + ", xferkey:" + this.g + ", xferid:" + this.a.xferid + "\nxfer:" + this.a;
    }
}

