/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.base.util;

import com.binfer.base.service.DownloadService;
import com.binfer.base.service.EventService;
import com.binfer.base.service.FileService;
import com.binfer.base.service.FileTransferService;
import com.binfer.base.service.IErrors;
import com.binfer.base.service.IEvent;
import com.binfer.base.service.IFile;
import com.binfer.base.service.IOService;
import com.binfer.base.service.IVersion;
import com.binfer.base.service.LogService;
import com.binfer.base.service.MessageService;
import com.binfer.base.util.XferException;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class Xfer {
    public static long KILOBYTES = 1024L;
    public static long MEGABYTES = 0x100000L;
    public String from;
    public String to;
    public String subject;
    public String filename;
    public String fileid;
    public String spaceid;
    public String fromDeviceID;
    public String toDeviceID;
    public String fromName;
    public String toName;
    public String xferid;
    public long size;
    public long offset = 0L;
    public byte status;
    public byte originalStatus;
    public boolean isLANSend = false;
    private boolean a = false;
    private boolean b = false;
    public String contactIP;
    public String selfIP;
    public String contactClient;
    public String keySeed;
    public File file;
    private long c = System.nanoTime();
    private long d = 0L;
    private long e = System.currentTimeMillis();
    private long f = 0L;
    private long g = 0L;
    private long h;
    public double timetaken = 0.0;
    public double perc = 0.0;
    public double speedBytesPerSecondNet = 0.0;
    public double speedBytesPerSecondCurr = 0.0;
    public double speedKiloBytesPerSecondNet = 0.0;
    public double speedKiloBytesPerSecondCurr = 0.0;
    public String eta = "0";
    private boolean i = false;
    public boolean useChunking = false;
    private static long j = 6000L;
    public boolean publishEvents = true;
    public long st = System.currentTimeMillis();
    public long et = 0L;
    public Date finishTime;
    private int k;
    private boolean l = false;
    private List<Throwable> m = new LinkedList<Throwable>();
    private IVersion.RECEIVEFILEEXISTPOLICY n = IVersion.RECEIVEFILEEXISTPOLICY.OVERWRITE;
    private static int o = 12800;
    private static boolean p = false;
    private static double q = TimeUnit.SECONDS.toNanos(1L);
    public int interruptedCount = 0;
    public String urlSelfGet;
    public String urlPeerSend;
    public boolean sendMesg = false;
    public String parentSpaceId;
    private long r = System.nanoTime();
    private static long s = 4000L;

    public Xfer(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, File file, long l2, long l3, byte by, boolean bl, int n2, IVersion.RECEIVEFILEEXISTPOLICY rECEIVEFILEEXISTPOLICY) {
        this(string, string2, string3, string4, string5, string6, string7, string8, string9, file, l2, l3, by, bl, n2);
        this.n = rECEIVEFILEEXISTPOLICY;
    }

    public Xfer(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, File file, long l2, long l3, byte by, boolean bl, int n2) {
        this.subject = string7;
        this.from = string;
        this.to = string4;
        this.spaceid = string8;
        this.fileid = string9;
        this.status = by;
        this.originalStatus = by;
        this.keySeed = FileTransferService.createXferKEY(string, string2, string4, string5, string8, string9);
        this.xferid = FileTransferService.createTXNID(string, string2, string4, string5, string8, string9);
        this.fromDeviceID = string2;
        this.toDeviceID = string5;
        this.fromName = string3;
        this.toName = string6;
        this.filename = file.getName();
        this.size = l2;
        if (by == IFile.FILE_STATUS_RECEIVING || by == IFile.FILE_STATUS_PENDING_RECEIVE) {
            this.file = new File(file.getParent(), this.filename + ".part");
            this.offset = this.file.length();
            this.deleteInvalidFile();
        } else {
            this.file = file;
            this.offset = l3;
        }
        this.f = this.offset;
        this.setEncrypted(bl);
        this.setCompression(n2);
    }

    public void addXfered(long l2) throws Exception {
        this.f += l2;
        this.g += l2;
        long l3 = System.currentTimeMillis() - this.e;
        try {
            long l4 = System.nanoTime();
            this.speedBytesPerSecondCurr = (double)l2 * q / (double)(l4 - this.r);
            this.speedKiloBytesPerSecondCurr = this.speedBytesPerSecondCurr / (double)KILOBYTES;
            this.r = l4;
        }
        catch (Exception exception) {}
        this.a();
        if (l3 >= j) {
            if (this.publishEvents) {
                EventService.publish(IEvent.EVENT.XFERPROGRESSCHANGED, this);
            }
            this.e = System.currentTimeMillis();
        }
        Xfer xfer = this;
        if (p) {
            long l5 = 0L;
            while (xfer.getKbPerSecondNet() > o) {
                try {
                    Thread.currentThread();
                    Thread.sleep(s);
                    if ((l5 += s) + 5000L < 65000L) continue;
                    return;
                }
                catch (Exception exception) {
                }
            }
        }
    }

    public void setXferStarted() {
        this.c = System.nanoTime();
        if (this.publishEvents) {
            EventService.publish(IEvent.EVENT.XFERSTARTED, this);
        }
    }

    public void setXferDone() {
        this.et = System.currentTimeMillis();
        this.finishTime = new Date();
        this.a();
        this.getKbPerSecondNet();
        this.i = true;
        this.speedBytesPerSecondCurr = this.speedBytesPerSecondNet;
        this.speedKiloBytesPerSecondCurr = this.speedKiloBytesPerSecondNet;
        this.getPercentComplete();
        this.getETA();
        if (this.f < this.size) {
            this.setStatusFailed();
            throw new RuntimeException(IErrors.CODE.TRANSFER_INTERRUPTED_INCOMPLETE.name());
        }
        if (this.f > this.size) {
            this.setStatusFailed();
            throw new RuntimeException(IErrors.CODE.TRANSFER_INTERRUPTED_EXCESS.name());
        }
        if (this.f == this.size) {
            if (this.status == IFile.FILE_STATUS_PENDING_RECEIVE || this.status == IFile.FILE_STATUS_RECEIVING) {
                this.status = IFile.FILE_STATUS_RECEIVED;
            } else if (this.status == IFile.FILE_STATUS_PENDING_SEND || this.status == IFile.FILE_STATUS_SENDING) {
                this.status = IFile.FILE_STATUS_SENT;
            }
        }
        if (this.status == IFile.FILE_STATUS_RECEIVED) {
            if (this.file.getName().endsWith(".part")) {
                File file = new File(this.file.getParent(), this.filename);
                DownloadService.applyVersionControlPolicy(file, this.n);
                boolean bl = this.file.renameTo(file);
                if (bl) {
                    this.file = file;
                    return;
                }
                if (!this.file.exists() || this.file.length() != this.size) {
                    this.setStatusFailed();
                    try {
                        LogService.log(">> error1. transfer failed for:" + this.file + ", renamed?" + bl + ", exists?" + this.file.exists() + ", file size:" + this.file.length() + ", transferred:" + this.f + " of " + this.size, Level.SEVERE);
                    }
                    catch (Exception exception) {}
                    throw new RuntimeException(IErrors.CODE.TRANSFER_INTERRUPTED.name());
                }
                this.setStatusFailed();
                try {
                    LogService.log(">> error2. transfer failed for:" + this.file + ", renamed?" + bl + ", exists?" + this.file.exists() + ", file size:" + this.file.length() + ", transferred:" + this.f + " of " + this.size, Level.SEVERE);
                }
                catch (Exception exception) {}
                throw new RuntimeException(IErrors.CODE.TRANSFER_INTERRUPTED.name());
            }
            LogService.log(">> error3. transfer failed for:" + this.file + ", not part file, exists?" + this.file.exists() + ", file size:" + this.file.length() + ", transferred:" + this.f + " of " + this.size, Level.WARNING);
        }
    }

    public void setStatusFailed() {
        if (this.status == IFile.FILE_STATUS_SENDING || this.status == IFile.FILE_STATUS_SENT || this.status == IFile.FILE_STATUS_PENDING_SEND) {
            this.status = IFile.FILE_STATUS_SEND_FAILED;
            return;
        }
        if (this.status == IFile.FILE_STATUS_RECEIVING || this.status == IFile.FILE_STATUS_PENDING_RECEIVE || this.status == IFile.FILE_STATUS_RECEIVED) {
            this.status = IFile.FILE_STATUS_RECEIVE_FAILED;
            try {
                if (this.file.exists() && this.file.length() == 0L) {
                    FileService.deleteFile(this.file);
                    LogService.log("!!!empty file deleted:" + this.file.getAbsolutePath(), Level.SEVERE);
                }
                return;
            }
            catch (Exception exception) {}
        }
    }

    public int getKbPerSecondNet() {
        if (!this.i) {
            double d2 = System.nanoTime() - this.c;
            this.speedBytesPerSecondNet = (double)(this.f - this.offset) * q / d2;
            this.speedKiloBytesPerSecondNet = this.speedBytesPerSecondNet / (double)KILOBYTES;
        }
        return Double.valueOf(this.speedKiloBytesPerSecondNet).intValue() << 3;
    }

    public int getKBPerSecondNet() {
        if (!this.i) {
            double d2 = System.nanoTime() - this.c;
            this.speedBytesPerSecondNet = (double)(this.f - this.offset) * q / d2;
            this.speedKiloBytesPerSecondNet = this.speedBytesPerSecondNet / (double)KILOBYTES;
        }
        return Double.valueOf(this.speedKiloBytesPerSecondNet).intValue();
    }

    public int getKbPerSecondCurrent() {
        if (this.i) {
            return this.getKbPerSecondNet();
        }
        return Double.valueOf(this.speedKiloBytesPerSecondCurr).intValue() << 3;
    }

    public int getKBPerSecondCurrent() {
        if (this.i) {
            return this.getKBPerSecondNet();
        }
        return Double.valueOf(this.speedKiloBytesPerSecondCurr).intValue();
    }

    private void a() {
        if (!this.i) {
            this.d = System.nanoTime() - this.c;
        }
    }

    public long getXfered() {
        return this.f;
    }

    public String getXferedSize() {
        if (this.size == this.f) {
            return IOService.bytesToFriendlyString(this.size);
        }
        return IOService.bytesToFriendlyString(this.f) + " of " + IOService.bytesToFriendlyString(this.size);
    }

    public double getPercentComplete() {
        try {
            this.perc = this.f == this.size ? 100.0 : 100.0 * (double)this.f / (double)this.size;
        }
        catch (Throwable throwable) {}
        return this.perc;
    }

    public String getETA() {
        if (this.i) {
            this.eta = "0";
        } else {
            try {
                if (this.getTimeTaken() == 0L) {
                    this.eta = "0";
                } else if (this.f < this.size) {
                    double d2;
                    double d3 = (double)(this.size - this.f) / this.speedBytesPerSecondCurr;
                    if (d2 > 0.0) {
                        int n2 = (int)(d3 % 60.0);
                        int n3 = (int)(d3 % 3600.0) / 60;
                        int n4 = (int)(d3 / 3600.0);
                        this.eta = (n4 > 0 ? n4 + "h " : "") + (n3 > 0 ? n3 + "m " : "") + (n2 > 0 ? n2 + "s" : "");
                    }
                }
            }
            catch (Throwable throwable) {
                return "?";
            }
        }
        return this.eta;
    }

    public long getTimeTaken() {
        return TimeUnit.NANOSECONDS.toSeconds(this.d);
    }

    public long getLastUpdatedTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.c);
    }

    public int hashCode() {
        return this.xferid.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Xfer) {
            return this.xferid.equalsIgnoreCase(((Xfer)Xfer.class.cast((Object)object)).xferid);
        }
        return super.equals(object);
    }

    public void setWebPickup(String string) {
        this.a = true;
        this.xferid = string;
        this.l = false;
        this.k = 0;
    }

    public boolean getIsWebPickup() {
        return this.a;
    }

    public void setWebDrop() {
        this.b = true;
        if (this.offset > 0L) {
            FileService.deleteFile(this.file);
            this.offset = 0L;
            this.f = 0L;
        }
        this.xferid = UUID.randomUUID().toString();
        this.l = false;
        this.k = 0;
    }

    public boolean getIsWebDrop() {
        return this.b;
    }

    public void setCompression(int n2) {
        this.k = n2;
    }

    public int getCompression() {
        return this.k;
    }

    public void setEncrypted(boolean bl) {
        this.l = bl;
    }

    public boolean isEncrypted() {
        return this.l;
    }

    public int getThrottle() {
        if (p) {
            return o;
        }
        return 0;
    }

    public static void setThrottle(boolean bl, int n2) throws Exception {
        p = bl;
        if (bl) {
            if (n2 < 32) {
                throw new Exception("Throttle cannot be less than 32 kilobits.");
            }
            o = n2;
            int cfr_ignored_0 = (n2 << 10) / 8;
        }
    }

    public void deleteInvalidFile() {
        try {
            if (this.file != null && this.file.exists() && (this.file.length() == 0L || this.file.length() >= this.size)) {
                FileService.deleteFile(this.file);
                this.offset = 0L;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String toString() {
        return this.getTransferDetails();
    }

    public String getSummary() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.status == IFile.FILE_STATUS_RECEIVED || this.status == IFile.FILE_STATUS_RECEIVING) {
            stringBuilder.append(this.from).append("#").append(this.fromDeviceID);
        } else {
            stringBuilder.append(this.to).append("#").append(this.toDeviceID);
        }
        stringBuilder.append(", file:").append(this.file.getAbsolutePath()).append(", subject:" + this.subject).append(", xfered:").append(this.f).append(" of ").append(this.size);
        return stringBuilder.toString();
    }

    public String getThreadName() {
        return "F:" + this.from + ",T:" + this.to + ",F:" + this.filename + ",S:" + this.subject;
    }

    public boolean isDone() {
        return this.i;
    }

    public String getSendKey() {
        return MessageService.getMessageKey(this.toDeviceID);
    }

    public String getRecvKey() {
        return MessageService.getMessageKey(this.toDeviceID);
    }

    public long getXferedSession() {
        return this.g;
    }

    public boolean isCompressed() {
        return this.k > 0;
    }

    public long getXferedCompressed() {
        if (this.isCompressed()) {
            return this.h;
        }
        return this.f;
    }

    public void setXferedCompressed(long l2) {
        this.h = l2;
    }

    public double getPercentCompressed() {
        double d2 = 0.0;
        try {
            d2 = 100.0 * (double)(this.g - this.h) / (double)this.g;
        }
        catch (Throwable throwable) {}
        return d2;
    }

    public void setXfered(long l2) {
        this.f = l2;
    }

    public void setDone() {
        this.i = true;
    }

    public void setStartTime(long l2) {
        this.c = l2;
    }

    public void setTimetaken(long l2) {
        this.d = l2;
    }

    public double getKiloBytesPerSecondNet() {
        return this.speedKiloBytesPerSecondNet;
    }

    public void setKiloBytesPerSecondNet(double d2) {
        this.speedKiloBytesPerSecondNet = d2;
    }

    public void addException(Throwable throwable) {
        if (!this.m.contains(throwable)) {
            if (throwable instanceof XferException) {
                this.m.add(0, throwable);
                return;
            }
            this.m.add(throwable);
        }
    }

    public String getError() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nDetails:");
        for (Throwable throwable : this.m) {
            stringBuilder.append(1).append(": [").append(LogService.getAllMessages(throwable)).append("] ");
        }
        int n2 = 1;
        stringBuilder.append("\nTrace:");
        for (Throwable throwable : this.m) {
            stringBuilder.append(n2).append(": [").append(LogService.getStackTrace(throwable, 3)).append("] ");
            ++n2;
        }
        return stringBuilder.toString();
    }

    public String getTransferDetails() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Transfer details.");
        stringBuilder.append(" Type: ").append(this.status == IFile.FILE_STATUS_PENDING_SEND || this.status == IFile.FILE_STATUS_SENDING || this.status == IFile.FILE_STATUS_SENT || this.status == IFile.FILE_STATUS_SEND_FAILED ? "Send" : "Receive");
        stringBuilder.append(", From: ").append(this.fromName).append(":").append(this.from).append(":").append(this.fromDeviceID);
        stringBuilder.append(", To: ").append(this.toName).append(":").append(this.to).append(":").append(this.toDeviceID);
        stringBuilder.append(", Subject: ").append(this.subject);
        stringBuilder.append(", File: ").append(this.file.getAbsolutePath());
        stringBuilder.append(", PSID: ").append(this.parentSpaceId);
        stringBuilder.append(", SID: ").append(this.spaceid);
        stringBuilder.append(", FID: ").append(this.fileid);
        stringBuilder.append(", LastModified: ").append(this.file.lastModified());
        stringBuilder.append(", Offset: ").append(this.offset);
        stringBuilder.append(", Xfered.session: ").append(this.getXferedSession()).append(", Xfered.net: ").append(this.getXfered()).append(" of Total: ").append(this.size);
        stringBuilder.append(", Compression: ").append(this.getCompression());
        stringBuilder.append(", Encrypted: ").append(this.isEncrypted());
        stringBuilder.append(", Throttle: ").append(this.getThrottle());
        stringBuilder.append(", isWD: ").append(this.b);
        stringBuilder.append(", isWP: ").append(this.a);
        stringBuilder.append(", MaxKiloPerSec: ").append(p ? Integer.valueOf(o) : "UL");
        stringBuilder.append(", NetKiloBitsPerSec: ").append(this.getKbPerSecondNet());
        stringBuilder.append(", Time: ").append(this.getTimeTaken());
        stringBuilder.append(", xferid: ").append(this.xferid);
        return stringBuilder.toString();
    }
}

