/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.base.xml;

import com.binfer.base.service.LogService;
import java.util.Map;
import java.util.logging.Level;

public class XMLUtil {
    public static String xmlStartTag(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(string).append(">");
        return stringBuilder.toString();
    }

    public static String xmlEndTag(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("</").append(string).append(">");
        return stringBuilder.toString();
    }

    public static String xmlTag(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            string2 = XMLUtil.removeInvalidXMLCharacters(string2).replaceAll("</", "}").replaceAll("<|>", "{");
            stringBuilder.append("<").append(string).append("><![CDATA[").append(string2.trim()).append("]]></").append(string).append(">");
        }
        return stringBuilder.toString();
    }

    public static String mapToXML(Map<String, ? extends Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : map.keySet()) {
            try {
                String string2 = map.get(string).toString();
                stringBuilder.append(XMLUtil.xmlTag(string, string2));
            }
            catch (Exception exception) {
                LogService.log("EXPN.bad protocol data:" + string + ", val:" + map.get(string) + ", err:" + exception.getMessage(), Level.SEVERE);
            }
        }
        return stringBuilder.toString();
    }

    public static String xmlResponseFromMap(Map<String, ? extends Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuilder.append("<request>");
        for (String string : map.keySet()) {
            try {
                String string2 = map.get(string).toString();
                stringBuilder.append(XMLUtil.xmlTag(string, string2));
            }
            catch (Exception exception) {}
        }
        stringBuilder.append("</request>");
        return stringBuilder.toString();
    }

    public static String removeInvalidXMLCharacters(String string) {
        try {
            string = XMLUtil.stripInvalidXMLCharacters(string);
            StringBuilder stringBuilder = new StringBuilder();
            if (string == null || "".equals(string)) {
                return "";
            }
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (!(c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 >= ' ' && c2 <= '\ud7ff' || c2 >= '\ue000' && c2 <= '\ufffd') && (c2 < '\u10000' || c2 > '\u10ffff')) continue;
                stringBuilder.append(c2);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String stripInvalidXMLCharacters(String string) {
        String string2 = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
        return string.replaceAll(string2, "").trim();
    }
}

