/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.common.util;

import com.binfer.common.util.ItemBean;
import com.binfer.common.util.NumberUtil;
import com.binfer.common.work.Work;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BasicScheduler {
    private static BasicScheduler b;
    ScheduledThreadPoolExecutor a;
    private int c = 5;
    private final Map<String, Future> d = new HashMap<String, Future>();

    private BasicScheduler() {
        if (this.a != null) {
            this.a.shutdownNow();
        }
        this.a = new ScheduledThreadPoolExecutor(this.c);
        this.a.setMaximumPoolSize(this.c << 1);
    }

    public static BasicScheduler getInstance() {
        if (b == null) {
            b = new BasicScheduler();
        }
        return b;
    }

    public void scheduleWork(Work work, Calendar calendar, long l, TimeUnit timeUnit) {
        this.cancelWork(work.getTaskName());
        if (calendar == null) {
            ScheduledFuture<?> scheduledFuture = this.a.scheduleAtFixedRate(work, 0L, l, timeUnit);
            if (this.d.containsKey(work.getTaskName())) {
                try {
                    this.d.get(work.getTaskName()).cancel(true);
                }
                catch (Exception exception) {}
            }
            this.d.put(work.getTaskName(), scheduledFuture);
            return;
        }
        long l2 = calendar.getTimeInMillis() - System.currentTimeMillis();
        if (l2 < 0L) {
            this.a.schedule(work, 0L, TimeUnit.MILLISECONDS);
            calendar.add(5, 1);
            l2 = (calendar.getTime().getTime() - System.currentTimeMillis()) / 1000L;
        }
        this.a.schedule(new Runnable(this, work, l, timeUnit){
            private /* synthetic */ Work a;
            private /* synthetic */ long b;
            private /* synthetic */ TimeUnit c;
            private /* synthetic */ BasicScheduler d;
            {
                this.d = basicScheduler;
                this.a = work;
                this.b = l;
                this.c = timeUnit;
            }

            @Override
            public final void run() {
                ScheduledFuture<?> scheduledFuture = this.d.a.scheduleAtFixedRate(this.a, 0L, this.b, this.c);
                if (this.d.d.containsKey(this.a.getTaskName())) {
                    try {
                        ((Future)this.d.d.get(this.a.getTaskName())).cancel(true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.d.d.put(this.a.getTaskName(), scheduledFuture);
            }
        }, l2, TimeUnit.MILLISECONDS);
    }

    public void scheduleWorkAfterDelay(Work work, long l, TimeUnit timeUnit) {
        this.cancelWork(work.getTaskName());
        try {
            this.a.schedule(work, l, timeUnit);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("BasicScheduler.work:" + work + ", delay:" + this.a);
            return;
        }
    }

    public synchronized void stop() {
        try {
            for (String string : this.d.keySet()) {
                try {
                    this.d.get(string).cancel(true);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        this.d.clear();
        if (this.a != null) {
            this.a.shutdownNow();
        }
        System.out.println("basic scheduler stopped");
        this.a = null;
        b = null;
    }

    public List<ItemBean> createWeeklySchedule(String string, int n, int n2, int n3) {
        ArrayList<ItemBean> arrayList = new ArrayList<ItemBean>();
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            int n5 = NumberUtil.getRandomNumber(1, 7);
            int n6 = NumberUtil.getRandomNumber(n2, n3);
            ItemBean itemBean = new ItemBean(string + "-" + n5 + "-" + n6 + "-" + n4++, PROPS.JOB.toString());
            itemBean.setProperty(PROPS.DAYOFWEEK.toString(), n5);
            itemBean.setProperty(PROPS.HOUR.toString(), n6);
            arrayList.add(itemBean);
        }
        return arrayList;
    }

    public List<ItemBean> createDailySchedule(String string, int n, int n2, int n3, int n4) {
        ArrayList<ItemBean> arrayList = new ArrayList<ItemBean>();
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            int n6 = NumberUtil.getRandomNumber(n3, n4);
            ItemBean itemBean = new ItemBean(string + "-" + n2 + "-" + n6 + "-" + n5++, PROPS.JOB.toString());
            itemBean.setProperty(PROPS.DAYOFWEEK.toString(), n2);
            itemBean.setProperty(PROPS.HOUR.toString(), n6);
            arrayList.add(itemBean);
        }
        return arrayList;
    }

    public void cancelWork(String string) {
        try {
            this.d.get(string).cancel(true);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static enum PROPS {
        JOB,
        DAYOFWEEK,
        HOUR;

    }
}

