/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.common.util;

import com.binfer.common.util.IProgressUpdateHandler;
import com.binfer.common.util.ItemBean;
import com.binfer.common.util.NumberUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class FileUtil {
    private static int a = 102;
    private static final char[] b;
    private static final int[] c;

    public static double bytesToMB(long l, SIZE_UNIT sIZE_UNIT) {
        double d = 1.0;
        switch (sIZE_UNIT) {
            case KB: {
                d = 1024.0;
                break;
            }
            case MB: {
                d = 1048576.0;
                break;
            }
            case GB: {
                d = 1.073741824E9;
            }
        }
        return (double)l / d;
    }

    public static String bytesToFriendlyString(long l) {
        try {
            if ((double)l > 1.073741824E9) {
                return Math.round((double)l / 1.073741824E9) + " GB";
            }
            if ((double)l > 1048576.0) {
                return Math.round((double)l / 1048576.0) + " MB";
            }
            if (l > 1024L) {
                return Math.round((double)l / 1024.0) + " KB";
            }
            return l + " bytes";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String bytesToFriendlyString(long l, int n) {
        try {
            if ((double)l > 1.073741824E9) {
                return NumberUtil.round((double)l / 1.073741824E9, 2) + " GB";
            }
            if ((double)l > 1048576.0) {
                return NumberUtil.round((double)l / 1048576.0, 2) + " MB";
            }
            if (l > 1024L) {
                return NumberUtil.round((double)l / 1024.0, 2) + " KB";
            }
            return l + " bytes";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void saveBean(String object, ItemBean itemBean) throws Exception {
        object = new File((String)object);
        ((File)object).createNewFile();
        object = new FileOutputStream((File)object);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
        objectOutputStream.writeObject(itemBean);
        objectOutputStream.close();
        ((FileOutputStream)object).close();
    }

    public static ItemBean loadBean(String object) throws Exception {
        FileInputStream fileInputStream = new FileInputStream((String)object);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        object = (ItemBean)objectInputStream.readObject();
        objectInputStream.close();
        fileInputStream.close();
        return object;
    }

    public static void saveObject(File object, Object object2) throws Exception {
        ((File)object).createNewFile();
        object = new FileOutputStream((File)object);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
        objectOutputStream.writeObject(object2);
        objectOutputStream.close();
        ((FileOutputStream)object).close();
    }

    public static Object loadObject(File object) throws Exception {
        FileInputStream fileInputStream = new FileInputStream((File)object);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        object = objectInputStream.readObject();
        objectInputStream.close();
        fileInputStream.close();
        return object;
    }

    public static File createDataDir(String object) {
        try {
            object = new File((String)object);
            ((File)object).mkdirs();
            return ((File)object).getCanonicalFile();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void getFilesRecursive(File fileArray, Collection<File> collection) {
        try {
            Thread.yield();
            for (File file : fileArray.listFiles()) {
                if (file.isDirectory()) {
                    FileUtil.getFilesRecursive(file, collection);
                    continue;
                }
                if (file.length() <= 0L) continue;
                collection.add(file);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void deleteRecursive(String object) {
        try {
            object = new File((String)object).getCanonicalFile();
            for (String string : ((File)object).list()) {
                File object2 = new File((File)object, string);
                if (object2.isDirectory()) {
                    FileUtil.deleteRecursive(object2.getCanonicalPath());
                    continue;
                }
                object2.delete();
            }
            ((File)object).delete();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void copyFiles(File fileArray, File file) {
        if (fileArray.isFile()) {
            File file2 = new File(file, fileArray.getName());
            try {
                FileUtil.copyFile((File)fileArray, file2);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        File[] fileArray2 = fileArray.listFiles();
        if (fileArray2 != null && fileArray2.length > 0) {
            fileArray = fileArray2;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File file3;
                File file4 = fileArray[i];
                if (file4.isDirectory()) {
                    file3 = new File(file, file4.getName());
                    file3.mkdirs();
                    FileUtil.copyFiles(file4, file3);
                    continue;
                }
                file3 = new File(file, file4.getName());
                try {
                    FileUtil.copyFile(file4, file3);
                    continue;
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void copyFile(File file, File file2) throws Exception {
        AbstractInterruptibleChannel abstractInterruptibleChannel;
        block6: {
            if (!file2.exists()) {
                file2.createNewFile();
            }
            FileChannel fileChannel = null;
            abstractInterruptibleChannel = null;
            try {
                fileChannel = new FileInputStream(file).getChannel();
                abstractInterruptibleChannel = new FileOutputStream(file2).getChannel();
                ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
                if (fileChannel == null) break block6;
            }
            catch (Throwable throwable) {
                if (fileChannel != null) {
                    fileChannel.close();
                }
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
                throw throwable;
            }
            fileChannel.close();
        }
        if (abstractInterruptibleChannel != null) {
            abstractInterruptibleChannel.close();
            return;
        }
    }

    public static void joinFile(File file, File file2) throws Exception {
        AbstractInterruptibleChannel abstractInterruptibleChannel;
        block7: {
            long l = 0L;
            if (!file2.exists()) {
                file2.createNewFile();
            } else {
                l = file2.length();
            }
            FileChannel fileChannel = null;
            abstractInterruptibleChannel = null;
            try {
                fileChannel = new FileInputStream(file).getChannel();
                abstractInterruptibleChannel = new FileOutputStream(file2, true).getChannel();
                ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, l, fileChannel.size());
                if (fileChannel == null) break block7;
            }
            catch (Throwable throwable) {
                if (fileChannel != null) {
                    fileChannel.close();
                }
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
                throw throwable;
            }
            fileChannel.close();
        }
        if (abstractInterruptibleChannel != null) {
            abstractInterruptibleChannel.close();
            return;
        }
    }

    public static void copyFileStd(File object, File object2) throws Exception {
        int n;
        object = new FileInputStream((File)object);
        object2 = new FileOutputStream((File)object2);
        byte[] byArray = new byte[1024];
        while ((n = ((FileInputStream)object).read(byArray)) != -1) {
            ((FileOutputStream)object2).write(byArray, 0, n);
        }
        ((FileInputStream)object).close();
        ((FileOutputStream)object2).close();
    }

    public static InputStream getFileIS(String string, Class clazz) {
        InputStream inputStream = null;
        try {
            File file = new File(string);
            inputStream = new FileInputStream(file);
        }
        catch (Exception exception) {
            try {
                inputStream = clazz.getClassLoader().getResourceAsStream(string);
            }
            catch (Exception exception2) {}
        }
        return inputStream;
    }

    public static void writeURLtoFile(URL object, File file) throws Exception {
        object = ((URL)object).openStream();
        FileUtil.writeStreamtoFile((InputStream)object, file);
        ((InputStream)object).close();
    }

    public static void writeStringtoFile(String string, File file) throws Exception {
        FileUtil.writeStreamtoFile(new ByteArrayInputStream(string.getBytes()), file);
    }

    public static void writeStreamtoFile(InputStream closeable, File object) throws Exception {
        ((File)object).createNewFile();
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        object = new FileOutputStream((File)object).getChannel();
        closeable = Channels.newChannel((InputStream)closeable);
        try {
            while (closeable.read(byteBuffer) != -1) {
                byteBuffer.flip();
                ((FileChannel)object).write(byteBuffer);
                byteBuffer.clear();
            }
            byteBuffer.flip();
            while (byteBuffer.hasRemaining()) {
                ((FileChannel)object).write(byteBuffer);
            }
            return;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            ((AbstractInterruptibleChannel)object).close();
        }
    }

    public static void stdWriteStreamtoFile(InputStream inputStream, File object) throws Exception {
        int n;
        object = new FileOutputStream((File)object);
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            ((FileOutputStream)object).write(byArray, 0, n);
        }
        inputStream.close();
        ((FileOutputStream)object).close();
    }

    public static void writeStreamToStream(InputStream inputStream, OutputStream outputStream) {
        byte[] byArray = new byte[1024];
        try {
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeStreamToStream(InputStream closeable, long l, long l2, int n, OutputStream outputStream, IProgressUpdateHandler iProgressUpdateHandler) throws Exception {
        WritableByteChannel writableByteChannel;
        block15: {
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            writableByteChannel = Channels.newChannel(outputStream);
            closeable = Channels.newChannel((InputStream)closeable);
            try {
                int n2 = 0;
                long l3 = l2;
                if (iProgressUpdateHandler != null) {
                    iProgressUpdateHandler.handleUpdate(l, l3, l2);
                }
                while (closeable.read(byteBuffer) != -1) {
                    byteBuffer.flip();
                    long l4 = writableByteChannel.write(byteBuffer);
                    if (l4 == 0L) break;
                    l3 += l4;
                    if ((n2 = (int)((long)n2 + l4)) >= 262144) {
                        n2 = 0;
                        if (iProgressUpdateHandler != null) {
                            iProgressUpdateHandler.handleUpdate(l, l3, l2);
                        }
                        Thread.yield();
                    }
                    outputStream.flush();
                    byteBuffer.clear();
                }
                byteBuffer.flip();
                while (byteBuffer.hasRemaining()) {
                    writableByteChannel.write(byteBuffer);
                }
                if (outputStream == null) break block15;
            }
            catch (Exception exception) {
                try {
                    if (iProgressUpdateHandler != null) {
                        iProgressUpdateHandler.handleUpdate(l, -1L);
                    }
                    throw exception;
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        try {
                            outputStream.flush();
                        }
                        catch (Exception exception2) {}
                    }
                    writableByteChannel.close();
                    closeable.close();
                    throw throwable;
                }
            }
            try {
                outputStream.flush();
            }
            catch (Exception exception) {}
        }
        writableByteChannel.close();
        closeable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeStreamtoFile(File file, long l, long l2, int n, InputStream closeable, IProgressUpdateHandler iProgressUpdateHandler) throws Exception {
        FileOutputStream fileOutputStream;
        long l3 = l2;
        if (!file.exists()) {
            file.createNewFile();
            fileOutputStream = new FileOutputStream(file);
        } else {
            fileOutputStream = new FileOutputStream(file, true);
        }
        if (iProgressUpdateHandler != null && iProgressUpdateHandler.isEncrypted()) {
            FileUtil.writeStreamtoFileSEC(file, l, l2, n, (InputStream)closeable, iProgressUpdateHandler);
            return;
        }
        closeable = new BufferedInputStream((InputStream)closeable, n);
        FileChannel fileChannel = fileOutputStream.getChannel();
        fileChannel.position(l3);
        closeable = Channels.newChannel((InputStream)closeable);
        int n2 = 0;
        try {
            long l4;
            if (iProgressUpdateHandler != null) {
                iProgressUpdateHandler.handleUpdate(l, l3, l2);
            }
            while ((l4 = fileChannel.transferFrom((ReadableByteChannel)closeable, l3, n)) != 0L) {
                l3 += l4;
                if ((n2 = (int)((long)n2 + l4)) < 262144) continue;
                n2 = 0;
                if (iProgressUpdateHandler != null) {
                    iProgressUpdateHandler.handleUpdate(l, l3, l2);
                }
                Thread.yield();
            }
            if (iProgressUpdateHandler != null) {
                iProgressUpdateHandler.handleUpdate(l, l3, l2);
            }
        }
        catch (Throwable throwable) {
            try {
                if (iProgressUpdateHandler != null) {
                    iProgressUpdateHandler.handleUpdate(l, -1L);
                }
                throw new Exception(throwable);
            }
            catch (Throwable throwable2) {
                try {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
                if (fileChannel != null) {
                    try {
                        fileChannel.close();
                    }
                    catch (Exception exception) {
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
                if (closeable != null) {
                    try {
                        closeable.close();
                    }
                    catch (Exception exception) {}
                }
                if (l3 >= l && l3 <= l) {
                    throw throwable2;
                }
                if (l3 > l) {
                    file.delete();
                }
                throw new Exception("FileUtil.writeStreamtoFile.Failed to write file " + file.getName() + " completely.written:" + l3 + ", expected:" + l + ", offset:" + l2);
            }
        }
        try {
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {}
        if (fileChannel != null) {
            try {
                fileChannel.close();
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {}
        }
        if (l3 >= l && l3 <= l) {
            return;
        }
        if (l3 > l) {
            file.delete();
        }
        throw new Exception("FileUtil.writeStreamtoFile.Failed to write file " + file.getName() + " completely.written:" + l3 + ", expected:" + l + ", offset:" + l2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeStreamtoFile1(File comparable, long l, long l2, int n, InputStream closeable, IProgressUpdateHandler iProgressUpdateHandler) throws Exception {
        FileOutputStream fileOutputStream;
        long l3 = 0L;
        if (!((File)comparable).exists()) {
            ((File)comparable).createNewFile();
            fileOutputStream = new FileOutputStream((File)comparable);
        } else {
            fileOutputStream = new FileOutputStream((File)comparable, true);
            l3 = ((File)comparable).length();
        }
        l2 = l3;
        if (iProgressUpdateHandler != null && iProgressUpdateHandler.isEncrypted()) {
            FileUtil.writeStreamtoFileSEC(comparable, l, l2, n, (InputStream)closeable, iProgressUpdateHandler);
            return;
        }
        closeable = new BufferedInputStream((InputStream)closeable, n);
        comparable = ByteBuffer.allocateDirect(n);
        FileChannel fileChannel = fileOutputStream.getChannel();
        fileChannel.position(l3);
        closeable = Channels.newChannel((InputStream)closeable);
        int n2 = 0;
        try {
            if (iProgressUpdateHandler != null) {
                iProgressUpdateHandler.handleUpdate(l, l3, l2);
            }
            while (closeable.read((ByteBuffer)comparable) != -1) {
                ((ByteBuffer)comparable).flip();
                int n3 = fileChannel.write((ByteBuffer)comparable);
                n2 += n3;
                ((ByteBuffer)comparable).compact();
                if ((l3 += (long)n3) >= l) break;
                if (n2 < 262144) continue;
                n2 = 0;
                if (iProgressUpdateHandler != null) {
                    iProgressUpdateHandler.handleUpdate(l, l3, l2);
                }
                Thread.yield();
            }
            ((ByteBuffer)comparable).flip();
            while (((Buffer)((Object)comparable)).hasRemaining()) {
                fileChannel.write((ByteBuffer)comparable);
            }
            if (iProgressUpdateHandler != null) {
                iProgressUpdateHandler.handleUpdate(l, l3, l2);
            }
        }
        catch (Throwable throwable) {
            try {
                if (iProgressUpdateHandler != null) {
                    iProgressUpdateHandler.handleUpdate(l, -1L);
                }
                throw new Exception(throwable);
            }
            catch (Throwable throwable2) {
                try {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
                if (fileChannel != null) {
                    try {
                        fileChannel.close();
                    }
                    catch (Exception exception) {
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
                if (closeable != null) {
                    try {
                        closeable.close();
                    }
                    catch (Exception exception) {}
                }
                if (l3 < l || l3 > l) {
                    throw new Exception("FileUtil.writeStreamtoFile.Failed to write file completely.written:" + l3 + ", expected:" + l + ", offset:" + l2);
                }
                if (comparable != null) {
                    ((ByteBuffer)comparable).clear();
                }
                throw throwable2;
            }
        }
        try {
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {}
        if (fileChannel != null) {
            try {
                fileChannel.close();
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {}
        }
        if (l3 < l || l3 > l) {
            throw new Exception("FileUtil.writeStreamtoFile.Failed to write file completely.written:" + l3 + ", expected:" + l + ", offset:" + l2);
        }
        if (comparable != null) {
            ((ByteBuffer)comparable).clear();
            return;
        }
    }

    public static void writeFileToStreamSEC(File file, long l, int n, OutputStream outputStream, IProgressUpdateHandler iProgressUpdateHandler) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.skip(l);
        File file2 = file;
        FileUtil.secureIO(file2, file2.length(), l, n, fileInputStream, outputStream, iProgressUpdateHandler, 1);
    }

    public static void writeStreamtoFileSEC(File file, long l, long l2, int n, InputStream inputStream, IProgressUpdateHandler iProgressUpdateHandler) throws Exception {
        long l3;
        FileOutputStream fileOutputStream;
        if (!file.exists()) {
            file.createNewFile();
            fileOutputStream = new FileOutputStream(file);
        } else {
            fileOutputStream = new FileOutputStream(file, true);
            l3 = file.length();
            if (l2 != l3) {
                return;
            }
        }
        FileUtil.secureIO(file, l, l2, n, inputStream, fileOutputStream, iProgressUpdateHandler, 2);
        l3 = file.length();
        if (l3 < l || l3 > l) {
            throw new Exception("FileUtil.writeStreamtoFileSEC.Failed to write file completely.written:" + l3 + ", expected:" + l);
        }
    }

    public static void secureIO(File object, long l, long l2, int n, InputStream inputStream, OutputStream outputStream, IProgressUpdateHandler iProgressUpdateHandler, int n2) throws Exception {
        long l3 = l2;
        try {
            int n3;
            object = new byte[]{125, 96, 67, 95, 2, -23, -32, -82};
            Object object2 = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            object = new PBEKeySpec(iProgressUpdateHandler.getCode().toCharArray(), (byte[])object, 2048, 128);
            object = ((SecretKeyFactory)object2).generateSecret((KeySpec)object);
            object = new SecretKeySpec(object.getEncoded(), "AES");
            object2 = iProgressUpdateHandler.getCode().getBytes("UTF-8");
            object2 = new byte[]{(byte)object2[0], 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, (byte)object2[1]};
            object2 = new IvParameterSpec((byte[])object2);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            switch (n2) {
                case 1: {
                    cipher.init(1, (Key)object, (AlgorithmParameterSpec)object2);
                    outputStream = new CipherOutputStream(outputStream, cipher);
                    break;
                }
                case 2: {
                    cipher.init(2, (Key)object, (AlgorithmParameterSpec)object2);
                    inputStream = new CipherInputStream(inputStream, cipher);
                }
            }
            object = new byte[512];
            n2 = 0;
            if (iProgressUpdateHandler != null) {
                iProgressUpdateHandler.handleUpdate(l, l3, l2);
            }
            while ((n3 = inputStream.read((byte[])object)) >= 0) {
                outputStream.write((byte[])object, 0, n3);
                l3 += (long)n3;
                if ((n2 += n3) < 262144) continue;
                n2 = 0;
                if (iProgressUpdateHandler != null) {
                    iProgressUpdateHandler.handleUpdate(l, l3, l2);
                }
                Thread.yield();
            }
            if (iProgressUpdateHandler != null) {
                iProgressUpdateHandler.handleUpdate(l, l3, l2);
            }
            return;
        }
        catch (Exception exception) {
            if (iProgressUpdateHandler != null) {
                iProgressUpdateHandler.handleUpdate(l, -1L);
            }
            throw new Exception(exception);
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
    }

    public static void secureIO1(long l, long l2, int n, InputStream inputStream, OutputStream outputStream, IProgressUpdateHandler iProgressUpdateHandler, int n2) throws Exception {
        long l3 = l2;
        try {
            int n3;
            Object object = new byte[]{125, 96, 67, 95, 2, -23, -32, -82};
            Object object2 = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            object = new PBEKeySpec(iProgressUpdateHandler.getCode().toCharArray(), (byte[])object, 2048, 128);
            object = ((SecretKeyFactory)object2).generateSecret((KeySpec)object);
            object = new SecretKeySpec(object.getEncoded(), "AES");
            object2 = iProgressUpdateHandler.getCode().getBytes("UTF-8");
            object2 = new byte[]{(byte)object2[0], 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, (byte)object2[1]};
            object2 = new IvParameterSpec((byte[])object2);
            Cipher cipher = Cipher.getInstance("AES/CFB/PKCS5Padding");
            switch (n2) {
                case 1: {
                    cipher.init(1, (Key)object, (AlgorithmParameterSpec)object2);
                    outputStream = new DataOutputStream(outputStream);
                    break;
                }
                case 2: {
                    cipher.init(2, (Key)object, (AlgorithmParameterSpec)object2);
                    inputStream = new DataInputStream(inputStream);
                }
            }
            int n4 = cipher.getBlockSize();
            n2 = cipher.getOutputSize(n4);
            object2 = new byte[n4];
            byte[] byArray = new byte[n2];
            if (iProgressUpdateHandler != null) {
                iProgressUpdateHandler.handleUpdate(l, l3, l2);
            }
            while ((n3 = inputStream.read((byte[])object2)) == n4) {
                n3 = cipher.update((byte[])object2, 0, n4, byArray);
                outputStream.write(byArray, 0, n3);
                l3 += (long)n3;
            }
            byArray = n3 > 0 ? cipher.doFinal((byte[])object2, 0, n3) : cipher.doFinal();
            l3 += (long)byArray.length;
            outputStream.write(byArray);
            if (iProgressUpdateHandler != null) {
                iProgressUpdateHandler.handleUpdate(l, l3, l2);
            }
            outputStream.flush();
            outputStream.close();
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFileToStream(File object, long l, int n, OutputStream outputStream, IProgressUpdateHandler iProgressUpdateHandler) throws Exception {
        block21: {
            if (iProgressUpdateHandler != null && iProgressUpdateHandler.isEncrypted()) {
                FileUtil.writeFileToStreamSEC((File)object, l, n, outputStream, iProgressUpdateHandler);
                return;
            }
            long l2 = ((File)object).length();
            object = new RandomAccessFile((File)object, "r").getChannel();
            WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);
            try {
                long l3;
                int n2 = 0;
                long l4 = l;
                if (iProgressUpdateHandler != null) {
                    iProgressUpdateHandler.handleUpdate(l2, l4, l);
                }
                while ((l3 = ((FileChannel)object).transferTo(l4, n, writableByteChannel)) != 0L) {
                    l4 += l3;
                    if ((n2 = (int)((long)n2 + l3)) >= 262144) {
                        n2 = 0;
                        if (iProgressUpdateHandler != null) {
                            iProgressUpdateHandler.handleUpdate(l2, l4, l);
                        }
                        Thread.yield();
                    }
                    outputStream.flush();
                }
                if (iProgressUpdateHandler != null) {
                    iProgressUpdateHandler.handleUpdate(l2, l4, l);
                }
                outputStream.flush();
                if (outputStream == null) break block21;
            }
            catch (Exception exception) {
                try {
                    if (iProgressUpdateHandler == null) throw exception;
                    iProgressUpdateHandler.handleUpdate(l2, -1L);
                    throw exception;
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        try {
                            outputStream.flush();
                        }
                        catch (Exception exception2) {}
                    }
                    if (object == null) throw throwable;
                    try {
                        ((AbstractInterruptibleChannel)object).close();
                        throw throwable;
                    }
                    catch (Exception exception3) {
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
            }
            try {
                outputStream.flush();
            }
            catch (Exception exception) {}
        }
        if (object == null) return;
        try {
            ((AbstractInterruptibleChannel)object).close();
            return;
        }
        catch (Exception exception) {
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public static void writeFileToStreamStd(File object, long l, int n, OutputStream outputStream, IProgressUpdateHandler iProgressUpdateHandler) throws Exception {
        if (iProgressUpdateHandler != null && iProgressUpdateHandler.isEncrypted()) {
            FileUtil.writeFileToStreamSEC((File)object, l, n, outputStream, iProgressUpdateHandler);
            return;
        }
        long l2 = ((File)object).length();
        long l3 = l;
        byte[] byArray = new byte[n];
        object = new FileInputStream((File)object);
        ((FileInputStream)object).skip(l);
        int n2 = 0;
        try {
            int n3;
            while ((n3 = ((FileInputStream)object).read(byArray, 0, n)) != -1) {
                outputStream.write(byArray, 0, n3);
                l3 += (long)n3;
                if (iProgressUpdateHandler != null) {
                    iProgressUpdateHandler.handleUpdate(l2, l3, l);
                }
                if (n2++ <= 50) continue;
                n2 = 0;
                Thread.yield();
            }
            return;
        }
        catch (Throwable throwable) {
            if (iProgressUpdateHandler != null) {
                iProgressUpdateHandler.handleUpdate(l2, -1L, l);
            }
            return;
        }
        finally {
            ((FileInputStream)object).close();
            if (outputStream != null) {
                outputStream.flush();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFileToStream1(File object, long l, int n, OutputStream outputStream, IProgressUpdateHandler iProgressUpdateHandler) throws Exception {
        ByteBuffer byteBuffer;
        block26: {
            FileChannel fileChannel = null;
            byteBuffer = null;
            long l2 = ((File)object).length();
            try {
                fileChannel = new FileInputStream((File)object).getChannel();
                object = Channels.newChannel(outputStream);
                fileChannel.position(l);
                byteBuffer = ByteBuffer.allocateDirect(n);
                int n2 = 0;
                long l3 = l;
                if (iProgressUpdateHandler != null) {
                    iProgressUpdateHandler.handleUpdate(l2, l3, l);
                }
                while (fileChannel.read(byteBuffer) != -1) {
                    byteBuffer.flip();
                    n = object.write(byteBuffer);
                    l3 += (long)n;
                    byteBuffer.compact();
                    if ((n2 += n) < 262144) continue;
                    n2 = 0;
                    if (iProgressUpdateHandler == null) continue;
                    iProgressUpdateHandler.handleUpdate(l2, l3, l);
                }
                try {
                    byteBuffer.flip();
                    while (byteBuffer.hasRemaining()) {
                        object.write(byteBuffer);
                    }
                }
                catch (Exception exception) {}
                if (iProgressUpdateHandler != null) {
                    iProgressUpdateHandler.handleUpdate(l2, l3, l);
                }
                outputStream.flush();
                if (fileChannel == null) break block26;
            }
            catch (Exception exception) {
                try {
                    if (iProgressUpdateHandler != null) {
                        iProgressUpdateHandler.handleUpdate(l2, -1L);
                    }
                    throw exception;
                }
                catch (Throwable throwable) {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Exception exception2) {
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.flush();
                        }
                        catch (Exception exception3) {}
                    }
                    if (byteBuffer != null) {
                        byteBuffer.clear();
                    }
                    throw throwable;
                }
            }
            try {
                fileChannel.close();
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        if (outputStream != null) {
            try {
                outputStream.flush();
            }
            catch (Exception exception) {}
        }
        if (byteBuffer != null) {
            byteBuffer.clear();
            return;
        }
    }

    public static void writeStreamtoFileWithFlowControl(File comparable, int n, long l, InputStream closeable, OutputStream outputStream, IProgressUpdateHandler iProgressUpdateHandler, boolean bl) throws Exception {
        block13: {
            FileOutputStream fileOutputStream;
            outputStream = new DataOutputStream(outputStream);
            long l2 = 0L;
            if (!((File)comparable).exists()) {
                ((File)comparable).createNewFile();
                fileOutputStream = new FileOutputStream((File)comparable);
            } else if (bl) {
                fileOutputStream = new FileOutputStream((File)comparable, true);
                l2 = ((File)comparable).length();
            } else {
                fileOutputStream = new FileOutputStream((File)comparable);
            }
            comparable = ByteBuffer.allocateDirect(n);
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileChannel.position(l2);
            closeable = Channels.newChannel((InputStream)closeable);
            try {
                do {
                    ((DataOutputStream)outputStream).writeLong(l2);
                    ((DataOutputStream)outputStream).flush();
                    int n2 = closeable.read((ByteBuffer)comparable);
                    l2 += (long)n2;
                    if (n2 == -1) break;
                    if (iProgressUpdateHandler != null) {
                        iProgressUpdateHandler.handleUpdate(l, l2);
                    }
                    ((ByteBuffer)comparable).flip();
                    fileChannel.write((ByteBuffer)comparable);
                    ((ByteBuffer)comparable).clear();
                } while (l2 < l);
                ((DataOutputStream)outputStream).writeLong(l2);
                if (fileChannel == null) break block13;
            }
            catch (Exception exception) {
                try {
                    throw exception;
                }
                catch (Throwable throwable) {
                    if (fileChannel != null) {
                        fileChannel.close();
                    }
                    if (comparable != null) {
                        ((ByteBuffer)comparable).clear();
                    }
                    throw throwable;
                }
            }
            fileChannel.close();
        }
        if (comparable != null) {
            ((ByteBuffer)comparable).clear();
            return;
        }
    }

    public static void writeFileToStreamWithFlowControl(File file, int n, InputStream inputStream, OutputStream outputStream, IProgressUpdateHandler iProgressUpdateHandler) throws Exception {
        ByteBuffer byteBuffer;
        block11: {
            new DataOutputStream(outputStream);
            inputStream = new DataInputStream(inputStream);
            FileChannel fileChannel = null;
            byteBuffer = null;
            long l = file.length();
            try {
                long l2;
                fileChannel = new FileInputStream(file).getChannel();
                WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);
                byteBuffer = ByteBuffer.allocateDirect(n);
                while ((l2 = ((DataInputStream)inputStream).readLong()) != file.length()) {
                    fileChannel.position(l2);
                    n = fileChannel.read(byteBuffer);
                    if (n == -1) break;
                    l2 += (long)n;
                    if (iProgressUpdateHandler != null) {
                        iProgressUpdateHandler.handleUpdate(l, l2);
                    }
                    byteBuffer.flip();
                    writableByteChannel.write(byteBuffer);
                    outputStream.flush();
                    byteBuffer.clear();
                }
                if (fileChannel == null) break block11;
            }
            catch (Exception exception) {
                try {
                    throw exception;
                }
                catch (Throwable throwable) {
                    if (fileChannel != null) {
                        fileChannel.close();
                    }
                    if (outputStream != null) {
                        outputStream.flush();
                    }
                    if (byteBuffer != null) {
                        byteBuffer.clear();
                    }
                    throw throwable;
                }
            }
            fileChannel.close();
        }
        if (outputStream != null) {
            outputStream.flush();
        }
        if (byteBuffer != null) {
            byteBuffer.clear();
            return;
        }
    }

    public static URI createURIFromString(String object) {
        try {
            object = new URL((String)object);
        }
        catch (Exception exception) {
            return null;
        }
        URI uRI = null;
        try {
            uRI = ((URL)object).toURI();
        }
        catch (Exception exception) {
            try {
                uRI = new URI(((URL)object).getProtocol(), ((URL)object).getUserInfo(), ((URL)object).getHost(), ((URL)object).getPort(), ((URL)object).getPath(), ((URL)object).getQuery(), ((URL)object).getRef());
            }
            catch (Exception exception2) {}
        }
        return uRI;
    }

    public static int readFile(InputStream inputStream, long l, long l2, byte[] byArray, int n) throws IOException {
        if (l2 > l) {
            long l3 = inputStream.skip(l2 - l);
            assert (l3 == l2 - l);
        } else if (l2 < l) {
            return -1;
        }
        return inputStream.read(byArray, 0, n);
    }

    public static byte[] readFileIntoByteArray(File object) throws Exception {
        byte[] byArray = new byte[(int)((File)object).length()];
        object = new DataInputStream(new FileInputStream((File)object));
        ((DataInputStream)object).readFully(byArray);
        ((FilterInputStream)object).close();
        return byArray;
    }

    public static String readFileIntoString(File file) throws Exception {
        return FileUtil.readStreamIntoString(new FileInputStream(file));
    }

    public static String readURLIntoString(URL uRL) throws Exception {
        return FileUtil.readStreamIntoString(uRL.openStream());
    }

    public static String readStreamIntoString(InputStream inputStream) throws Exception {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(131072);
        byte[] byArray = new byte[131072];
        while (-1 != (n = inputStream.read(byArray))) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static String readStreamIntoString1(InputStream object) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        String string = System.getProperty("line.separator");
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            object = "";
            boolean bl = false;
            while (object != null) {
                object = bufferedReader.readLine();
                if (object != null) {
                    if (bl) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append((String)object);
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            throw throwable;
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    public static void getRelativeFilePathsRecursive(String string, File file, Map<String, File> map) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                FileUtil.getRelativeFilePathsRecursive(string.isEmpty() ? file.getName() : string + "/" + file.getName(), file2, map);
            }
            return;
        }
        if (file.length() > 0L) {
            map.put(string.isEmpty() ? file.getName() : string + "/" + file.getName(), file);
        }
    }

    public static char[] base64Encode(byte[] byArray) {
        int n = byArray != null ? byArray.length : 0;
        if (n == 0) {
            return new char[0];
        }
        int n2 = n / 3 * 3;
        int n3 = (n - 1) / 3 + 1 << 2;
        char[] cArray = new char[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2) {
            int n6 = (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
            cArray[n5++] = b[n6 >>> 18 & 0x3F];
            cArray[n5++] = b[n6 >>> 12 & 0x3F];
            cArray[n5++] = b[n6 >>> 6 & 0x3F];
            cArray[n5++] = b[n6 & 0x3F];
        }
        n4 = n - n2;
        if (n4 > 0) {
            n5 = (byArray[n2] & 0xFF) << 10 | (n4 == 2 ? (byArray[n - 1] & 0xFF) << 2 : 0);
            cArray[n3 - 4] = b[n5 >> 12];
            cArray[n3 - 3] = b[n5 >>> 6 & 0x3F];
            cArray[n3 - 2] = n4 == 2 ? b[n5 & 0x3F] : 61;
            cArray[n3 - 1] = 61;
        }
        return cArray;
    }

    public static String base64DecodeToStr(String string) {
        try {
            return new String(FileUtil.base64Decode(string.toCharArray()));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static byte[] base64Decode(char[] cArray) {
        try {
            int n;
            int n2 = cArray != null ? cArray.length : 0;
            if (n2 == 0) {
                return new byte[0];
            }
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                if (c[cArray[n]] >= 0) continue;
                ++n3;
            }
            if ((n2 - n3) % 4 != 0) {
                return null;
            }
            n = 0;
            int n4 = n2;
            while (n4 > 1 && c[cArray[--n4]] <= 0) {
                if (cArray[n4] != '=') continue;
                ++n;
            }
            n4 = ((n2 - n3) * 6 >> 3) - n;
            byte[] byArray = new byte[n4];
            n3 = 0;
            n = 0;
            while (n < n4) {
                int n5 = 0;
                for (int i = 0; i < 4; ++i) {
                    int n6;
                    if ((n6 = c[cArray[n3++]]) >= 0) {
                        n5 |= n6 << 18 - i * 6;
                        continue;
                    }
                    --i;
                }
                byArray[n++] = (byte)(n5 >> 16);
                if (n >= n4) continue;
                byArray[n++] = (byte)(n5 >> 8);
                if (n >= n4) continue;
                byArray[n++] = (byte)n5;
            }
            return byArray;
        }
        catch (Exception exception) {
            return new String(cArray).getBytes();
        }
    }

    public static void zipDirectory(File fileArray, File object) throws Exception {
        object = new FileOutputStream((File)object);
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)object);
        zipOutputStream.setLevel(0);
        for (File file : fileArray.listFiles()) {
            if (!file.isFile()) continue;
            zipOutputStream.putNextEntry(new ZipEntry(file.getName()));
            FileInputStream fileInputStream = new FileInputStream(file);
            FileUtil.writeStreamToStream(fileInputStream, zipOutputStream);
            fileInputStream.close();
            zipOutputStream.closeEntry();
        }
        zipOutputStream.close();
        ((FileOutputStream)object).close();
    }

    public static void createTestFile(File object, int n, long l) throws Exception {
        System.currentTimeMillis();
        object = new FileOutputStream((File)object).getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            int n3 = n2;
            n2 = (byte)(n3 + 1);
            byteBuffer.put((byte)n3);
        }
        long l2 = 0L;
        long l3 = l;
        while (true) {
            if (l3 < (long)n) {
                n2 = ((Number)((long)n - l3)).intValue();
                byteBuffer.position(n2);
            }
            l3 = l - (l2 += (long)((FileChannel)object).write(byteBuffer));
            byteBuffer.rewind();
            if (l2 >= l) break;
            Thread.currentThread();
            Thread.yield();
        }
        ((AbstractInterruptibleChannel)object).close();
    }

    public static boolean deleteFile(File file) {
        boolean bl;
        block6: {
            bl = false;
            try {
                if (file == null || !file.exists()) break block6;
                try {
                    bl = file.delete();
                    if (!bl) {
                        file.deleteOnExit();
                        System.err.println("failed to delete file:" + file.getAbsolutePath() + ", length:" + file.length() + ", modified:" + new Date(file.lastModified()) + ", readable?:" + file.canRead() + ", writable?:" + file.canWrite());
                    }
                }
                catch (Exception exception) {
                    if (file != null) {
                        file.deleteOnExit();
                    }
                    System.err.println("expn.failed to delete file:" + file + ", err:" + exception.getMessage());
                }
            }
            catch (Exception exception) {
                System.err.println("expn2.failed to delete file:" + file + ", err:" + exception.getMessage());
            }
        }
        return bl;
    }

    public static void writeStringToFile(String object, File file) throws Exception {
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(file);
            inputStream = new ByteArrayInputStream(((String)object).getBytes());
            object = new byte[1024];
            while ((n = inputStream.read((byte[])object)) != -1) {
                fileOutputStream.write((byte[])object, 0, n);
            }
        }
        catch (Exception exception) {
            try {
                throw exception;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                throw throwable;
            }
        }
        inputStream.close();
        fileOutputStream.close();
        return;
    }

    public static String getRandomString(int n) {
        String string = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string.charAt(random.nextInt(string.length())));
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        FileUtil.zipDirectory(new File("C:\\Users\\GlobalSoftLink\\GSLProjects\\Common\\gslBinferX\\sample"), new File("c:\\temp\\ax1.zip"));
    }

    static {
        Pattern.compile("(\\.)(jpg|jpeg|jpe|gif|bmp|png|ico)", a);
        b = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        c = new int[256];
        Arrays.fill(c, -1);
        int n = b.length;
        for (int i = 0; i < n; ++i) {
            FileUtil.c[FileUtil.b[i]] = i;
        }
        FileUtil.c[61] = 0;
    }

    public static enum SIZE_UNIT {
        KB,
        MB,
        GB;

    }

    public static enum DOWNLOADMODE {
        OVERRIDE,
        RESUME,
        IGNORE;

    }
}

