/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.common.util;

import com.binfer.common.util.ContentTypes;
import com.binfer.common.util.FileUtil;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

public class ItemBean
implements Serializable {
    static final long serialVersionUID = 1L;
    private Map<String, Object> a = new TreeMap<String, Object>();
    public final Collection<String> readProperties = new HashSet<String>();
    public final Collection<String> hiddenProperties = new HashSet<String>();
    private String b;

    public ItemBean(String string, int n) {
        this(string, Integer.toString(n));
    }

    public ItemBean(String object, String string) {
        this.a.put(PROPS.NAME.toString(), object);
        this.a.put(PROPS.TYPE.toString(), string);
        object = new Date();
        this.a.put(PROPS.LASTMODIFIED.toString(), object);
        this.a.put(PROPS.CREATED.toString(), object);
    }

    public ItemBean(String object, String object2, String string) throws Exception {
        this.a.put(PROPS.NAME.toString(), object);
        this.a.put(PROPS.TYPE.toString(), ((String)object2).toString());
        object = this.setURI(string);
        object2 = new Date();
        try {
            this.a.put(PROPS.CREATED.toString(), new Date(new File((URI)object).lastModified()));
        }
        catch (Exception exception) {
            this.a.put(PROPS.CREATED.toString(), object2);
        }
        this.a.put(PROPS.LASTMODIFIED.toString(), object2);
    }

    public ItemBean(Map map) {
        this.a.putAll(map);
    }

    private String a() {
        if (this.b == null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.a.keySet()) {
                try {
                    stringBuilder.append(this.a.get(string));
                }
                catch (Exception exception) {}
            }
            this.b = stringBuilder.length() == 0 ? UUID.randomUUID().toString() : UUID.nameUUIDFromBytes(stringBuilder.toString().getBytes()).toString();
        }
        return this.b;
    }

    public URI setURI(String string) throws Exception {
        URI uRI = FileUtil.createURIFromString(string);
        if (uRI == null) {
            throw new URISyntaxException(string, "URL is invaid");
        }
        this.a.put(PROPS.URI.toString(), uRI.toString());
        this.a.put(PROPS.MIMETYPE.toString(), ContentTypes.getMimeType(string));
        this.a.put(PROPS.MEDIATYPE.toString(), ContentTypes.getMediaType(string).toString());
        return uRI;
    }

    public ItemBean() {
    }

    public Map<String, Object> getProperties() {
        return this.a;
    }

    public Map<String, String> getPropertiesAsString() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : this.a.keySet()) {
            Object object = this.a.get(string);
            if (object == null) continue;
            if (object instanceof Date) {
                object = ((Date)Date.class.cast(object)).getTime();
            } else if (string.equalsIgnoreCase(PROPS.LASTMODIFIED.name()) || string.equalsIgnoreCase(PROPS.CREATED.name())) {
                try {
                    long l = Long.parseLong(object.toString());
                    object = new Date(l);
                }
                catch (Exception exception) {}
            }
            hashMap.put(string, object.toString());
        }
        return hashMap;
    }

    public void setProperty(String string, Object object) {
        try {
            this.a.put(string, object);
            return;
        }
        catch (Exception exception) {
            System.out.println("EXPN.ItemBean.setProperty.key:" + string + ", val:" + object + ", err:" + exception.getMessage());
            return;
        }
    }

    public void modifyProperty(String string, Object object) throws Exception {
        this.a.put(string, object);
        this.a.put(PROPS.LASTMODIFIED.toString(), new Date());
    }

    public Object getProperty(String string) {
        return this.a.get(string);
    }

    public void removeProperty(String string) {
        this.a.remove(string);
    }

    public boolean hasProperty(String string) {
        return this.a.containsKey(string);
    }

    public String getName() {
        return (String)this.a.get(PROPS.NAME.toString());
    }

    public String getType() {
        if (this.a.containsKey(PROPS.TYPE.toString())) {
            return this.a.get(PROPS.TYPE.toString()).toString();
        }
        return "UNKNOWN";
    }

    public String getPath() {
        if (this.a.containsKey(PROPS.PATH.toString())) {
            return this.a.get(PROPS.PATH.toString()).toString();
        }
        return "";
    }

    public String getDescription() {
        if (this.a.containsKey(PROPS.DESCRIPTION.toString())) {
            return this.a.get(PROPS.DESCRIPTION.toString()).toString();
        }
        return "";
    }

    public URI getURI() {
        try {
            return new URI(this.a.get(PROPS.URI.toString()).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String createUID() {
        this.a.put(PROPS.UID.toString(), UUID.randomUUID().toString());
        return this.getProperty(PROPS.UID.toString()).toString();
    }

    public String getUID() {
        return (String)this.a.get(PROPS.UID.toString());
    }

    public int hashCode() {
        return this.a().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ItemBean) {
            return this.a().equals(((ItemBean)ItemBean.class.cast(object)).a());
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.a != null) {
            for (String string : this.a.keySet()) {
                try {
                    stringBuilder.append("[".concat(String.valueOf(string)));
                    stringBuilder.append(":");
                    stringBuilder.append(this.a.get(string));
                    stringBuilder.append("]");
                }
                catch (Exception exception) {
                    stringBuilder.append("[EXPN.for key:");
                    stringBuilder.append(string);
                    stringBuilder.append("]");
                }
            }
        } else {
            stringBuilder.append("properties map is null!!");
        }
        return stringBuilder.toString();
    }

    public ItemBean clone() {
        ItemBean itemBean = new ItemBean();
        itemBean.getProperties().putAll(this.a);
        return itemBean;
    }

    public String getParentPath() {
        return ItemBean.getParentPath(this.getPath());
    }

    public void setHiddenProperties(Collection<String> collection) {
        this.hiddenProperties.addAll(collection);
    }

    public void setReadOnlyProps(Collection<String> collection) {
        this.readProperties.addAll(collection);
    }

    public Collection<String> getHiddenProperties() {
        return this.hiddenProperties;
    }

    public Collection<String> getReadOnlyProperties() {
        return this.readProperties;
    }

    public boolean isPropertyHidden(String string) {
        return this.hiddenProperties.contains(string);
    }

    public boolean isPropertyReadOnly(String string) {
        return this.readProperties.contains(string);
    }

    public void setAllPropertiesReadOnly() {
        for (String string : this.a.keySet()) {
            this.readProperties.add(string);
        }
    }

    public void removeReadOnlyProperty(String string) {
        this.readProperties.remove(string);
    }

    public String toXML(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(string).append(">");
        for (Map.Entry<String, Object> entry : this.a.entrySet()) {
            Object object;
            if (this.hiddenProperties.contains(entry.getKey()) || (object = entry.getValue()) == null) continue;
            if (object instanceof Date) {
                object = ((Date)Date.class.cast(object)).getTime();
            }
            stringBuilder.append("<").append(entry.getKey()).append("><![CDATA[").append(object).append("]]></").append(entry.getKey()).append(">");
        }
        stringBuilder.append("</").append(string).append(">");
        return stringBuilder.toString();
    }

    public static String getParentPath(String string) {
        int n = string.lastIndexOf("/");
        return string.substring(0, n);
    }

    public static String itemBeanToXML(ItemBean object, String string, Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, Object> map = ((ItemBean)object).getProperties();
        if (((ItemBean)object).getProperty(string) != null) {
            string = ((ItemBean)object).getProperty(string).toString();
        }
        stringBuilder.append("<").append(string).append(">");
        for (String string2 : map.keySet()) {
            Object object2;
            if (collection.contains(string2) || (object2 = map.get(string2)) == null) continue;
            if (object2 instanceof Date) {
                object2 = ((Date)Date.class.cast(object2)).getTime();
            }
            stringBuilder.append("<").append(string2).append("><![CDATA[").append(object2).append("]]></").append(string2).append(">");
        }
        stringBuilder.append("</").append(string).append(">");
        return stringBuilder.toString();
    }

    public static List<Map> collectionBeansToListMap(Collection<ItemBean> object) {
        ArrayList<Map> arrayList = new ArrayList<Map>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            ItemBean itemBean = (ItemBean)object.next();
            try {
                arrayList.add(itemBean.a);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    public static List<Map<String, String>> beansToStringMaps(List<ItemBean> object) {
        LinkedList<Map<String, String>> linkedList = new LinkedList<Map<String, String>>();
        object = object.iterator();
        while (object.hasNext()) {
            ItemBean itemBean = (ItemBean)object.next();
            try {
                linkedList.add(itemBean.getPropertiesAsString());
            }
            catch (Exception exception) {}
        }
        return linkedList;
    }

    public Date getPropertyAsDate(String string) {
        Date date = null;
        if (this.a.get(string) != null && this.a.get(string).toString().length() > 0) {
            date = this.a.get(string) instanceof Date ? (Date)Date.class.cast(this.a.get(string)) : new Date(Long.parseLong(this.a.get(string).toString()));
        }
        return date;
    }

    public static void main(String[] object) throws Exception {
        object = ItemBean.getParentPath("/a/b/c");
        object = ((String)object).substring(((String)object).lastIndexOf("/") + 1, ((String)object).length());
        System.out.println("Parent path of:".concat(String.valueOf(object)));
    }

    public static enum PROPS {
        NAME,
        TYPE,
        UID,
        URI,
        CREATED,
        LASTMODIFIED,
        OWNER,
        LASTMODIFIEDBY,
        MIMETYPE,
        MEDIATYPE,
        CONTENT,
        CONTENTITEM,
        CONTENTITEMCONTAINER,
        RESOURCES,
        LINKS,
        LINK,
        LINKNAME,
        SIZE,
        DESCRIPTION,
        PATH,
        INTERNALSTREAM,
        BASETYPE,
        CHILDCOUNT,
        CHILDFOLDERCOUNT,
        CHILDITEMCOUNT,
        ISCHECKEDOUT,
        VERSION,
        HASPOLICYSET,
        PARENTPATH,
        REFERENCE,
        LASTSYNC,
        LICENSE,
        ENCRYPTION_MODE,
        META_DATA;

    }
}

