/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.common.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Random;

public class NumberUtil {
    private static final NumberFormat a = NumberFormat.getInstance();
    private static final DecimalFormat b = new DecimalFormat("###.##");
    private static Random c = new Random();

    public static int getRandomNumber(int n, int n2) {
        n2 = (int)(Math.random() * (double)(n2 + 1 - n)) + n;
        if (n2 == 0) {
            n2 = n;
        }
        return n2;
    }

    public static double getRandomDouble(double d, double d2) {
        double d3 = Math.random() * (d2 - d + 1.0) + d;
        if (d3 == 0.0) {
            d3 = d;
        }
        return d3;
    }

    public static Long getLongNumber(String string) throws Exception {
        return a.parse(string).longValue();
    }

    public static double calculatePercentage(Number number, Number number2) {
        if (number == null || number2 == null) {
            return 0.0;
        }
        try {
            return NumberUtil.round(number.doubleValue() * 100.0 / number2.doubleValue(), 2);
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    public static double round(Number number, int n) {
        DecimalFormat decimalFormat;
        if (n == 2) {
            decimalFormat = b;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("###.");
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("#");
            }
            decimalFormat = new DecimalFormat(stringBuilder.toString());
        }
        return Double.valueOf(decimalFormat.format(number));
    }

    public static String getRandomString(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(c.nextInt(36)));
        }
        return stringBuilder.toString();
    }

    public static String getUnique(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        stringBuilder.append(calendar.get(6)).append(NumberUtil.getRandomString(n));
        return stringBuilder.toString();
    }

    public static void main(String[] object) throws Exception {
        object = new HashSet();
        int n = 0;
        for (int i = 0; i < 500000; ++i) {
            String string = NumberUtil.getRandomString(6);
            if (object.contains(string)) {
                System.err.println("Duplicate found.i:" + i + ", " + string);
                ++n;
                continue;
            }
            object.add(string);
            System.out.println(String.valueOf(string));
        }
        System.out.println("DUPES:".concat(String.valueOf(n)));
    }
}

