/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.common.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegEx {
    public static final String EMAIL = "[a-z0-9\\-_\\.]++@[a-z0-9\\-]++(\\.[a-z0-9\\-]++)++";
    public static final Pattern EMAIL_PATTERN = Pattern.compile("[a-z0-9\\-_\\.]++@[a-z0-9\\-]++(\\.[a-z0-9\\-]++)++", 35);
    public static final String DOMAINNAME = "\\b((http://|http://www|www|https://|https://www)[a-zA-Z0-9\\-\\.]+\\.[a-zA-Z]{2,3})\\b";
    public static final String DOMAINNAMESHORT = "([a-zA-Z0-9\\-\\.]+\\.[a-zA-Z]{2,})";
    public static final String DOMAINNAMEPREFIX = "http://www.|https://www.|http://|https://|www.";
    public static final Pattern DOMAIN_PATTERN = Pattern.compile("\\b((http://|http://www|www|https://|https://www)[a-zA-Z0-9\\-\\.]+\\.[a-zA-Z]{2,3})\\b", 35);
    public static final Pattern DOMAINNAMESHORT_PATTERN = Pattern.compile("([a-zA-Z0-9\\-\\.]+\\.[a-zA-Z]{2,})", 35);
    public static final String compactPattern = "(" + System.getProperty("line.separator") + "|\n|\n\r)";
    public static final String compactLessSpacePattern = "(" + System.getProperty("line.separator") + "|\\s{2,})";
    public static final String superCompactPattern = "(" + System.getProperty("line.separator") + "|\\s|\n|\n\r)";
    public static final String compactHTMLPattern = ";|&rsaquo|<span\\sclass=\"bc\">|<span\\sclass=bc>|<spanclass=bc>|<spanclass=\"bc\">|\\<b\\>|\\</b\\>|<strong>|</strong>|\\s|\n|\n\r|%20|&nbsp;|\\&quot|\\&quot;";
    public static final String HTMLTAGS = "(&lt;.*?&gt;)|(<.*?>)|(#|\\.).*?\\}|(\\{.*?\\})|(&amp;|nbsp;)";
    public static final String HTMLTAGS1 = "(<(\\s|.|\n)*?>|&nbsp;)";
    public static final String COMPACTTEXT = "\\s{2,}|\n|\t|%20";

    public static Collection<String> extract(String object, Pattern object2, int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        object = ((Pattern)object2).matcher((CharSequence)object);
        while (((Matcher)object).find()) {
            object2 = ((Matcher)object).group(n).trim().toLowerCase();
            if (linkedList.contains(object2)) continue;
            linkedList.add((String)object2);
        }
        return linkedList;
    }

    public static String extractSingle(String string, String string2, int n) {
        return RegEx.extractSingle(string, Pattern.compile(string2, 35), n);
    }

    public static String extractSingle(String object, Pattern pattern, int n) {
        if (((Matcher)(object = pattern.matcher((CharSequence)object))).find()) {
            return ((Matcher)object).group(n).trim();
        }
        return "";
    }

    public static List<String[]> extractMultipleIndexes(String object, Pattern stringArray, int[] nArray) {
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        object = stringArray.matcher((CharSequence)object);
        while (((Matcher)object).find()) {
            stringArray = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                stringArray[i] = ((Matcher)object).group(nArray[i]).trim();
            }
            linkedList.add(stringArray);
        }
        return linkedList;
    }

    public static boolean isValid(String string, Pattern pattern) {
        return pattern.matcher(string).find();
    }

    public static boolean containsPattern(String string, String string2) {
        return RegEx.isValid(string, Pattern.compile(string2, 35));
    }

    public static boolean containsPattern(String string, Pattern pattern) {
        return RegEx.isValid(string, pattern);
    }

    public static Pattern createPattern(String string) {
        return Pattern.compile(string, 35);
    }

    public static void main(String[] object) {
        object = RegEx.createPattern("ipho");
        String string = "Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1 (KHTML, like Gecko) CriOS/47.0.2526.70 Mobile/13C71 Safari/601.1.46\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        String string2 = "Nokia5250/10.0.011 (SymbianOS/9.4; U; Series60/5.0 Mozilla/5.0; Profile/MIDP-2.1 Configuration/CLDC-1.1 ) AppleWebKit/525 (KHTML, like Gecko) Safari/525 3gpp-gba\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        String string3 = "Mozilla/5.0 (Linux; U; Tizen 2.0; en-us) AppleWebKit/537.1 (KHTML, like Gecko) Mobile TizenBrowser/2.0\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        String string4 = "Mozilla/5.0 (compatible; MSIE 9.0; Windows Phone OS 7.5; Trident/5.0; IEMobile/9.0)\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        String string5 = "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.73 Safari/537.36\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        String string6 = "Opera/9.80 (Windows NT 6.0) Presto/2.12.388 Version/12.14\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        String string7 = "Mozilla/5.0 (Windows NT 6.3; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        String string8 = "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US) AppleWebKit/533.20.25 (KHTML, like Gecko) Version/5.0.4 Safari/533.20.27\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        System.out.println("ua_iphone:" + RegEx.containsPattern(string, (Pattern)object));
        System.out.println("ua_chrome_windows:" + RegEx.containsPattern(string5, (Pattern)object));
        System.out.println("ua_opera_windows:" + RegEx.containsPattern(string6, (Pattern)object));
        System.out.println("ua_nokia_symbian:" + RegEx.containsPattern(string2, (Pattern)object));
        System.out.println("ua_tizen:" + RegEx.containsPattern(string3, (Pattern)object));
        System.out.println("ua_windowsphone:" + RegEx.containsPattern(string4, (Pattern)object));
        System.out.println("ua_safari_osx:" + RegEx.containsPattern(string7, (Pattern)object));
        System.out.println("ua_safari_win:" + RegEx.containsPattern(string8, (Pattern)object));
    }
}

