/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.common.util;

import com.binfer.common.util.WebUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class StringUtil {
    public static final String STR_EMPTY = "";
    public static final String STR_SPACE = " ";
    public static final String STR_QUOTE = "\"";
    public static final String STR_RBRACKET = "(";
    public static final String STR_LBRACKET = ")";
    private static String a = "...";
    private static String b = System.getProperty("line.separator") + "|\n|\r|\r\n|<br>";

    public static String compactString(String string) {
        return string.replaceAll("\\s{2,}|\n|\t|%20", STR_SPACE).trim();
    }

    public static String stripHTML(String string) {
        return string.replaceAll("(&lt;.*?&gt;)|(<.*?>)|(#|\\.).*?\\}|(\\{.*?\\})|(&amp;|nbsp;)", STR_EMPTY).trim();
    }

    public static Collection<String> stripHTML(Collection<String> object) {
        LinkedList<String> linkedList = new LinkedList<String>();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            linkedList.add(StringUtil.stripHTML(string));
        }
        return linkedList;
    }

    public static String ltrim(String string) {
        return string.replaceAll("^\\s+", STR_EMPTY);
    }

    public static String rtrim(String string) {
        return string.replaceAll("\\s+$", STR_EMPTY);
    }

    public static String itrim(String string) {
        return string.replaceAll("\\b\\s{2,}\\b", STR_SPACE);
    }

    public static String compactString1(String string) {
        return StringUtil.itrim(StringUtil.ltrim(StringUtil.rtrim(string)));
    }

    public static String lrtrim(String string) {
        return StringUtil.ltrim(StringUtil.rtrim(string));
    }

    public static String escapeText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String unescapeText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2 = string.charAt(i);
            try {
                if (n2 == 38) {
                    n2 = string.indexOf(";", i);
                    if (n2 == -1) {
                        stringBuilder.append('&');
                        continue;
                    }
                    if (string.charAt(i + 1) == '#') {
                        int n3 = Integer.parseInt(string.substring(i + 2, n2), 16);
                        stringBuilder.append((char)n3);
                    } else {
                        String string2 = string.substring(i, n2 + 1);
                        if (string2.equals("&amp;")) {
                            stringBuilder.append('&');
                        } else if (string2.equals("&lt;")) {
                            stringBuilder.append('<');
                        } else if (string2.equals("&gt;")) {
                            stringBuilder.append('>');
                        } else if (string2.equals("&quot;")) {
                            stringBuilder.append('\"');
                        } else if (string2.equals("&apos;")) {
                            stringBuilder.append('\'');
                        } else {
                            stringBuilder.append(string2);
                        }
                    }
                    i = n2;
                    continue;
                }
                stringBuilder.append((char)n2);
                continue;
            }
            catch (Exception exception) {
                System.err.println("EXPN.unescapeText:" + exception.getMessage());
            }
        }
        return stringBuilder.toString();
    }

    public static String shorten(String string, int n) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        if (string.length() > n) {
            return string.substring(0, n - 3).concat(a);
        }
        return string;
    }

    public static String shorten(String string, int n, int n2) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        if (string.length() - n > n2) {
            return string.substring(n, n2 - 3).concat(a);
        }
        return string;
    }

    public static List<String> extractLines(String stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            stringArray = stringArray.split(b);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].isEmpty()) continue;
                linkedList.add(stringArray[i].trim());
            }
        }
        catch (Exception exception) {}
        return linkedList;
    }

    public static void main(String[] object) throws Exception {
        object = "http://www.binfer.com/abc";
        System.out.println(WebUtil.extractPath((String)object));
    }
}

