/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.common.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class TimeUtil {
    private static final SimpleDateFormat a = new SimpleDateFormat("dd MMM yy, h:mm a");
    private static final SimpleDateFormat b = new SimpleDateFormat("ddMMMyy");
    private static final SimpleDateFormat c = new SimpleDateFormat("ddHHmmss");
    private static final SimpleDateFormat d = new SimpleDateFormat("dd MMM");
    private static final SimpleDateFormat e = new SimpleDateFormat("h:mma");
    private static final SimpleDateFormat f = new SimpleDateFormat("dd MMM yy");
    private static final SimpleDateFormat g = new SimpleDateFormat("yyyymmddHHmmss");
    private static final SimpleDateFormat h = new SimpleDateFormat("yyyyMMdd'T'HHmm00z");
    public static final long IN_MS_ONE_SEC = 1000L;
    public static final long IN_MS_ONE_MIN = 60000L;
    public static final long IN_MS_ONE_HOUR = 3600000L;
    public static final long IN_MS_ONE_DAY = 86400000L;
    public static final long IN_MS_ONE_WEEK = 604800000L;

    public static String getElapsedTime(Date date) {
        long l = System.currentTimeMillis() - date.getTime();
        if (TimeUnit.MILLISECONDS.toDays(l) > 7L) {
            return a.format(date);
        }
        return TimeUtil.getElapsedTime(l) + " ago";
    }

    public static String getElapsedTime(long l) {
        long l2 = TimeUnit.MILLISECONDS.toSeconds(l);
        long l3 = TimeUnit.MILLISECONDS.toDays(l);
        long l4 = TimeUnit.MILLISECONDS.toHours(l);
        long l5 = TimeUnit.MILLISECONDS.toMinutes(l);
        if (l3 > 1L) {
            return l3 + " days";
        }
        if (l3 == 1L) {
            return l3 + " day";
        }
        if (l4 > 1L) {
            return l4 + " hrs";
        }
        if (l4 == 1L) {
            return l4 + " hr";
        }
        if (l5 > 0L) {
            return l5 + " min";
        }
        return l2 + " sec";
    }

    public static String getElapsedTimeExact(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = TimeUnit.MILLISECONDS.toDays(l);
        if (l2 > 0L) {
            stringBuilder.append(l2).append("d");
            l -= TimeUnit.DAYS.toMillis(l2);
        }
        if ((l2 = TimeUnit.MILLISECONDS.toHours(l)) > 0L) {
            stringBuilder.append(l2).append("h");
            l -= TimeUnit.HOURS.toMillis(l2);
        }
        if ((l2 = TimeUnit.MILLISECONDS.toMinutes(l)) > 0L) {
            stringBuilder.append(l2).append("m");
            l -= TimeUnit.MINUTES.toMillis(l2);
        }
        if ((l2 = TimeUnit.MILLISECONDS.toSeconds(l)) > 0L) {
            stringBuilder.append(l2).append("s");
        }
        return stringBuilder.toString();
    }

    public static long getDaysDiff(Date date, Date date2) {
        long l = date.getTime() - date2.getTime();
        return TimeUnit.MILLISECONDS.toDays(l);
    }

    public static String getSimpleTime(Date date) {
        return a.format(date);
    }

    public static String getShortDate(Date date) {
        return b.format(date);
    }

    public static String getDateHourMinSec() {
        return c.format(new Date());
    }

    public static String getDayMonthTime(Date date) {
        return d.format(date);
    }

    public static String getHour(Date date) {
        return e.format(date);
    }

    public static String getDayMonthYearTime(Date date) {
        return f.format(date);
    }

    public static String getNumbersTime(Date date) {
        return g.format(date);
    }

    public static String getISO8601Time(Date date) {
        return h.format(date);
    }

    public static List<Date> getWeeks(int n) {
        LinkedList<Date> linkedList = new LinkedList<Date>();
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(5, 1);
        calendar.set(2, 0);
        calendar.set(1, n);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        linkedList.add(calendar.getTime());
        for (n = 1; n < calendar.getActualMaximum(3); ++n) {
            calendar.add(5, 7);
            linkedList.add(calendar.getTime());
        }
        return linkedList;
    }

    public static boolean hasTimeElapsed(long l, long l2, TimeUnit timeUnit) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        calendar.add(14, new Long(TimeUnit.MILLISECONDS.convert(l2, timeUnit)).intValue());
        return calendar.getTime().before(new Date());
    }

    public static int dayOfWeekToInt(String object) {
        try {
            object = new SimpleDateFormat("E", Locale.ENGLISH).parse((String)object);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            return calendar.get(7);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static boolean isSameDay(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(date);
        calendar2.setTime(date2);
        return calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    public static void main(String[] object) {
        GregorianCalendar.getInstance().set(7, 7);
        object = GregorianCalendar.getInstance();
        ((Calendar)object).add(5, Integer.MAX_VALUE);
        System.out.println("Time.maxint:2147483647,now:" + ((Calendar)object).getTime() + ", forever:" + new Date(Long.MAX_VALUE).getTime() + ", 1 month in ms:" + TimeUnit.DAYS.toMillis(31L));
    }

    public static LocalDate convertToLocalDateTime(Date date) {
        return new Timestamp(date.getTime()).toLocalDateTime().toLocalDate();
    }

    public static Date convertLocalDateToDate(LocalDate localDate) {
        return java.sql.Date.valueOf(localDate);
    }
}

