/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.common.util;

import com.binfer.common.util.Base64;
import com.binfer.common.util.RegEx;
import com.binfer.common.util.SecUtil;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class WebUtil {
    private static final Pattern a = Pattern.compile("q=(.*?)(&|$)");
    private static final Pattern b;

    public static String encryptParams(String string) {
        try {
            return URLEncoder.encode(new String(new Base64().encode(new SecUtil().enCryptXOR(string, "@br@cad@br@"))), "UTF-8");
        }
        catch (Exception exception) {
            return new String(new Base64().encode(string.getBytes()));
        }
    }

    public static String decryptParams(String string, boolean bl) {
        try {
            if (bl) {
                return new SecUtil().deCryptXOR(new Base64().decode(URLDecoder.decode(string, "UTF-8").toCharArray()), "@br@cad@br@");
            }
            return new SecUtil().deCryptXOR(new Base64().decode(string.toCharArray()), "@br@cad@br@");
        }
        catch (Exception exception) {
            return new Base64().decodeToStr(string);
        }
    }

    public static Map<String, Collection<String>> extractURLParameters(String stringArray) {
        HashMap<String, Collection<String>> hashMap = new HashMap<String, Collection<String>>();
        try {
            stringArray = stringArray.split("\\?");
            if (stringArray.length > 1) {
                stringArray = stringArray[1].split("&");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object = stringArray[i].split("=");
                    String string = URLDecoder.decode(object[0], "UTF-8");
                    String string2 = "";
                    if (((String[])object).length > 1) {
                        string2 = URLDecoder.decode(object[1], "UTF-8");
                    }
                    if ((object = (Collection)hashMap.get(string)) == null) {
                        object = new HashSet();
                        hashMap.put(string, (Collection<String>)object);
                    }
                    object.add(string2);
                }
            }
            return hashMap;
        }
        catch (Exception exception) {
            return hashMap;
        }
        catch (Throwable throwable) {
            return hashMap;
        }
    }

    public static Map<String, Collection<String>> extractQueryParameters(String object) {
        HashMap<String, Collection<String>> hashMap = new HashMap<String, Collection<String>>();
        try {
            if (!object.contains("&")) {
                object = (String)object + "&";
            }
            object = object.split("&");
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i].split("=");
                String string = URLDecoder.decode(object2[0], "UTF-8");
                String string2 = "";
                if (((String[])object2).length > 1) {
                    string2 = URLDecoder.decode(object2[1], "UTF-8");
                }
                if ((object2 = (Collection)hashMap.get(string)) == null) {
                    object2 = new HashSet();
                    hashMap.put(string, (Collection<String>)object2);
                }
                object2.add(string2);
            }
        }
        catch (Exception exception) {}
        return hashMap;
    }

    public static String extractDomainName(String string) {
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (Exception exception) {}
        string = string.replaceAll("http://www.|https://www.|http://|https://|www.", "").trim();
        if (string.contains(":")) {
            string = string.substring(0, string.indexOf(":"));
        }
        try {
            string = string.split("/")[0];
        }
        catch (Exception exception) {}
        String string2 = RegEx.extractSingle(string, RegEx.DOMAINNAMESHORT_PATTERN, 0);
        if (string2 == null || string2.isEmpty()) {
            return string;
        }
        return string2;
    }

    public static String extractPath(String string) {
        try {
            String string2 = string.replaceAll("http://|https://", "").trim();
            return string2.substring(string2.indexOf("/"), string2.length());
        }
        catch (Exception exception) {
            try {
                return new URI(string).getPath();
            }
            catch (Exception exception2) {
                return string;
            }
        }
    }

    public static String extractPathWithoutParams(String string) {
        try {
            String string2 = string.replaceAll("http://|https://", "").trim();
            int n = string2.contains("?") ? string2.indexOf("?") : string2.length();
            String string3 = string2;
            return string3.substring(string3.indexOf("/"), n);
        }
        catch (Exception exception) {
            try {
                return new URI(string).getPath();
            }
            catch (Exception exception2) {
                return string;
            }
        }
    }

    public static String extractReferer(String string) {
        try {
            if (string != null && !string.isEmpty()) {
                URL uRL = new URL(string);
                String string2 = "";
                String string3 = "";
                if (string.contains("google.") || string.contains("bing.") || string.contains("blekko.") || string.contains("duckduckgo.")) {
                    string2 = RegEx.extractSingle(uRL.getQuery(), a, 1);
                } else if (!string.contains("yahoo")) {
                    if (string.contains("q=")) {
                        string2 = RegEx.extractSingle(uRL.getQuery(), a, 1);
                    }
                    string3 = uRL.getPath();
                }
                string2 = string2.replaceAll("%20", " ").replaceAll("\\+", " ");
                string = uRL.getProtocol() + "://" + uRL.getHost() + string3 + (string2.isEmpty() ? "" : "|".concat(String.valueOf(string2)));
            }
            return string;
        }
        catch (Exception exception) {
            return string;
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public static boolean isBOTUA(String string) {
        boolean bl = false;
        try {
            bl = RegEx.containsPattern(string, b);
        }
        catch (Exception exception) {}
        return bl;
    }

    public static String getOSBrowserFromUA(String object) {
        object = RegEx.createPattern("^([^/[:space:]]*)(/([^[:space:]]*))?([[:space:]]*\\[[a-zA-Z][a-zA-Z]\\])?[[:space:]]*(\\\\((([^()]|(\\\\([^()]*\\\\)))*)\\\\))?[[:space:]]*");
        String string = "Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; MDDCJS; rv:11.0) like Gecko";
        ((Pattern)object).matcher(string);
        System.out.println("match:" + RegEx.extractSingle(string, (Pattern)object, 3));
        return "";
    }

    public static String getOSFromUA(String string) {
        String string2 = "Other";
        if (WebUtil.isBOTUA(string = string.toLowerCase())) {
            string2 = "Bot";
        } else if (string.indexOf("windows phone") >= 0) {
            string2 = "Windows Phone";
        } else if (string.indexOf("windows") >= 0) {
            string2 = "Windows";
        } else if (string.indexOf("mac") >= 0) {
            string2 = string.indexOf("iphone") >= 0 ? "iPhone" : (string.indexOf("ipad") >= 0 ? "iPad" : "Mac");
        } else if (string.indexOf("x11") >= 0 || string.indexOf("Linux") >= 0) {
            string2 = "Unix";
        } else if (string.indexOf("android") >= 0) {
            string2 = "Android";
        } else if (string.indexOf("iphone") >= 0) {
            string2 = "iPhone";
        } else if (string.indexOf("ipad") >= 0) {
            string2 = "iPad";
        } else if (string.indexOf("BlackBerry") >= 0 && string.indexOf("WebKit") >= 0) {
            string2 = "Blackberry";
        }
        return string2;
    }

    public static String getBrowserFromUA(String string) {
        String string2 = "Other";
        if ((string = string.toLowerCase()).contains("chrome")) {
            string2 = "Chrome";
        } else if (string.contains("firefox")) {
            string2 = "Firefox";
        } else if (string.contains("msie") || string.contains("trident")) {
            string2 = "IE";
        } else if (string.contains("safari")) {
            string2 = "Safari";
        } else if (string.contains("opr") || string.contains("opera")) {
            string2 = "Opera";
        }
        return string2;
    }

    public static int calculatePostContentLength(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            try {
                String string2 = URLEncoder.encode(map.get(string), "UTF-8");
                stringBuilder.append(string).append("=").append(string2);
            }
            catch (Exception exception) {
                stringBuilder.append(string).append("=").append(map.get(string));
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append("&");
        }
        System.out.println("postcontent:" + stringBuilder.toString());
        return stringBuilder.length();
    }

    public static void main(String[] object) throws Exception {
        object = new URL("https://www.facebook.com/thehiqphotographers?ref=br_rs");
        System.out.println(((URL)object).getProtocol() + "://" + ((URL)object).getHost() + "/" + ((URL)object).getPath());
    }

    static {
        Pattern.compile("p=(.*?)&");
        Pattern.compile("(.*?yahoo\\.com)/");
        b = RegEx.createPattern("alexa|bot|crawl(er|ing)|facebookexternalhit|feedburner|google web preview|nagios|postrank|pingdom|slurp|spider|yahoo!|yandex");
    }
}

