/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLObject {
    private Document a;
    private static final XPath b = XPathFactory.newInstance().newXPath();
    private static final DocumentBuilderFactory c = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory d;
    private Node e;

    public XMLObject() throws Exception {
        Object object = c.newDocumentBuilder();
        this.a = ((DocumentBuilder)object).newDocument();
        object = this.a.createElement("root");
        this.a.appendChild((Node)object);
        this.e = this.a.getFirstChild();
    }

    public XMLObject(File file) throws Exception {
        this(new FileInputStream(file));
    }

    public XMLObject(InputStream inputStream) throws Exception {
        this.a(inputStream);
    }

    public XMLObject(String string) throws Exception {
        this(new ByteArrayInputStream(string.getBytes("UTF-8")));
    }

    public void load(String string) throws Exception {
        this.a(new ByteArrayInputStream(string.getBytes("UTF-8")));
    }

    private void a(InputStream inputStream) throws Exception {
        DocumentBuilder documentBuilder = c.newDocumentBuilder();
        this.a = documentBuilder.parse(inputStream);
        this.e = this.a.getFirstChild();
    }

    public Node getNode(String object) {
        try {
            object = "/" + this.e.getNodeName() + (String)object;
            object = (NodeList)b.evaluate((String)object, this.a.getDocumentElement(), XPathConstants.NODESET);
            if (object.getLength() == 0) {
                return null;
            }
            return object.item(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Node getNode(Node object, String string) {
        try {
            object = (NodeList)b.evaluate(string, object, XPathConstants.NODESET);
            if (object.getLength() == 0) {
                return null;
            }
            return object.item(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getNodeText(String string) {
        try {
            return this.getNode(string).getTextContent().trim();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getNodeText(Node node, String string) {
        try {
            return this.getNode(node, string).getTextContent().trim();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public List<Node> getChildNodes(String object) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        try {
            object = this.getNode((String)object).getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (node.getNodeType() != 1) continue;
                linkedList.add(node);
            }
        }
        catch (Exception exception) {}
        return linkedList;
    }

    public List<Node> getNodes(String string) {
        return XMLObject.a("/" + this.e.getNodeName() + string, this.a.getDocumentElement());
    }

    public List<Node> getNodes(Node node, String string) {
        return XMLObject.a(string, node);
    }

    private static List<Node> a(String object, Node node) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        try {
            object = (NodeList)b.evaluate((String)object, node, XPathConstants.NODESET);
            for (int i = 0; i < object.getLength(); ++i) {
                node = object.item(i);
                if (node.getNodeType() != 1) continue;
                linkedList.add(node);
            }
        }
        catch (Exception exception) {}
        return linkedList;
    }

    public Map<String, String> getProperties(String string) {
        XMLObject xMLObject = this;
        return xMLObject.getProperties(xMLObject.getNode(string));
    }

    public Map<String, String> getProperties(Node node) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        try {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                linkedHashMap.put(node.getNodeName(), node.getTextContent());
            }
        }
        catch (Exception exception) {}
        return linkedHashMap;
    }

    public Document getDocument() {
        return this.a;
    }

    public Node createPath(String stringArray) throws Exception {
        Node node = null;
        if (stringArray == null || stringArray.isEmpty()) {
            node = this.e;
        } else {
            stringArray = stringArray.split("/");
            StringBuilder stringBuilder = new StringBuilder();
            if (stringArray == null || stringArray.length == 0) {
                node = this.e;
            } else {
                for (String string : stringArray) {
                    if (string.length() <= 0) continue;
                    node = this.getNode(stringBuilder.toString() + "/" + string);
                    if (node == null) {
                        node = this.createNode(stringBuilder.toString(), string);
                    }
                    stringBuilder.append("/").append(string);
                }
            }
        }
        return node;
    }

    public Node createNode(String string, String string2) throws Exception {
        XMLObject xMLObject = this;
        return xMLObject.createNode(xMLObject.getNode(string), string2);
    }

    public Node createNode(Node node, String object) throws Exception {
        object = this.a.createElement((String)object);
        return node.appendChild((Node)object);
    }

    public Node createNode(Node node, Node node2) throws Exception {
        return node.appendChild(node2);
    }

    public Source getSource() {
        return new DOMSource(this.a);
    }

    public void save(OutputStream object) throws Exception {
        Transformer transformer = d.newTransformer();
        DOMSource dOMSource = new DOMSource(this.a);
        object = new StreamResult((OutputStream)object);
        transformer.transform(dOMSource, (Result)object);
    }

    public void importNode(String object, Node node) {
        object = this.getNode((String)object);
        node = this.a.importNode(node, true);
        object.appendChild(node);
    }

    public String toString() {
        try {
            Transformer transformer = d.newTransformer();
            DOMSource dOMSource = new DOMSource(this.a);
            StreamResult streamResult = new StreamResult(new StringWriter());
            transformer.transform(dOMSource, streamResult);
            return streamResult.getWriter().toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(String string) {
        XMLObject xMLObject = this;
        return xMLObject.toString(xMLObject.getNode(string));
    }

    public String toString(Node object) {
        try {
            object = new DOMSource((Node)object);
            Transformer transformer = d.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            transformer.transform((Source)object, streamResult);
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public Collection<String> getValues(String object, String object2) {
        object = ((Element)this.getNode((String)object)).getElementsByTagName((String)object2);
        object2 = new HashSet();
        for (int i = 0; i < object.getLength(); ++i) {
            object2.add(object.item(i).getTextContent());
        }
        return object2;
    }

    public void addAttributes(String object, Map<String, String> map) throws Exception {
        object = (Element)this.getNode((String)object);
        for (String string : map.keySet()) {
            object.setAttribute(string, map.get(string));
        }
    }

    public void addAttribute(String string, String string2, String string3) throws Exception {
        ((Element)this.getNode(string)).setAttribute(string2, string3);
    }

    public void addAttribute(Node node, String string, String string2) throws Exception {
        ((Element)node).setAttribute(string, string2);
    }

    public String getAttribute(String string, String string2) {
        try {
            return this.getNode(string).getAttributes().getNamedItem(string2).getNodeValue();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getAttribute(Node node, String string) {
        try {
            return node.getAttributes().getNamedItem(string).getNodeValue();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public Map<String, String> getAttributes(Node object) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        try {
            if (object.hasAttributes()) {
                object = object.getAttributes();
                int n = object.getLength();
                for (int i = 0; i < n; ++i) {
                    try {
                        Attr attr = (Attr)object.item(i);
                        linkedHashMap.put(attr.getNodeName(), attr.getNodeValue());
                        continue;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {}
        return linkedHashMap;
    }

    public void addValue(String string, String string2, String string3) {
        try {
            Node node = this.getNode(string);
            if (node == null) {
                this.createPath(string);
                node = this.getNode(string);
            }
            this.addValue(node, string2, string3);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void addValue(Node node, String object, String string) throws Exception {
        if (string != null && !string.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string);
            if (!hashSet.isEmpty()) {
                object = this.a.createElement((String)object);
                node.appendChild((Node)object);
                node = this.a.createCDATASection(string);
                object.appendChild(node);
            }
        }
    }

    public boolean addValues(String object, String string, Collection<String> object2) throws Exception {
        boolean bl = false;
        Node node = this.getNode((String)object);
        if (node == null) {
            this.createPath((String)object);
            node = this.getNode((String)object);
        }
        if (!object2.isEmpty()) {
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Object object3 = (String)object2.next();
                object = this.a.createElement(string);
                node.appendChild((Node)object);
                object3 = this.a.createTextNode((String)object3);
                object.appendChild((Node)object3);
            }
            bl = true;
        }
        return bl;
    }

    public boolean addValues(String string, Map<String, Collection<String>> map) throws Exception {
        boolean bl = false;
        for (String string2 : map.keySet()) {
            bl = this.addValues(string, string2, map.get(string2));
        }
        return bl;
    }

    public void updateValue(String string, String string2, String string3) {
        XMLObject xMLObject = this;
        xMLObject.updateValue(xMLObject.getNode(string), string2, string3);
    }

    public void updateValue(Node node, String object, String string) {
        try {
            if (string == null || string.isEmpty()) {
                if ((node = this.getNode(node, (String)object)) != null) {
                    this.remove(node);
                }
                return;
            }
            if (this.getNode(node, (String)object) == null) {
                this.createNode(node, (String)object);
            }
            node = this.getNode(node, (String)object);
            object = this.a.createCDATASection(string);
            node.replaceChild((Node)object, node.getFirstChild());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void remove(String string) {
        XMLObject xMLObject = this;
        xMLObject.remove(xMLObject.getNode(string));
    }

    public void remove(Node node) {
        try {
            node.getParentNode().removeChild(node);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void rename(Node node, String string) {
        Node node2 = node;
        this.a.renameNode(node2, node2.getNamespaceURI(), string);
    }

    public String getPath(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        while (node != null && !node.getNodeName().equalsIgnoreCase(this.e.getNodeName())) {
            stringBuilder.insert(0, node.getNodeName()).insert(0, "/");
            node = node.getParentNode();
        }
        return stringBuilder.toString();
    }

    public Node getRoot() {
        return this.e;
    }

    static {
        c.setNamespaceAware(false);
        c.setValidating(false);
        c.setIgnoringComments(true);
        d = TransformerFactory.newInstance();
    }
}

