/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.common.work;

import com.binfer.common.work.Work;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class WorkPool {
    private ThreadPoolExecutor a;
    private String b;
    private int c;
    private static Map<Runnable, Future> d = new ConcurrentHashMap<Runnable, Future>();

    public WorkPool(String string, int n) {
        this(n);
        this.b = string;
    }

    public WorkPool(int n) {
        this.c = n;
        int n2 = n;
        this.a = new ThreadPoolExecutor(n2, n2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public void addWork(Work work) {
        work.b = this;
        Future<?> future = this.a.submit(work);
        d.put(work, future);
    }

    static void a(Work work) {
        d.remove(work);
    }

    public long getPendingTasks() {
        return this.a.getTaskCount() - this.a.getCompletedTaskCount();
    }

    public int getActiveTasks() {
        return this.a.getActiveCount();
    }

    public int getTasksInQueue() {
        return d.size();
    }

    public long getCompletedTasks() {
        return this.a.getCompletedTaskCount();
    }

    public void clearPendingTasks() {
        this.a.getQueue().clear();
    }

    public boolean isEmpty() {
        return this.a.getQueue().isEmpty();
    }

    public boolean contains(Runnable runnable) {
        return this.a.getQueue().contains(runnable);
    }

    public void stopAllWork() {
        this.clearPendingTasks();
        for (Future future : d.values()) {
            try {
                future.cancel(true);
            }
            catch (Exception exception) {}
        }
        d.clear();
    }

    public void close() {
        this.clearPendingTasks();
        for (Future future : d.values()) {
            try {
                future.cancel(true);
            }
            catch (Exception exception) {}
        }
        d.clear();
        this.a.shutdownNow();
    }

    public String getName() {
        if (this.b == null) {
            return "WorkPool-" + this.c;
        }
        return this.b;
    }

    public void setKillThreadsAfter(int n, TimeUnit timeUnit) {
        this.a.setKeepAliveTime(n, timeUnit);
        this.a.allowCoreThreadTimeOut(true);
    }

    public int getWorkers() {
        return this.c;
    }

    public String toString() {
        if (this.b == null) {
            return super.toString();
        }
        return this.b;
    }

    public static void main(String[] object) throws Exception {
        object = new WorkPool(10);
        for (int i = 0; i < 1000; ++i) {
            Work work = new Work("work ".concat(String.valueOf(i))){

                @Override
                public final void execute() throws Exception {
                    try {
                        int n = 100;
                        while (n-- > 0) {
                            System.out.println(this.a + ", ctr:" + n);
                            Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println(this.a + "-interrupted exception");
                        return;
                    }
                }
            };
            ((WorkPool)object).addWork(work);
        }
        System.out.println("Press any key to exit");
        System.in.read();
        ((WorkPool)object).close();
        System.out.println("Exiting");
    }
}

