/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.Client;
import com.azul.crs.client.Tweaks;
import com.azul.crs.client.service.ConfigurationUpdatingService;
import com.azul.crs.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public enum Options {
    UnlockExperimentalCRS(null),
    props(Options::readableFile),
    mode(Options::agentMode),
    delayTermination(Options::nonNegativeNumber, "0"),
    maxJarFileCacheSize(Options::nonNegativeNumber, Tweaks.forceFullJarLoadedEvents ? "9999999999" : "20480"),
    stackRecordId(Options::anyString),
    enable(null),
    lifetimejfr(Options::anyString),
    delayInitiation(Options::nonNegativeNumber, "2000", "2000"),
    forceSyncTimeout(Options::nonNegativeNumber),
    sendJVMLogs(Options::anyBoolean, "false", "true"),
    extraLogFile(Options::anyString),
    connectionManager(Options::anyString),
    sendPOMData(Options::anyBoolean, "true", "true", Options::generationalBooleanRestricting),
    sendClassMethods(Options::anyBoolean, "false", "true", Options::generationalBooleanRestricting),
    notifyJarLoad(Options::anyBoolean, "true", "true", Options::generationalBooleanRestricting),
    notifyClassLoad(Options::anyBoolean, "true", "true", Options::generationalBooleanRestricting),
    notifyFirstCall(Options::anyBoolean, "false", "true", Options::generationalBooleanRestricting),
    sendCRSLogs(Options::anyBoolean, "true", "true", Options::generationalBooleanRestricting),
    features(Options::featuresList, null, null, (options, object, origin, generation) -> true);

    private static final String DEFAULT_SHARED_PROPS_FILE = "az_crs.properties";
    private static final String DEFAULT_USER_PROPS_FILE;
    private volatile Object value;
    private Map<Generation, Object> valuePerGeneration = Collections.synchronizedMap(new HashMap());
    private Origin origin;
    private Generation generation;
    private static final Map<Client.ClientProp, Object> clientProps;
    private static Collection<Map.Entry<String, String>> loggerOptions;
    private final BiFunction<Options, String, Object> validator;
    private final TransitionAllowedPredicate transitionAllowedPredicate;
    private final String defaultValue;
    private final String emptyValue;
    private static final boolean DEBUG = false;

    private Options(BiFunction<Options, String, Object> biFunction) {
        this(biFunction, null);
    }

    private Options(BiFunction<Options, String, Object> biFunction, String string2) {
        this(biFunction, string2, null);
    }

    private Options(BiFunction<Options, String, Object> biFunction, String string2, String string3) {
        this(biFunction, string2, string3, Options::onlyAllowedToBeEditedByLocalConfiguration);
    }

    private Options(BiFunction<Options, String, Object> biFunction, String string2, String string3, TransitionAllowedPredicate transitionAllowedPredicate) {
        this.validator = biFunction;
        this.defaultValue = string2;
        this.emptyValue = string3;
        this.transitionAllowedPredicate = transitionAllowedPredicate;
    }

    private static String readableFile(Options options, String string) {
        Path path = Paths.get(string, new String[0]);
        if (Files.isReadable(path)) {
            try {
                return path.toFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Bad value '" + string + "'. " + options.name() + " requires valid readable file path.");
    }

    private static Boolean anyBoolean(Options options, String string) {
        switch (string.toLowerCase()) {
            case "on": 
            case "yes": 
            case "true": 
            case "enable": {
                return true;
            }
            case "off": 
            case "no": 
            case "false": 
            case "disable": {
                return false;
            }
        }
        throw new IllegalArgumentException("Bad " + options.name() + " option value '" + string + "'. Allowed values: '{yes|no|true|false|on|off|enable|disable}'");
    }

    private static String anyString(Options options, String string) {
        return string;
    }

    private static String agentMode(Options options, String string) {
        String string2;
        switch (string2 = string.toLowerCase()) {
            case "on": 
            case "off": 
            case "auto": {
                return string2;
            }
        }
        throw new IllegalArgumentException("Bad " + options.name() + " option value '" + string + "'. Allowed values: '{on|off|auto}'.");
    }

    private static Long nonNegativeNumber(Options options, String string) {
        try {
            Long l = Long.parseLong(string);
            if (l >= 0L) {
                return l;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Bad " + options.name() + " option value '" + string + "'. Non-negative number required.");
    }

    private static Features[] featuresList(Options options, String string) {
        if (string == null) {
            return null;
        }
        ArrayList<Features> arrayList = new ArrayList<Features>();
        for (String string2 : string.split("\\+")) {
            try {
                arrayList.add(Features.valueOf(string2));
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                throw new IllegalArgumentException("Bad " + options.name() + " option value '" + string2 + "' in list '" + string + "'. Allowed a list of comma-separated values: '{" + Arrays.stream(Features.values()).map(features -> Objects.toString(features)).collect(Collectors.joining("|")) + "}'.");
            }
        }
        return arrayList.toArray(new Features[0]);
    }

    private static boolean onlyAllowedToBeEditedByLocalConfiguration(Options options, Object object, Origin origin, Generation generation) {
        return generation == Generation.LOCAL || generation == Generation.HARDCODED;
    }

    private static boolean generationalBooleanRestricting(Options options, Object object, Origin origin, Generation generation) {
        if (generation == Generation.HARDCODED) {
            return true;
        }
        if (generation == Generation.LOCAL) {
            return true;
        }
        if (!(object instanceof Boolean)) {
            return false;
        }
        Boolean bl = (Boolean)object;
        if (!(options.value instanceof Boolean)) {
            return false;
        }
        Boolean bl2 = (Boolean)options.getByGeneration(Generation.LOCAL);
        if (bl2 == null) {
            bl2 = (Boolean)options.validator.apply(options, options.defaultValue);
        }
        if (!bl2.booleanValue() && bl.booleanValue()) {
            return false;
        }
        if (!bl2.booleanValue() && !bl.booleanValue()) {
            return origin != Origin.FEATURE_ALIAS;
        }
        if (bl2.booleanValue() && bl.booleanValue()) {
            return origin != Origin.FEATURE_ALIAS;
        }
        return bl2 == true && bl == false;
    }

    static void setDefaults() {
        EnumSet.allOf(Options.class).stream().filter(options -> options.value == null && options.defaultValue != null).forEach(options -> options.set(options.defaultValue, Origin.DEFAULT, Generation.HARDCODED));
    }

    public static void checkIntegrity(Predicate<Options> predicate) {
        EnumSet.allOf(Options.class).stream().filter(options -> !predicate.test((Options)((Object)options))).filter(Options::isSet).forEach(options -> Logger.getLogger(Options.class).warning("%s is not supported and ignored", options.name()));
        if (predicate.test(notifyJarLoad) && predicate.test(notifyClassLoad) && notifyJarLoad.isSet() && !notifyJarLoad.isYes() && (!notifyClassLoad.isSet() || notifyClassLoad.isYes())) {
            notifyClassLoad.set("false", Origin.ERGONOMIC, Generation.HARDCODED);
            Logger.getLogger(Options.class).warning("notifyClassLoad depends on notifyJarLoad and was disabled", new Object[0]);
        }
        if (predicate.test(notifyClassLoad) && predicate.test(notifyFirstCall) && notifyClassLoad.isSet() && !notifyClassLoad.isYes() && (!notifyFirstCall.isSet() || notifyFirstCall.isYes())) {
            notifyFirstCall.set("false", Origin.ERGONOMIC, Generation.HARDCODED);
            Logger.getLogger(Options.class).warning("notifyFirstCall depends on notifyClassLoad and was disabled", new Object[0]);
        }
        Options.setDefaults();
    }

    public static void dump(Predicate<Options> predicate) {
        Logger logger = Logger.getLogger(Options.class);
        if (logger.isEnabled(Logger.Level.DEBUG)) {
            Set set = EnumSet.allOf(Options.class).stream().filter(predicate).filter(Options::isSet).collect(Collectors.toSet());
            Function<Function, Integer> function2 = function -> set.stream().map(function).mapToInt(String::length).max().orElse(0);
            int n = function2.apply(Enum::name);
            int n2 = function2.apply(Options::get);
            int n3 = function2.apply(options -> options.origin.name());
            int n4 = function2.apply(options -> options.generation.name());
            logger.debug("Effective %s options:", "Azul IC Agent");
            set.stream().sorted(Comparator.comparing(Enum::name)).forEach(options -> logger.debug("   %-" + n + "s = %" + n2 + "s [ %-" + n3 + "s ][ %-" + n4 + "s ]", new Object[]{options.name(), options.get(), options.origin, options.generation}));
        }
    }

    static void enableFeatures(Origin origin, Generation generation) {
        if (Options.features.value == null) {
            return;
        }
        if (!(Options.features.value instanceof Features[])) {
            return;
        }
        HashSet<Options> hashSet = new HashSet<Options>(Arrays.asList(Features.ALL.requiredSerivces));
        ArrayList<Features> arrayList = new ArrayList<Features>();
        boolean bl = false;
        for (Features features2 : (Features[])Options.features.value) {
            if (features2.applicable(generation)) {
                arrayList.add(features2);
                Arrays.stream(features2.requiredSerivces).forEach(options -> hashSet.remove(options));
                for (Options options2 : features2.requiredSerivces) {
                    options2.set("true", Origin.FEATURE_ALIAS, generation);
                }
                continue;
            }
            bl = true;
            Logger.getLogger(Options.class).debug("Impossible to enable CRS feature '%s' since required services are disabled=%s", new Object[]{features2, Arrays.stream(features2.requiredSerivces).map(options -> "[" + (Object)options + "=" + options.get() + "(" + (Object)((Object)options.origin) + "," + (Object)((Object)options.generation) + ")]").collect(Collectors.joining(","))});
        }
        for (Options options3 : hashSet) {
            options3.set("false", Origin.FEATURE_ALIAS, generation);
        }
        if (bl) {
            if (arrayList.size() > 0) {
                Options.features.set(arrayList.stream().map(features -> Objects.toString(features)).collect(Collectors.joining("+")), Origin.ERGONOMIC, generation);
            } else {
                Options.features.set(null, Origin.ERGONOMIC, generation);
            }
        }
    }

    static String optionValueToString(Object object2) {
        if (object2 == null) {
            return null;
        }
        if (object2.getClass().isArray()) {
            return Arrays.stream((Object[])object2).sorted().map(object -> Objects.toString(object)).collect(Collectors.joining(","));
        }
        return Objects.toString(object2);
    }

    String get() {
        return Options.optionValueToString(this.value);
    }

    Object value() {
        return this.value;
    }

    Object getByGeneration(Generation generation2) {
        return generation2.firstNonNull(generation -> this.valuePerGeneration.get(generation));
    }

    boolean isSet() {
        return this.value != null;
    }

    public int getInt() {
        return this.value instanceof Long ? Math.toIntExact((Long)this.value) : -1;
    }

    public long getLong() {
        return this.value instanceof Long ? (Long)this.value : -1L;
    }

    private static boolean asBoolean(Object object) {
        return object instanceof Boolean ? (Boolean)object : false;
    }

    public boolean isYes() {
        return Options.asBoolean(this.value);
    }

    void set(String string, Origin origin, Generation generation) {
        try {
            String string2;
            if ("".equals(string)) {
                string = this.emptyValue;
            }
            String string3 = string2 = this.validator == null ? string : this.validator.apply(this, string);
            if (!this.transitionAllowedPredicate.isTransitionAllowed(this, string2, origin, generation)) {
                Logger.getLogger(Options.class).debug("Transition of option '%s' value '%s' (origin=%s, generation=%s) to new one '%s' (origin=%s, generation=%s) is not allowed.", new Object[]{this, this.get(), this.origin, this.generation, Options.optionValueToString(string2), origin, generation});
                return;
            }
            this.value = string2;
            this.valuePerGeneration.put(generation, string2);
            this.origin = origin;
            this.generation = generation;
            if (string2 instanceof Boolean) {
                switch (this) {
                    case notifyJarLoad: {
                        ConfigurationUpdatingService.setSendJarLoads((Boolean)((Object)string2));
                        break;
                    }
                    case notifyClassLoad: {
                        ConfigurationUpdatingService.setSendClassLoads((Boolean)((Object)string2));
                        break;
                    }
                    case notifyFirstCall: {
                        ConfigurationUpdatingService.setSendFirstMethods((Boolean)((Object)string2));
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(Options.class).error("%s", illegalArgumentException);
            this.value = this.defaultValue;
            this.origin = Origin.ERGONOMIC;
        }
    }

    void clear() {
        this.value = null;
        this.origin = null;
        this.generation = null;
        this.valuePerGeneration = new HashMap<Generation, Object>();
    }

    static void read(String string) {
        File file;
        loggerOptions = new LinkedList<Map.Entry<String, String>>();
        String string2 = System.getenv("AZ_CRS_ARGUMENTS");
        String string3 = Options.getPropFileNameFromArgs(string);
        if (string3 == null) {
            string3 = Options.getPropFileNameFromArgs(string2);
        }
        if (string3 != null) {
            file = new File(string3);
            if (!file.exists()) {
                Logger.getLogger(Options.class).error("specified properties file '%s' does not exist", file.getPath());
            }
        } else {
            file = new File(System.getProperty("user.home") + File.separatorChar + DEFAULT_USER_PROPS_FILE);
            if (!file.exists()) {
                file = new File(System.getProperty("java.home") + File.separatorChar + "lib" + File.separatorChar + DEFAULT_SHARED_PROPS_FILE);
            }
        }
        if (file.exists()) {
            Options.tryLoadingProps(file);
        }
        Options.readArgs(string2, Origin.ENVIRONMENT, Generation.LOCAL);
        Options.readArgs(string, Origin.COMMANDLINE, Generation.LOCAL);
        Logger.parseOptions(loggerOptions);
        loggerOptions = null;
    }

    private static String getPropFileNameFromArgs(String string) {
        String string2 = null;
        int n = 0;
        if (string != null && string.startsWith("mode=on,")) {
            n += "mode=on,".length();
        }
        if (string != null && string.startsWith("mode=auto,")) {
            n += "mode=auto,".length();
        }
        if (string != null && string.startsWith("failJVMOnError,")) {
            n += "failJVMOnError,".length();
        }
        if (string != null && string.length() > n) {
            int n2;
            int n3 = string.indexOf(44, n);
            if (n3 < 0) {
                n3 = string.length();
            }
            if (string.charAt(n) != ',' && ((n2 = string.indexOf(61, n)) < 0 || n2 > n3)) {
                try {
                    Options.valueOf(string.substring(n, n3));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    string2 = string.substring(n, n3);
                }
            }
            String string3 = props.name() + "=";
            int n4 = string3.length();
            do {
                if ((n3 = string.indexOf(44, n)) < 0) {
                    n3 = string.length();
                }
                if (!string.startsWith(string3, n)) continue;
                string2 = string.substring(n + n4, n3);
                break;
            } while ((n = n3 + 1) < string.length());
        }
        return string2;
    }

    static void readArgs(String string, Origin origin, Generation generation) {
        int n;
        if (string == null) {
            return;
        }
        int n2 = 0;
        do {
            String string2;
            int n3;
            if ((n = string.indexOf(44, n2)) == -1) {
                n = string.length();
            }
            if ((n3 = string.indexOf(61, n2)) == -1 || n3 > n) {
                n3 = n;
            }
            String string3 = string.substring(n2, n3);
            String string4 = string2 = n3 == n ? "" : string.substring(n3 + 1, n);
            if (props.name().equals(string3)) continue;
            Options.process(string3, string2, n2 == 0 && n3 == n, origin, generation);
        } while ((n2 = n + 1) < string.length());
        Options.enableFeatures(origin, generation);
    }

    public static void updateFeatureFlags(String string) {
        Options.readArgs(string, Origin.UPDATE, Generation.REMOTE);
        Options.dump(options -> true);
    }

    private static void process(String string, String string2, boolean bl, Origin origin, Generation generation) {
        block9: {
            if (string.equals("log") || string.startsWith("log+") || string.startsWith("log:")) {
                loggerOptions.add(new AbstractMap.SimpleEntry<String, String>(string, string2));
            } else if (props.name().equals(string)) {
                Options.tryLoadingProps(new File(string2));
            } else if (string.length() > 0) {
                for (Client.ClientProp clientProp : (Client.ClientProp[])Client.ClientProp.class.getEnumConstants()) {
                    if (!clientProp.value().equals(string)) continue;
                    clientProps.put(clientProp, string2);
                    return;
                }
                try {
                    Options.valueOf(string).set(string2, origin, generation);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                    if (bl) break block9;
                    Logger.getLogger(Options.class).error("unrecognized CRS agent option %s ignored", string);
                }
            }
        }
        if (Tweaks.FORCE_TRACE_LOGGING) {
            loggerOptions = new LinkedList<Map.Entry<String, String>>();
            loggerOptions.add(new AbstractMap.SimpleEntry<String, String>("log", "trace+stack+time"));
        }
    }

    private static void tryLoadingProps(File file) {
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            properties.load(inputStream);
            for (String string : properties.stringPropertyNames()) {
                Options.process(string, properties.getProperty(string), false, Origin.PROPERTIES, Generation.LOCAL);
            }
            Options.enableFeatures(Origin.PROPERTIES, Generation.LOCAL);
        }
        catch (IOException iOException) {
            Logger.getLogger(Options.class).error("cannot load specified properties file %s: %s", file.getPath(), iOException);
        }
    }

    public static Map<Client.ClientProp, Object> getClientProps() {
        return clientProps;
    }

    static {
        DEFAULT_USER_PROPS_FILE = ".az_crs" + File.separatorChar + "config.properties";
        clientProps = new HashMap<Client.ClientProp, Object>();
    }

    public static enum Features {
        JVMI(new Options[0]),
        AVD(new Options[]{notifyJarLoad, notifyClassLoad}),
        CI(new Options[]{notifyJarLoad, notifyClassLoad, notifyFirstCall, sendClassMethods}),
        ALL(new Options[]{notifyJarLoad, notifyClassLoad, notifyFirstCall, sendClassMethods});

        final Options[] requiredSerivces;

        private Features(Options[] optionsArray) {
            this.requiredSerivces = optionsArray;
        }

        private static boolean allowedCrossModify(Generation generation, Generation generation2) {
            if (generation == Generation.REMOTE && generation2 == Generation.REMOTE) {
                return true;
            }
            return generation != Generation.REMOTE && generation2 != Generation.REMOTE;
        }

        private static boolean isYesExplicitly(Options options, Generation generation) {
            if (options.generation == null || generation == null) {
                boolean bl = Options.asBoolean(options.validator.apply(options, options.defaultValue));
                return bl;
            }
            if (options.origin == Origin.FEATURE_ALIAS && Features.allowedCrossModify(options.generation, generation)) {
                return Features.isYesExplicitly(options, generation.prev);
            }
            Boolean bl = (Boolean)options.valuePerGeneration.get((Object)generation);
            if (bl == null) {
                return Features.isYesExplicitly(options, generation.prev);
            }
            return bl;
        }

        public boolean applicable(Generation generation) {
            if (this.requiredSerivces.length == 0) {
                return true;
            }
            return Arrays.stream(this.requiredSerivces).anyMatch(options -> Features.isYesExplicitly(options, generation));
        }
    }

    public static enum Generation {
        HARDCODED(null),
        LOCAL(HARDCODED),
        REMOTE(LOCAL);

        Generation prev;

        private Generation(Generation generation) {
            this.prev = generation;
        }

        public Object firstNonNull(Function<Generation, Object> function) {
            Object object = function.apply(this);
            if (object != null) {
                return object;
            }
            if (this.prev != null) {
                return this.prev.firstNonNull(function);
            }
            return null;
        }
    }

    public static enum Origin {
        DEFAULT,
        COMMANDLINE,
        ENVIRONMENT,
        PROPERTIES,
        ERGONOMIC,
        FEATURE_ALIAS,
        UPDATE;

    }

    private static interface TransitionAllowedPredicate {
        public boolean isTransitionAllowed(Options var1, Object var2, Origin var3, Generation var4);
    }
}

