/*
 * Decompiled with CFR 0.152.
 */
package impl.jfxtras.styles.jmetro;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.scene.control.skin.ButtonSkin;
import impl.jfxtras.styles.jmetro.ButtonAnimationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.SkinBase;

public class FluentButtonSkin
extends ButtonSkin {
    private ButtonAnimationHelper buttonAnimationHelper;
    private static final CssMetaData<Button, Boolean> SHRINK_ANIMATE_ON_PRESS_META_DATA = new CssMetaData<Button, Boolean>("-shrink-animate-on-press", BooleanConverter.getInstance(), Boolean.valueOf(true)){

        public boolean isSettable(Button button) {
            FluentButtonSkin skin = (FluentButtonSkin)button.getSkin();
            return !skin.shrinkAnimateOnPress.isBound();
        }

        public StyleableProperty<Boolean> getStyleableProperty(Button button) {
            FluentButtonSkin skin = (FluentButtonSkin)button.getSkin();
            return (StyleableProperty)skin.shrinkAnimateOnPressProperty();
        }
    };
    private BooleanProperty shrinkAnimateOnPress = new SimpleStyleableBooleanProperty(SHRINK_ANIMATE_ON_PRESS_META_DATA, true);
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public FluentButtonSkin(Button button) {
        super(button);
        this.buttonAnimationHelper = ButtonAnimationHelper.setupButton((ButtonBase)button, this.shrinkAnimateOnPressProperty());
    }

    private BooleanProperty shrinkAnimateOnPressProperty() {
        return this.shrinkAnimateOnPress;
    }

    private boolean isShrinkAnimateOnPress() {
        return this.shrinkAnimateOnPress.get();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FluentButtonSkin.getClassCssMetaData();
    }

    public void dispose() {
        this.buttonAnimationHelper.dispose();
        super.dispose();
    }

    static {
        ArrayList<CssMetaData<Button, Boolean>> styleables = new ArrayList<CssMetaData<Button, Boolean>>(SkinBase.getClassCssMetaData());
        styleables.add(SHRINK_ANIMATE_ON_PRESS_META_DATA);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }
}

