/*
 * Decompiled with CFR 0.152.
 */
package impl.jfxtras.styles.jmetro;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.SliderBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import impl.jfxtras.styles.jmetro.SliderPopup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.animation.Transition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import javafx.util.StringConverter;

public class SliderSkin
extends BehaviorSkinBase<Slider, SliderBehavior> {
    private NumberAxis tickLine = null;
    private double trackToTickGap = 2.0;
    private boolean showTickMarks;
    private double thumbWidth;
    private double thumbHeight;
    private double trackStart;
    private double trackLength;
    private double thumbTop;
    private double thumbLeft;
    private double preDragThumbPos;
    private Point2D dragStart;
    private StackPane thumb;
    private StackPane track;
    private StackPane fill;
    private boolean trackClicked = false;
    private SliderPopup popup = new SliderPopup();
    private static final int POPUP_DISTANCE_FROM_THUMB = 50;
    private static final Duration POPUP_FADE_DURATION = Duration.millis((double)200.0);
    private StringConverter<Number> stringConverterWrapper = new StringConverter<Number>(){
        Slider slider;
        {
            this.slider = (Slider)SliderSkin.this.getSkinnable();
        }

        public String toString(Number object) {
            return object != null ? this.slider.getLabelFormatter().toString((Object)object.doubleValue()) : "";
        }

        public Number fromString(String string) {
            return (Number)this.slider.getLabelFormatter().fromString(string);
        }
    };
    private static final CssMetaData<Slider, Boolean> SHOW_VALUE_ON_INTERACTION_META_DATA = new CssMetaData<Slider, Boolean>("-show-value-on-interaction", BooleanConverter.getInstance(), Boolean.valueOf(true)){

        public boolean isSettable(Slider slider) {
            SliderSkin skin = (SliderSkin)slider.getSkin();
            return !skin.showValueOnInteraction.isBound();
        }

        public StyleableProperty<Boolean> getStyleableProperty(Slider slider) {
            SliderSkin skin = (SliderSkin)slider.getSkin();
            return (StyleableProperty)skin.showValueOnInteractionProperty();
        }
    };
    private BooleanProperty showValueOnInteraction = new SimpleStyleableBooleanProperty(SHOW_VALUE_ON_INTERACTION_META_DATA, true);
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public SliderSkin(Slider slider) {
        super((Control)slider, (BehaviorBase)new SliderBehavior(slider));
        this.initialize();
        slider.requestLayout();
        this.registerChangeListener((ObservableValue)slider.minProperty(), "MIN");
        this.registerChangeListener((ObservableValue)slider.maxProperty(), "MAX");
        this.registerChangeListener((ObservableValue)slider.valueProperty(), "VALUE");
        this.registerChangeListener((ObservableValue)slider.orientationProperty(), "ORIENTATION");
        this.registerChangeListener((ObservableValue)slider.showTickMarksProperty(), "SHOW_TICK_MARKS");
        this.registerChangeListener((ObservableValue)slider.showTickLabelsProperty(), "SHOW_TICK_LABELS");
        this.registerChangeListener((ObservableValue)slider.majorTickUnitProperty(), "MAJOR_TICK_UNIT");
        this.registerChangeListener((ObservableValue)slider.minorTickCountProperty(), "MINOR_TICK_COUNT");
        this.registerChangeListener((ObservableValue)slider.labelFormatterProperty(), "TICK_LABEL_FORMATTER");
    }

    private void initialize() {
        this.thumb = new StackPane();
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.track = new StackPane();
        this.track.getStyleClass().setAll((Object[])new String[]{"track"});
        this.fill = new StackPane();
        this.fill.getStyleClass().setAll((Object[])new String[]{"fill"});
        this.getChildren().setAll((Object[])new Node[]{this.track, this.fill, this.thumb});
        this.setShowTickMarks(((Slider)this.getSkinnable()).isShowTickMarks(), ((Slider)this.getSkinnable()).isShowTickLabels());
        this.track.setOnMousePressed(this::mousePressedOnTrack);
        this.track.setOnMouseDragged(this::mouseDraggedOnTrack);
        this.fill.setOnMousePressed(this::mousePressedOnTrack);
        this.fill.setOnMouseDragged(this::mouseDraggedOnTrack);
        this.fill.setOnMouseReleased(this::mouseReleasedFromTrack);
        this.thumb.setOnMousePressed(me -> {
            ((SliderBehavior)this.getBehavior()).thumbPressed(me, 0.0);
            this.dragStart = this.thumb.localToParent(me.getX(), me.getY());
            this.preDragThumbPos = (((Slider)this.getSkinnable()).getValue() - ((Slider)this.getSkinnable()).getMin()) / (((Slider)this.getSkinnable()).getMax() - ((Slider)this.getSkinnable()).getMin());
            this.showValuePopup();
        });
        this.thumb.setOnMouseReleased(me -> {
            ((SliderBehavior)this.getBehavior()).thumbReleased(me);
            this.hideValuePopup();
        });
        this.thumb.setOnMouseDragged(me -> {
            Point2D cur = this.thumb.localToParent(me.getX(), me.getY());
            double dragPos = ((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL ? cur.getX() - this.dragStart.getX() : -(cur.getY() - this.dragStart.getY());
            ((SliderBehavior)this.getBehavior()).thumbDragged(me, this.preDragThumbPos + dragPos / this.trackLength);
            this.displaceValuePopup();
        });
        this.track.setOnMouseReleased(this::mouseReleasedFromTrack);
    }

    private void showValuePopup() {
        if (!this.isShowValueOnInteraction()) {
            return;
        }
        this.popup.setValue(((Slider)this.getSkinnable()).getValue());
        Point2D thumbScreenPos = this.thumb.localToScreen(this.thumb.getBoundsInLocal().getMinX(), this.thumb.getBoundsInLocal().getMinY());
        Orientation orientation = ((Slider)this.getSkinnable()).getOrientation();
        if (orientation.equals((Object)Orientation.HORIZONTAL)) {
            this.popup.show((Node)this.thumb, thumbScreenPos.getX() + this.thumb.getWidth() / 2.0, thumbScreenPos.getY() - 50.0);
            this.popup.setX(this.popup.getX() - this.popup.getWidth() / 2.0);
        } else if (orientation.equals((Object)Orientation.VERTICAL)) {
            this.popup.show((Node)this.thumb, thumbScreenPos.getX() - 50.0, thumbScreenPos.getY() + this.thumb.getHeight() / 2.0);
            this.popup.setY(this.popup.getY() - this.popup.getHeight() / 2.0);
        }
        FadeTransition fadeInTransition = new FadeTransition(POPUP_FADE_DURATION, (Node)this.popup.getScene().getRoot());
        fadeInTransition.setFromValue(0.0);
        fadeInTransition.setToValue(1.0);
        fadeInTransition.play();
    }

    private void displaceValuePopup() {
        if (!this.isShowValueOnInteraction()) {
            return;
        }
        if (this.popup.isShowing()) {
            this.popup.setValue(((Slider)this.getSkinnable()).getValue());
            Point2D thumbScreenPos = this.thumb.localToScreen(this.thumb.getBoundsInLocal().getMinX(), this.thumb.getBoundsInLocal().getMinY());
            Orientation orientation = ((Slider)this.getSkinnable()).getOrientation();
            if (orientation.equals((Object)Orientation.HORIZONTAL)) {
                this.popup.setX(thumbScreenPos.getX() + this.thumb.getWidth() / 2.0 - this.popup.getWidth() / 2.0);
            } else if (orientation.equals((Object)Orientation.VERTICAL)) {
                this.popup.setY(thumbScreenPos.getY() + this.thumb.getHeight() / 2.0 - this.popup.getHeight() / 2.0);
            }
        }
    }

    private void hideValuePopup() {
        if (!this.isShowValueOnInteraction()) {
            return;
        }
        FadeTransition fadeOutTransition = new FadeTransition(POPUP_FADE_DURATION, (Node)this.popup.getScene().getRoot());
        fadeOutTransition.setFromValue(1.0);
        fadeOutTransition.setToValue(0.0);
        fadeOutTransition.setOnFinished(actionEvent -> this.popup.hide());
        fadeOutTransition.play();
    }

    private void mousePressedOnTrack(MouseEvent mouseEvent) {
        if (!this.thumb.isPressed()) {
            if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
                ((SliderBehavior)this.getBehavior()).trackPress(mouseEvent, mouseEvent.getX() / this.trackLength);
            } else {
                ((SliderBehavior)this.getBehavior()).trackPress(mouseEvent, mouseEvent.getY() / this.trackLength);
            }
        }
        this.showValuePopup();
    }

    private void mouseDraggedOnTrack(MouseEvent mouseEvent) {
        if (!this.thumb.isPressed()) {
            if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
                ((SliderBehavior)this.getBehavior()).trackPress(mouseEvent, mouseEvent.getX() / this.trackLength);
            } else {
                ((SliderBehavior)this.getBehavior()).trackPress(mouseEvent, mouseEvent.getY() / this.trackLength);
            }
        }
        this.displaceValuePopup();
    }

    private void mouseReleasedFromTrack(MouseEvent mouseEvent) {
        this.hideValuePopup();
    }

    private void setShowTickMarks(boolean ticksVisible, boolean labelsVisible) {
        this.showTickMarks = ticksVisible || labelsVisible;
        Slider slider = (Slider)this.getSkinnable();
        if (this.showTickMarks) {
            if (this.tickLine == null) {
                this.tickLine = new NumberAxis();
                this.tickLine.setAutoRanging(false);
                this.tickLine.setSide(slider.getOrientation() == Orientation.VERTICAL ? Side.RIGHT : (slider.getOrientation() == null ? Side.RIGHT : Side.BOTTOM));
                this.tickLine.setUpperBound(slider.getMax());
                this.tickLine.setLowerBound(slider.getMin());
                this.tickLine.setTickUnit(slider.getMajorTickUnit());
                this.tickLine.setTickMarkVisible(ticksVisible);
                this.tickLine.setTickLabelsVisible(labelsVisible);
                this.tickLine.setMinorTickVisible(ticksVisible);
                this.tickLine.setMinorTickCount(Math.max(slider.getMinorTickCount(), 0) + 1);
                if (slider.getLabelFormatter() != null) {
                    this.tickLine.setTickLabelFormatter(this.stringConverterWrapper);
                }
                this.getChildren().clear();
                this.getChildren().addAll((Object[])new Node[]{this.tickLine, this.track, this.fill, this.thumb});
            } else {
                this.tickLine.setTickLabelsVisible(labelsVisible);
                this.tickLine.setTickMarkVisible(ticksVisible);
                this.tickLine.setMinorTickVisible(ticksVisible);
            }
        } else {
            this.getChildren().clear();
            this.getChildren().addAll((Object[])new Node[]{this.track, this.fill, this.thumb});
        }
        ((Slider)this.getSkinnable()).requestLayout();
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        Slider slider = (Slider)this.getSkinnable();
        if ("ORIENTATION".equals(p)) {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setSide(slider.getOrientation() == Orientation.VERTICAL ? Side.RIGHT : (slider.getOrientation() == null ? Side.RIGHT : Side.BOTTOM));
            }
            ((Slider)this.getSkinnable()).requestLayout();
        } else if ("VALUE".equals(p)) {
            this.positionThumb(this.trackClicked);
        } else if ("MIN".equals(p)) {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setLowerBound(slider.getMin());
            }
            ((Slider)this.getSkinnable()).requestLayout();
        } else if ("MAX".equals(p)) {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setUpperBound(slider.getMax());
            }
            ((Slider)this.getSkinnable()).requestLayout();
        } else if ("SHOW_TICK_MARKS".equals(p) || "SHOW_TICK_LABELS".equals(p)) {
            this.setShowTickMarks(slider.isShowTickMarks(), slider.isShowTickLabels());
        } else if ("MAJOR_TICK_UNIT".equals(p)) {
            if (this.tickLine != null) {
                this.tickLine.setTickUnit(slider.getMajorTickUnit());
                ((Slider)this.getSkinnable()).requestLayout();
            }
        } else if ("MINOR_TICK_COUNT".equals(p)) {
            if (this.tickLine != null) {
                this.tickLine.setMinorTickCount(Math.max(slider.getMinorTickCount(), 0) + 1);
                ((Slider)this.getSkinnable()).requestLayout();
            }
        } else if ("TICK_LABEL_FORMATTER".equals(p) && this.tickLine != null) {
            if (slider.getLabelFormatter() == null) {
                this.tickLine.setTickLabelFormatter(null);
            } else {
                this.tickLine.setTickLabelFormatter(this.stringConverterWrapper);
                this.tickLine.requestAxisLayout();
            }
        }
    }

    private void positionThumb(boolean animate) {
        double endY;
        Slider s = (Slider)this.getSkinnable();
        if (s.getValue() > s.getMax()) {
            return;
        }
        boolean horizontal = s.getOrientation() == Orientation.HORIZONTAL;
        final double endX = horizontal ? this.trackStart + (this.trackLength * ((s.getValue() - s.getMin()) / (s.getMax() - s.getMin())) - this.thumbWidth / 2.0) : this.thumbLeft;
        double d = endY = horizontal ? this.thumbTop : this.snappedTopInset() + this.trackLength - this.trackLength * ((s.getValue() - s.getMin()) / (s.getMax() - s.getMin()));
        if (animate) {
            final double startX = this.thumb.getLayoutX();
            final double startY = this.thumb.getLayoutY();
            Transition transition = new Transition(){
                {
                    this.setCycleDuration(Duration.millis((double)200.0));
                }

                protected void interpolate(double frac) {
                    if (!Double.isNaN(startX)) {
                        SliderSkin.this.thumb.setLayoutX(startX + frac * (endX - startX));
                    }
                    if (!Double.isNaN(startY)) {
                        SliderSkin.this.thumb.setLayoutY(startY + frac * (endY - startY));
                    }
                }
            };
            transition.play();
        } else {
            this.thumb.setLayoutX(endX);
            this.thumb.setLayoutY(endY);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double trackRadius;
        this.thumbWidth = this.snapSize(this.thumb.prefWidth(-1.0));
        this.thumbHeight = this.snapSize(this.thumb.prefHeight(-1.0));
        this.thumb.resize(this.thumbWidth, this.thumbHeight);
        double d = this.track.getBackground() == null ? 0.0 : (trackRadius = this.track.getBackground().getFills().size() > 0 ? ((BackgroundFill)this.track.getBackground().getFills().get(0)).getRadii().getTopLeftHorizontalRadius() : 0.0);
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            double tickLineHeight = this.showTickMarks ? this.tickLine.prefHeight(-1.0) : 0.0;
            double trackHeight = this.snapSize(this.track.prefHeight(-1.0));
            double trackAreaHeight = Math.max(trackHeight, this.thumbHeight);
            double totalHeightNeeded = trackAreaHeight + (this.showTickMarks ? this.trackToTickGap + tickLineHeight : 0.0);
            double startY = y + (h - totalHeightNeeded) / 2.0;
            this.trackLength = this.snapSize(w - this.thumbWidth);
            this.trackStart = this.snapPosition(x + this.thumbWidth / 2.0);
            double trackTop = (int)(startY + (trackAreaHeight - trackHeight) / 2.0);
            this.thumbTop = (int)(startY + (trackAreaHeight - this.thumbHeight) / 2.0);
            this.positionThumb(false);
            this.track.resizeRelocate((double)((int)(this.trackStart - trackRadius)), trackTop, (double)((int)(this.trackLength + trackRadius + trackRadius)), trackHeight);
            this.fill.resizeRelocate((double)((int)(this.trackStart - trackRadius)), trackTop, (double)((int)this.trackStart) - trackRadius + this.thumb.getLayoutX(), trackHeight);
            if (this.showTickMarks) {
                this.tickLine.setLayoutX(this.trackStart);
                this.tickLine.setLayoutY(trackTop + trackHeight + this.trackToTickGap);
                this.tickLine.resize(this.trackLength, tickLineHeight);
                this.tickLine.requestAxisLayout();
            } else {
                if (this.tickLine != null) {
                    this.tickLine.resize(0.0, 0.0);
                    this.tickLine.requestAxisLayout();
                }
                this.tickLine = null;
            }
        } else {
            double tickLineWidth = this.showTickMarks ? this.tickLine.prefWidth(-1.0) : 0.0;
            double trackWidth = this.snapSize(this.track.prefWidth(-1.0));
            double trackAreaWidth = Math.max(trackWidth, this.thumbWidth);
            double totalWidthNeeded = trackAreaWidth + (this.showTickMarks ? this.trackToTickGap + tickLineWidth : 0.0);
            double startX = x + (w - totalWidthNeeded) / 2.0;
            this.trackLength = this.snapSize(h - this.thumbHeight);
            this.trackStart = this.snapPosition(y + this.thumbHeight / 2.0);
            double trackLeft = (int)(startX + (trackAreaWidth - trackWidth) / 2.0);
            this.thumbLeft = (int)(startX + (trackAreaWidth - this.thumbWidth) / 2.0);
            this.positionThumb(false);
            this.track.resizeRelocate(trackLeft, (double)((int)(this.trackStart - trackRadius)), trackWidth, (double)((int)(this.trackLength + trackRadius + trackRadius)));
            this.fill.resizeRelocate(trackLeft, (double)((int)this.trackStart) - trackRadius + this.thumb.getLayoutY(), trackWidth, this.trackLength - this.thumb.getLayoutY());
            if (this.showTickMarks) {
                this.tickLine.setLayoutX(trackLeft + trackWidth + this.trackToTickGap);
                this.tickLine.setLayoutY(this.trackStart);
                this.tickLine.resize(tickLineWidth, this.trackLength);
                this.tickLine.requestAxisLayout();
            } else {
                if (this.tickLine != null) {
                    this.tickLine.resize(0.0, 0.0);
                    this.tickLine.requestAxisLayout();
                }
                this.tickLine = null;
            }
        }
    }

    private double minTrackLength() {
        return 2.0 * this.thumb.prefWidth(-1.0);
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Slider s = (Slider)this.getSkinnable();
        if (s.getOrientation() == Orientation.HORIZONTAL) {
            return leftInset + this.minTrackLength() + this.thumb.minWidth(-1.0) + rightInset;
        }
        return leftInset + this.thumb.prefWidth(-1.0) + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        Slider s = (Slider)this.getSkinnable();
        if (s.getOrientation() == Orientation.HORIZONTAL) {
            return topInset + this.thumb.prefHeight(-1.0) + bottomInset;
        }
        return topInset + this.minTrackLength() + this.thumb.prefHeight(-1.0) + bottomInset;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Slider s = (Slider)this.getSkinnable();
        if (s.getOrientation() == Orientation.HORIZONTAL) {
            if (this.showTickMarks) {
                return Math.max(140.0, this.tickLine.prefWidth(-1.0));
            }
            return 140.0;
        }
        return leftInset + Math.max(this.thumb.prefWidth(-1.0), this.track.prefWidth(-1.0)) + (this.showTickMarks ? this.trackToTickGap + this.tickLine.prefWidth(-1.0) : 0.0) + rightInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        Slider s = (Slider)this.getSkinnable();
        if (s.getOrientation() == Orientation.HORIZONTAL) {
            return topInset + Math.max(this.thumb.prefHeight(-1.0), this.track.prefHeight(-1.0)) + (this.showTickMarks ? this.trackToTickGap + this.tickLine.prefHeight(-1.0) : 0.0) + bottomInset;
        }
        if (this.showTickMarks) {
            return Math.max(140.0, this.tickLine.prefHeight(-1.0));
        }
        return 140.0;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            return Double.MAX_VALUE;
        }
        return ((Slider)this.getSkinnable()).prefWidth(-1.0);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            return ((Slider)this.getSkinnable()).prefHeight(width);
        }
        return Double.MAX_VALUE;
    }

    private BooleanProperty showValueOnInteractionProperty() {
        return this.showValueOnInteraction;
    }

    private boolean isShowValueOnInteraction() {
        return this.showValueOnInteraction.get();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return SliderSkin.getClassCssMetaData();
    }

    static {
        ArrayList<CssMetaData<Slider, Boolean>> styleables = new ArrayList<CssMetaData<Slider, Boolean>>(SkinBase.getClassCssMetaData());
        styleables.add(SHOW_VALUE_ON_INTERACTION_META_DATA);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }
}

