/*
 * Decompiled with CFR 0.152.
 */
package impl.jfxtras.styles.jmetro;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.scene.control.skin.TextFieldSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class TextFieldWithButtonSkin
extends TextFieldSkin {
    private static final String RIGHT_BUTTON_VISIBLE_PROPERTY_NAME = "-right-button-visible";
    private InvalidationListener textChanged = observable -> this.onTextChanged();
    private InvalidationListener focusChanged = observable -> this.onFocusChanged();
    private InvalidationListener rightButtonVisibleChanged = observable -> this.onRightButtonVisibilityChanged();
    private StackPane rightButton;
    private Region rightButtonGraphic;
    protected TextField textField;
    private static final CssMetaData<TextField, Boolean> RIGHT_BUTTON_VISIBLE_META_DATA = new CssMetaData<TextField, Boolean>("-right-button-visible", BooleanConverter.getInstance(), Boolean.valueOf(true)){

        public boolean isSettable(TextField textField) {
            TextFieldWithButtonSkin skin = (TextFieldWithButtonSkin)textField.getSkin();
            return !skin.rightButtonVisible.isBound();
        }

        public StyleableProperty<Boolean> getStyleableProperty(TextField textField) {
            TextFieldWithButtonSkin skin = (TextFieldWithButtonSkin)textField.getSkin();
            return (StyleableProperty)skin.rightButtonVisibleProperty();
        }
    };
    private BooleanProperty rightButtonVisible = new SimpleStyleableBooleanProperty(RIGHT_BUTTON_VISIBLE_META_DATA, true);
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public TextFieldWithButtonSkin(TextField textField) {
        super(textField);
        this.textField = textField;
        this.rightButton = new StackPane();
        this.rightButton.getStyleClass().setAll((Object[])new String[]{"right-button"});
        this.rightButton.setFocusTraversable(false);
        this.rightButtonGraphic = new Region();
        this.rightButtonGraphic.getStyleClass().setAll((Object[])new String[]{"right-button-graphic"});
        this.rightButtonGraphic.setFocusTraversable(false);
        this.rightButtonGraphic.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.rightButtonGraphic.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.rightButton.setVisible(false);
        this.rightButtonGraphic.setVisible(false);
        this.rightButton.getChildren().add((Object)this.rightButtonGraphic);
        this.getChildren().add((Object)this.rightButton);
        this.setupListeners();
    }

    private BooleanProperty rightButtonVisibleProperty() {
        return this.rightButtonVisible;
    }

    private boolean getRightButtonVisible() {
        return this.rightButtonVisible.get();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TextFieldWithButtonSkin.getClassCssMetaData();
    }

    private void setupListeners() {
        TextField textField = (TextField)this.getSkinnable();
        this.rightButton.setOnMousePressed(event -> this.onRightButtonPressed());
        this.rightButton.setOnMouseReleased(event -> this.onRightButtonReleased());
        textField.textProperty().addListener(this.textChanged);
        textField.focusedProperty().addListener(this.focusChanged);
        this.rightButtonVisible.addListener(this.rightButtonVisibleChanged);
    }

    protected void onTextChanged() {
        this.updateRightButtonVisibility();
    }

    protected void onFocusChanged() {
        this.updateRightButtonVisibility();
    }

    protected void onRightButtonVisibilityChanged() {
        this.updateRightButtonVisibility();
    }

    private void updateRightButtonVisibility() {
        if (this.textField.getText() == null) {
            return;
        }
        boolean hasFocus = this.textField.isFocused();
        boolean isEmpty = this.textField.getText().isEmpty();
        boolean isRightButtonVisible = this.rightButtonVisible.get();
        boolean shouldBeVisible = isRightButtonVisible && hasFocus && !isEmpty;
        this.rightButton.setVisible(shouldBeVisible);
        this.rightButtonGraphic.setVisible(shouldBeVisible);
    }

    protected void onRightButtonPressed() {
    }

    protected void onRightButtonReleased() {
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double clearGraphicWidth = this.snapSize(this.rightButtonGraphic.prefWidth(-1.0));
        double clearButtonWidth = this.rightButton.snappedLeftInset() + clearGraphicWidth + this.rightButton.snappedRightInset();
        this.rightButton.resize(clearButtonWidth, h);
        this.positionInArea((Node)this.rightButton, x + w - clearButtonWidth, y, clearButtonWidth, h, 0.0, HPos.CENTER, VPos.CENTER);
    }

    public void dispose() {
        this.textField.textProperty().removeListener(this.textChanged);
        this.textField.focusedProperty().removeListener(this.focusChanged);
        this.rightButtonVisible.removeListener(this.rightButtonVisibleChanged);
        super.dispose();
    }

    static {
        ArrayList<CssMetaData<TextField, Boolean>> styleables = new ArrayList<CssMetaData<TextField, Boolean>>(SkinBase.getClassCssMetaData());
        styleables.add(RIGHT_BUTTON_VISIBLE_META_DATA);
        styleables.addAll(TextFieldSkin.getClassCssMetaData());
        STYLEABLES = Collections.unmodifiableList(styleables);
    }
}

