/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.styles.jmetro;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ListChangeListener;
import javafx.scene.control.Dialog;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import jfxtras.styles.jmetro.JMetro;

public class FlatDialog<R>
extends Dialog<R> {
    private BooleanProperty iconless = new SimpleBooleanProperty(true);
    private boolean isResettingIcon;

    public static void initDialog(Dialog<?> dialog, boolean iconless) {
        dialog.setTitle("");
        FlatDialog.initDialogIcon(dialog, iconless);
    }

    public static void initDialogIcon(Dialog<?> dialog, boolean isIconless) {
        if (!isIconless) {
            return;
        }
        Stage stage = (Stage)dialog.getDialogPane().getScene().getWindow();
        Image whiteIcon = new Image(JMetro.class.getResource("whiteIcon.png").toExternalForm());
        stage.getIcons().add((Object)whiteIcon);
    }

    public FlatDialog() {
        this.init();
    }

    private void init() {
        FlatDialog.initDialog(this, this.isIconless());
        this.setupDialogIconsListener();
    }

    private void setupDialogIconsListener() {
        Stage stage = (Stage)this.getDialogPane().getScene().getWindow();
        stage.getIcons().addListener(this::dialogIconsChanged);
    }

    private void dialogIconsChanged(ListChangeListener.Change<? extends Image> c) {
        if (this.isResettingIcon) {
            return;
        }
        this.isResettingIcon = true;
        FlatDialog.initDialogIcon(this, this.isIconless());
        this.isResettingIcon = false;
    }

    public boolean isIconless() {
        return this.iconless.get();
    }

    public BooleanProperty iconlessProperty() {
        return this.iconless;
    }

    public void setIconless(boolean iconless) {
        this.iconless.set(iconless);
    }
}

