/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.styles.jmetro;

import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.Scene;
import jfxtras.styles.jmetro.Style;

public class JMetro {
    private static final String BASE_STYLESHEET_URL = JMetro.class.getResource("base.css").toExternalForm();
    private static final String BASE_OTHER_LIBRARIES_STYLESHEET_URL = JMetro.class.getResource("base_other_libraries.css").toExternalForm();
    private static final String BASE_EXTRAS_STYLESHEET_URL = JMetro.class.getResource("base_extras.css").toExternalForm();
    private static final String PANES_STYLESHEET_URL = JMetro.class.getResource("panes.css").toExternalForm();
    private ObjectProperty<Scene> scene = new SimpleObjectProperty<Scene>(){

        protected void invalidated() {
            if (this.get() == null) {
                return;
            }
            JMetro.this.parent.set(null);
            JMetro.this.reApplyTheme();
        }
    };
    private ObjectProperty<Parent> parent = new SimpleObjectProperty<Parent>(){

        protected void invalidated() {
            if (this.get() == null) {
                return;
            }
            JMetro.this.scene.set(null);
            JMetro.this.reApplyTheme();
        }
    };
    private ObjectProperty<Style> style = new SimpleObjectProperty<Style>(Style.LIGHT){

        protected void invalidated() {
            JMetro.this.reApplyTheme();
        }
    };
    private BooleanProperty automaticallyColorPanes = new SimpleBooleanProperty(false){

        protected void invalidated() {
            JMetro.this.reApplyTheme();
        }
    };
    private ObservableList<String> overridingStylesheets = FXCollections.observableArrayList();

    public JMetro() {
        this.overridingStylesheets.addListener(this::overridingStylesheetsChanged);
    }

    public JMetro(Style style) {
        this();
        this.style.set((Object)style);
    }

    public JMetro(Scene scene, Style style) {
        this();
        this.style.set((Object)style);
        this.scene.set((Object)scene);
    }

    public JMetro(Parent parent, Style style) {
        this();
        this.style.set((Object)style);
        this.parent.set((Object)parent);
    }

    public void reApplyTheme() {
        ObservableList<String> stylesheetsList = this.getAppliedStylesheetsList();
        if (stylesheetsList != null) {
            stylesheetsList.remove((Object)Style.LIGHT.getStyleStylesheetURL());
            stylesheetsList.remove((Object)Style.DARK.getStyleStylesheetURL());
            stylesheetsList.remove((Object)PANES_STYLESHEET_URL);
            int baseStylesheetIndex = stylesheetsList.indexOf((Object)BASE_STYLESHEET_URL);
            if (baseStylesheetIndex == -1) {
                this.addBaseStylesheets(stylesheetsList);
                stylesheetsList.add((Object)this.getStyle().getStyleStylesheetURL());
                baseStylesheetIndex = stylesheetsList.indexOf((Object)BASE_STYLESHEET_URL);
            } else {
                stylesheetsList.add(++baseStylesheetIndex, (Object)this.getStyle().getStyleStylesheetURL());
            }
            if (this.isAutomaticallyColorPanes() && !stylesheetsList.contains((Object)PANES_STYLESHEET_URL)) {
                stylesheetsList.add(++baseStylesheetIndex, (Object)PANES_STYLESHEET_URL);
            }
        }
    }

    private void addBaseStylesheets(ObservableList<String> stylesheetsList) {
        stylesheetsList.add((Object)BASE_STYLESHEET_URL);
        stylesheetsList.add((Object)BASE_EXTRAS_STYLESHEET_URL);
        stylesheetsList.add((Object)BASE_OTHER_LIBRARIES_STYLESHEET_URL);
    }

    private void overridingStylesheetsChanged(ListChangeListener.Change<? extends String> changed) {
        ObservableList<String> stylesheetsListBeingApplied = this.getAppliedStylesheetsList();
        while (changed.next()) {
            if (changed.wasRemoved()) {
                for (String stylesheetURL : changed.getRemoved()) {
                    stylesheetsListBeingApplied.remove((Object)stylesheetURL);
                }
            }
            if (!changed.wasAdded()) continue;
            stylesheetsListBeingApplied.addAll((Collection)changed.getAddedSubList());
        }
    }

    private ObservableList<String> getAppliedStylesheetsList() {
        ObservableList stylesheetsList = null;
        if (this.getScene() != null) {
            stylesheetsList = this.getScene().getStylesheets();
        } else if (this.getParent() != null) {
            stylesheetsList = this.getParent().getStylesheets();
        }
        return stylesheetsList;
    }

    public ObservableList<String> getOverridingStylesheets() {
        return this.overridingStylesheets;
    }

    public Style getStyle() {
        return (Style)((Object)this.style.get());
    }

    public ObjectProperty<Style> styleProperty() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style.set((Object)style);
    }

    public Scene getScene() {
        return (Scene)this.scene.get();
    }

    public ObjectProperty<Scene> sceneProperty() {
        return this.scene;
    }

    public void setScene(Scene scene) {
        this.scene.set((Object)scene);
    }

    public Parent getParent() {
        return (Parent)this.parent.get();
    }

    public ObjectProperty<Parent> parentProperty() {
        return this.parent;
    }

    public void setParent(Parent parent) {
        this.parent.set((Object)parent);
    }

    public boolean isAutomaticallyColorPanes() {
        return this.automaticallyColorPanes.get();
    }

    public BooleanProperty automaticallyColorPanesProperty() {
        return this.automaticallyColorPanes;
    }

    public void setAutomaticallyColorPanes(boolean automaticallyColorPanes) {
        this.automaticallyColorPanes.set(automaticallyColorPanes);
    }
}

