/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared;

import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.EventService;
import com.binfer.base.service.ICallback;
import com.binfer.base.service.IEvent;
import com.binfer.base.service.ISpace;
import com.binfer.base.service.LogService;
import com.binfer.base.service.PreferencesService;
import com.binfer.desktop.shared.IUIEvent;
import com.binfer.desktop.shared.ViewHolder;
import com.binfer.desktop.shared.ui.IView;
import com.binfer.desktop.shared.ui.popup.PopupController;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.SystemTray;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextInputDialog;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Popup;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import jfxtras.styles.jmetro.JMetro;
import jfxtras.styles.jmetro.Style;
import resources.RB;

public abstract class BinferApplication
extends Application {
    protected String[] args;
    protected Stage stage;
    protected Scene rootScene;
    BorderPane main;
    protected static ICallback callback;
    private static final Map<String, Object> cache;
    private static BinferApplication instance;

    public abstract void login();

    public abstract void logout(boolean var1);

    protected abstract void onBeforeReady();

    protected abstract void onReady();

    protected abstract String getIconResource();

    public static BinferApplication getInstance() {
        return instance;
    }

    public BinferApplication() throws Exception {
        instance = this;
    }

    public void init() throws Exception {
        super.init();
        List arr = this.getParameters().getRaw();
        try {
            this.args = new String[arr.size()];
            for (int i = 0; i < arr.size(); ++i) {
                this.args[i] = (String)arr.get(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start(Stage stage) throws Exception {
        this.stage = stage;
        this.loadApp();
        this.setView("/com/binfer/desktop/shared/ui/loading.fxml");
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                BinferApplication.this.onBeforeReady();
                return null;
            }
        };
        task.setOnSucceeded(e -> {
            try {
                this.onReady();
            }
            catch (Exception e1) {
                LogService.log("Failed to start app because " + e.toString() + ", " + e.getSource().getMessage(), Level.SEVERE);
                this.showError("Failed to start app because " + e.toString());
            }
        });
        task.setOnFailed(e -> {
            LogService.log("Failed to start because " + e.toString() + ", " + e.getSource().getMessage(), Level.SEVERE);
            this.showError("Failed to start because " + e.toString());
        });
        Thread thread = new Thread((Runnable)task);
        thread.start();
    }

    public Stage getStage() {
        return this.stage;
    }

    private void loadApp() throws Exception {
        try {
            this.stage.getIcons().add((Object)new Image(this.getIconResource()));
            this.stage.setOnCloseRequest(event -> {
                event.consume();
                if (!SystemTray.isSupported() || !BinferProperties.getBooleanProperty("ISINITED", false)) {
                    Platform.exit();
                    System.exit(0);
                } else {
                    this.stage.hide();
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put(ISpace.SUBJECT, "Binfer is running in the background");
                    params.put(ISpace.DESCRIPTION, "Click 'Quit' to close Binfer completely.");
                    EventService.publish(IEvent.EVENT.NOTIFY, params);
                }
            });
            this.main = new BorderPane();
            this.rootScene = new Scene((Parent)this.main);
            JMetro jMetro = new JMetro(Style.LIGHT);
            jMetro.setScene(this.rootScene);
            this.rootScene.getStylesheets().add((Object)"/resources/styles.css");
            this.main.getStyleClass().add((Object)"binfer");
            this.stage.setScene(this.rootScene);
            this.stage.setMinWidth(600.0);
            this.stage.setMinHeight(800.0);
            this.stage.show();
            Platform.runLater(() -> {
                this.stage.setWidth(this.stage.getWidth() + 1.0E-4);
                this.stage.setHeight(this.stage.getHeight() + 1.0E-4);
            });
        }
        catch (Exception e) {
            Alert alert = new Alert(Alert.AlertType.ERROR, e.getMessage(), new ButtonType[0]);
            alert.getDialogPane().setMinWidth(600.0);
            alert.showAndWait();
            System.exit(0);
        }
    }

    public void centerStage() {
        Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
        double x = (screenSize.getWidth() - this.stage.getWidth()) / 2.0;
        double y = (screenSize.getHeight() - this.stage.getHeight()) / 2.0;
        this.stage.setX(x);
        this.stage.setY(y);
    }

    public Point getCenter() {
        Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
        double x = (screenSize.getWidth() - this.stage.getWidth()) / 2.0;
        double y = (screenSize.getHeight() - this.stage.getHeight()) / 2.0;
        return new Point((int)x, (int)y);
    }

    public void setView(String fxmlPath, Object o) {
        try {
            ViewHolder vh = BinferApplication.createView(fxmlPath, o);
            this.main.setCenter((Node)vh.node);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setView(String fxmlPath) {
        this.setView(fxmlPath, "");
    }

    public boolean showYesNoDialog(String desc) {
        boolean confirmed = false;
        try {
            ButtonType yes = new ButtonType("Yes");
            ButtonType no = new ButtonType("No");
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, desc, new ButtonType[]{yes, no});
            Label label = new Label(desc);
            label.setWrapText(true);
            alert.getDialogPane().setContent((Node)label);
            alert.getDialogPane().setMinWidth(600.0);
            Stage alertWindow = (Stage)alert.getDialogPane().getScene().getWindow();
            alertWindow.setOnCloseRequest(event -> alertWindow.close());
            alert.setHeaderText("Please confirm");
            Point center = this.getCenter();
            alert.setX((double)center.x);
            alert.setY((double)center.y);
            Window w = this.getTopmostWindow();
            if (w != null) {
                alert.initOwner(w);
                alert.setX(w.getX());
                alert.setY(w.getY());
            } else {
                alert.initOwner((Window)this.stage);
            }
            alert.showAndWait();
            if (alert.getResult() == yes) {
                confirmed = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return confirmed;
    }

    public String showInputDialog(String title, String header) {
        TextInputDialog dialog = new TextInputDialog();
        dialog.setTitle(title);
        dialog.setHeaderText(header);
        Point center = this.getCenter();
        dialog.setX((double)center.x);
        dialog.setY((double)center.y);
        Window w = this.getTopmostWindow();
        if (w != null) {
            dialog.initOwner(w);
            dialog.setX(w.getX());
            dialog.setY(w.getY());
        } else {
            dialog.initOwner((Window)this.stage);
        }
        Optional result = dialog.showAndWait();
        return (String)result.get();
    }

    public void startWaitCursor() {
        try {
            if (Platform.isFxApplicationThread()) {
                this.stopWaitCursor();
                try {
                    this.stage.getScene().setCursor(Cursor.WAIT);
                }
                catch (Exception exception) {}
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        BinferApplication.this.stopWaitCursor();
                        try {
                            BinferApplication.this.stage.getScene().setCursor(Cursor.WAIT);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopWaitCursor() {
        try {
            if (Platform.isFxApplicationThread()) {
                try {
                    this.stage.getScene().setCursor(Cursor.DEFAULT);
                }
                catch (Exception exception) {}
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BinferApplication.this.stage.getScene().setCursor(Cursor.DEFAULT);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showPopup(String message) {
        this.showPopup(message, null, 150);
    }

    public void showPopup(String message, Node nearControl, int maxWidth) {
        Popup popup = new Popup();
        popup.setAutoFix(true);
        popup.setAutoHide(true);
        popup.setHideOnEscape(true);
        popup.setWidth((double)maxWidth);
        ViewHolder view = BinferApplication.createView(PopupController.VIEW_SHARED_POPUP, message);
        popup.getContent().add((Object)view.node);
        Window w = this.getTopmostWindow();
        if (w == null) {
            popup.show((Window)popup);
        } else {
            popup.show(w, w.getX(), w.getY());
        }
    }

    private Window getTopmostWindow() {
        Window w = null;
        try {
            Iterator itr = Window.impl_getWindows();
            while (itr.hasNext() && !(w = (Window)itr.next()).isShowing()) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return w;
    }

    public void showError(final String message) {
        try {
            if (message.contains("license")) {
                if (Platform.isFxApplicationThread()) {
                    ButtonType upgrade = new ButtonType("Upgrade", ButtonBar.ButtonData.OK_DONE);
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setResult((Object)upgrade);
                    Label label = new Label(message);
                    label.setWrapText(true);
                    alert.getDialogPane().setContent((Node)label);
                    alert.getDialogPane().setMinWidth(600.0);
                    Point center = this.getCenter();
                    alert.setX((double)center.x);
                    alert.setY((double)center.y);
                    alert.setTitle("Error");
                    alert.setHeaderText("Error");
                    Window w = this.getTopmostWindow();
                    if (w != null) {
                        alert.initOwner(w);
                        alert.setX(w.getX());
                        alert.setY(w.getY());
                    } else {
                        alert.initOwner((Window)this.stage);
                    }
                    Optional result = alert.showAndWait();
                    if (result.isPresent()) {
                        alert.close();
                    }
                } else {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ButtonType upgrade = new ButtonType("Upgrade", ButtonBar.ButtonData.OK_DONE);
                            Alert alert = new Alert(Alert.AlertType.ERROR);
                            alert.setResult((Object)upgrade);
                            Label label = new Label(message);
                            label.setWrapText(true);
                            alert.getDialogPane().setContent((Node)label);
                            alert.getDialogPane().setMinWidth(600.0);
                            Point center = BinferApplication.this.getCenter();
                            alert.setX((double)center.x);
                            alert.setY((double)center.y);
                            alert.setTitle("Error");
                            alert.setHeaderText("Error");
                            Window w = BinferApplication.this.getTopmostWindow();
                            if (w != null) {
                                alert.initOwner(w);
                                alert.setX(w.getX());
                                alert.setY(w.getY());
                            } else {
                                alert.initOwner((Window)BinferApplication.this.stage);
                            }
                            Optional result = alert.showAndWait();
                            if (result.isPresent()) {
                                alert.close();
                            }
                        }
                    });
                }
            } else if (Platform.isFxApplicationThread()) {
                ButtonType ok = new ButtonType("Ok");
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setResult((Object)ok);
                Label label = new Label(message);
                label.setWrapText(true);
                alert.getDialogPane().setContent((Node)label);
                alert.getDialogPane().setMinWidth(600.0);
                alert.setTitle("Error");
                alert.setHeaderText("Error");
                Point center = this.getCenter();
                alert.setX((double)center.x);
                alert.setY((double)center.y);
                Window w = this.getTopmostWindow();
                if (w != null) {
                    alert.initOwner(w);
                    alert.setX(w.getX());
                    alert.setY(w.getY());
                } else {
                    alert.initOwner((Window)this.stage);
                }
                alert.showAndWait();
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ButtonType ok = new ButtonType("Ok");
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setResult((Object)ok);
                        Label label = new Label(message);
                        label.setWrapText(true);
                        alert.getDialogPane().setContent((Node)label);
                        alert.getDialogPane().setMinWidth(600.0);
                        alert.setTitle("Error");
                        alert.setHeaderText("Error");
                        Point center = BinferApplication.this.getCenter();
                        alert.setX((double)center.x);
                        alert.setY((double)center.y);
                        Window w = BinferApplication.this.getTopmostWindow();
                        if (w != null) {
                            alert.initOwner(w);
                            alert.setX(w.getX());
                            alert.setY(w.getY());
                        } else {
                            alert.initOwner((Window)BinferApplication.this.stage);
                        }
                        alert.showAndWait();
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showInfo(String message) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        Label label = new Label(message);
        label.setWrapText(true);
        alert.getDialogPane().setContent((Node)label);
        alert.getDialogPane().setMinWidth(600.0);
        Point center = this.getCenter();
        alert.setX((double)center.x);
        alert.setY((double)center.y);
        Window w = this.getTopmostWindow();
        if (w != null) {
            alert.initOwner(w);
            alert.setX(w.getX());
            alert.setY(w.getY());
        } else {
            alert.initOwner((Window)this.stage);
        }
        alert.showAndWait();
    }

    public void showWarning(String message) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        Label label = new Label(message);
        label.setWrapText(true);
        alert.getDialogPane().setContent((Node)label);
        alert.getDialogPane().setMinWidth(600.0);
        Point center = this.getCenter();
        alert.setX((double)center.x);
        alert.setY((double)center.y);
        Window w = this.getTopmostWindow();
        if (w != null) {
            alert.initOwner(w);
            alert.setX(w.getX());
            alert.setY(w.getY());
        } else {
            alert.initOwner((Window)this.stage);
        }
        alert.showAndWait();
    }

    public void openURI(URI uri) {
        try {
            this.startWaitCursor();
            Desktop.getDesktop().browse(uri);
        }
        catch (Exception e) {
            this.showError("Unable to open because " + e.getMessage());
        }
        finally {
            this.stopWaitCursor();
        }
    }

    public void showHelpPageFromRightSideMenu() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BinferApplication.this.startWaitCursor();
                try {
                    BinferApplication.this.openURI(new URI("https://help.binfer.com/portable"));
                }
                catch (Exception exception) {
                }
                finally {
                    BinferApplication.this.stopWaitCursor();
                }
            }
        });
    }

    public static ViewHolder createView(String fxmlPath, Object data) {
        Parent node = null;
        Object controller = null;
        try {
            FXMLLoader loader = new FXMLLoader(BinferApplication.class.getResource(fxmlPath), RB.getGlobalResourceBundle());
            node = (Parent)loader.load();
            controller = loader.getController();
            if (controller != null) {
                node.setUserData(controller);
                if (controller instanceof IView) {
                    ((IView)IView.class.cast(controller)).onCreate(data);
                } else if (controller instanceof ICallback && data != null) {
                    ((ICallback)ICallback.class.cast(controller)).handleEvent(IUIEvent.EVENT.SETPARAMS, data);
                }
            }
        }
        catch (Throwable e) {
            LogService.log("failed to create view: " + fxmlPath + ", err:" + e.getMessage(), Level.SEVERE);
            e.printStackTrace();
        }
        return new ViewHolder(node, controller);
    }

    public static Bounds getBounds(Node n) {
        Bounds bounds = n.getBoundsInLocal();
        Bounds screenBounds = n.localToScreen(bounds);
        return screenBounds;
    }

    public ViewHolder showViewInDialog(String viewName, Object data, String title, String desc, boolean showOkButton, ICallback callback) {
        try {
            Dialog dialog;
            ViewHolder view = BinferApplication.createView(viewName, data);
            view.dialog = dialog = new Dialog();
            dialog.initOwner((Window)this.stage);
            dialog.getDialogPane().setContent((Node)view.node);
            Window window = dialog.getDialogPane().getScene().getWindow();
            window.setOnCloseRequest(event -> {
                window.hide();
                if (callback != null) {
                    callback.handleEvent(IUIEvent.EVENT.VIEW_CLOSED, " ");
                }
            });
            dialog.setTitle(title);
            dialog.setHeaderText(desc);
            dialog.setResizable(true);
            if (showOkButton) {
                dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
                Button okButton = (Button)dialog.getDialogPane().lookupButton(ButtonType.OK);
                okButton.setOnAction(t -> {
                    window.hide();
                    if (callback != null) {
                        callback.handleEvent(IUIEvent.EVENT.VIEW_CLOSED, " ");
                    }
                });
            }
            double height = this.stage.getHeight();
            double width = this.stage.getWidth();
            dialog.getDialogPane().setPrefHeight(height -= 60.0);
            dialog.getDialogPane().setPrefWidth(width -= 60.0);
            double x = this.stage.getX();
            double y = this.stage.getY();
            dialog.setX(x += 15.0);
            dialog.setY(y += 10.0);
            dialog.showAndWait();
            return view;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void applyPrefDimensions() {
        double width = Double.parseDouble(PreferencesService.getPref("framesizewidth", Double.toString(600.0)));
        double height = Double.parseDouble(PreferencesService.getPref("framesizeheight", Double.toString(800.0)));
        if (height <= 0.0) {
            height = 800.0;
        }
        if (width <= 0.0) {
            width = 600.0;
        }
        this.stage.setHeight(height);
        this.stage.setWidth(width);
        int x = 0;
        int y = 0;
        try {
            x = Integer.parseInt(PreferencesService.getPref("framelocationx", "0"));
            y = Integer.parseInt(PreferencesService.getPref("framelocationy", "0"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (x <= 0 || y <= 0) {
            x = 0;
            y = 0;
        }
        this.stage.setX((double)x);
        this.stage.setY((double)y);
    }

    public void savePrefDimensions() {
        PreferencesService.setPref("framesizewidth", Integer.toString((int)this.stage.getWidth()));
        PreferencesService.setPref("framesizeheight", Integer.toString((int)this.stage.getHeight()));
        PreferencesService.setPref("framelocationx", Integer.toString((int)this.stage.getX()));
        PreferencesService.setPref("framelocationy", Integer.toString((int)this.stage.getY()));
        PreferencesService.save();
    }

    public void setTitle(String title) {
        this.stage.setTitle(title);
    }

    public void maximizeScreen() {
        Platform.runLater(() -> {
            Screen screen = Screen.getPrimary();
            Rectangle2D bounds = screen.getVisualBounds();
            this.stage.setX(bounds.getMinX());
            this.stage.setY(bounds.getMinY());
            this.stage.setWidth(bounds.getWidth());
            this.stage.setHeight(bounds.getHeight());
            this.stage.setMaximized(true);
        });
    }

    public static void setCacheObject(String key, Object data) {
        cache.put(key, data);
    }

    public static Object getCacheObject(String key) {
        return cache.get(key);
    }

    public void copyToClipboard(String text) {
        try {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(text);
            clipboard.setContent((Map)content);
            this.showInfo("Device id copied to clipboard.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        cache = new HashMap<String, Object>();
    }
}

