/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared;

import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.DownloadService;
import com.binfer.base.service.IPlatformService;
import com.binfer.base.service.IPreferences;
import com.binfer.desktop.shared.image.IImageUtil;
import com.binfer.desktop.shared.image.ImageUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javax.imageio.ImageIO;

public abstract class GenericPlatformService
implements IPlatformService {
    @Override
    public List<Object> showFileChooser(Object parent) {
        Window _parent = (Window)Window.class.cast(parent);
        FileChooser fileChooser = new FileChooser();
        File f = fileChooser.showOpenDialog(_parent);
        LinkedList<Object> list = new LinkedList<Object>();
        list.add(f);
        return list;
    }

    @Override
    public byte[] getThumbnailBytes(File file, int width, int height) throws Exception {
        BufferedImage originalBufferedImage = null;
        originalBufferedImage = ImageIO.read(file);
        Image scaledImg = originalBufferedImage.getScaledInstance(width, height, 4);
        BufferedImage thumbnail = new BufferedImage(width, height, 1);
        thumbnail.createGraphics().drawImage(scaledImg, 0, 0, null);
        ImageIO.write((RenderedImage)thumbnail, "jpg", DownloadService.getThumbnailFile(file));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)thumbnail, "jpg", baos);
        baos.flush();
        byte[] imageBytes = baos.toByteArray();
        baos.close();
        return imageBytes;
    }

    @Override
    public void createThumbnail(File file, Object o, int width, int height) {
        try {
            ImageUtil.createThumbnail(file, (File)File.class.cast(o), width, height, IImageUtil.FORMAT.JPG);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void showNotification(String arg0, String arg1, boolean arg2, String arg3, Object arg4) {
    }

    @Override
    public void postLogin() {
    }

    @Override
    public void preLogout() {
    }

    @Override
    public void postLogout() {
    }

    @Override
    public File getSystemDir() {
        if (BinferProperties.getProperty(IPreferences.SYSTEMPATH) == null || BinferProperties.getProperty(IPreferences.SYSTEMPATH).isEmpty()) {
            return new File(this.getBaseDir(), "Binfer-Portable");
        }
        return new File(BinferProperties.getProperty(IPreferences.SYSTEMPATH));
    }

    @Override
    public File getDataDir() {
        if (BinferProperties.getProperty(IPreferences.DOWNLOADPATH) == null || BinferProperties.getProperty(IPreferences.DOWNLOADPATH).isEmpty()) {
            return new File(this.getBaseDir(), "Desktop/Binfer-Portable");
        }
        return new File(BinferProperties.getProperty(IPreferences.DOWNLOADPATH));
    }

    private File getBaseDir() {
        File user_home = null;
        try {
            user_home = new File(System.getProperty("user.home"));
        }
        catch (Exception e) {
            user_home = new File("");
        }
        return user_home;
    }
}

